/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.dao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.entity.FacilityBean;
import com.clustercontrol.repository.ejb.entity.FacilityPK;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * Facility(BMP Entity Bean)DAO饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityDAOImpl implements FacilityDAO {
	protected static Log m_log = LogFactory.getLog( FacilityDAOImpl.class );
	
	protected static final String OBJECTCLASS = "objectClass";
	protected static final String BASE_DN = "ou=facility";
	protected static final String OBJECT_CLASS_NODE = "ccNode";
	protected static final String OBJECT_CLASS_SCOPE = "ccScope";
	protected static final String OBJECT_CLASS_FACILITY = "ccFacility";
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#init()
	 */
	public void init() {
		
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#load(com.clustercontrol.repository.ejb.FacilityPK, com.clustercontrol.repository.ejb.FacilityBean)
	 */
	public void load(FacilityPK pk, FacilityBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			clearBean(ejb);
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			
			//dn
			ejb.setDn(pk.getDn());
			//ccFacilityId
			ejb.setFacilityId((String)attrs.get(FacilityAttributeConstant.FACILITYID).get(0));
			//cn
			ejb.setCn((String)attrs.get(FacilityAttributeConstant.CN).get(0));
			//description
			if(attrs.get(FacilityAttributeConstant.DESCRIPTION) != null){
				ejb.setDescription((String)attrs.get(FacilityAttributeConstant.DESCRIPTION).get(0));
			}
			//objectClassΡɤפȽǤ򤹤
			javax.naming.NamingEnumeration objectClass = attrs.get(OBJECTCLASS).getAll();
			while ( objectClass.hasMoreElements() ) {
				String name = (String)objectClass.nextElement();
				if(name.compareTo(OBJECT_CLASS_NODE) == 0){
					ejb.setType(FacilityConstant.TYPE_NODE);
					break;
				}
				else if(name.compareTo(OBJECT_CLASS_SCOPE) == 0){
					ejb.setType(FacilityConstant.TYPE_SCOPE);
					break;
				}
			}
			if(ejb.getType() == FacilityConstant.TYPE_NODE){
				//ccAgentControl
				if(attrs.get(FacilityAttributeConstant.AGENTCONTROL) != null){
					ejb.setAgentControl(stringToBoolean((String)attrs.get(FacilityAttributeConstant.AGENTCONTROL).get(0)));
				}
				//ccAgentWatch
				if(attrs.get(FacilityAttributeConstant.AGENTWATCH) != null){
					ejb.setAgentWatch(stringToBoolean((String)attrs.get(FacilityAttributeConstant.AGENTWATCH).get(0)));
				}
				//ccAgentWatchStatus
				if(attrs.get(FacilityAttributeConstant.AGENTWATCHSTATUS) != null){
					ejb.setAgentWatchStatus(stringToBoolean((String)attrs.get(FacilityAttributeConstant.AGENTWATCHSTATUS).get(0)));
				}
				//ccCharSet
				if(attrs.get(FacilityAttributeConstant.CHARSET) != null){
					ejb.setCharSet((String)attrs.get(FacilityAttributeConstant.CHARSET).get(0));
				}
				//ccCreateTimestamp
				if(attrs.get(FacilityAttributeConstant.CREATETIMESTAMP) != null){
					ejb.setCreateTimestamp(stringToDate((String)attrs.get(FacilityAttributeConstant.CREATETIMESTAMP).get(0)));
				}
				//ccCreatorsName
				if(attrs.get(FacilityAttributeConstant.CREATORSNAME) != null){
					ejb.setCreatorsName((String)attrs.get(FacilityAttributeConstant.CREATORSNAME).get(0));
				}
				//ccDhcpClient
				if(attrs.get(FacilityAttributeConstant.DHCPCLIENT) != null){
					ejb.setDhcpClient(stringToBoolean((String)attrs.get(FacilityAttributeConstant.DHCPCLIENT).get(0)));
				}
				//host
				if(attrs.get(FacilityAttributeConstant.HOST) != null){
					javax.naming.NamingEnumeration hosts = attrs.get(FacilityAttributeConstant.HOST).getAll();
					ArrayList hostList = new ArrayList();
					while ( hosts.hasMoreElements() ) {
						String host = (String)hosts.nextElement();
						hostList.add(host);
					}
					ejb.setHost(hostList);
				}
				//ipNetworkNumber
				if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBER) != null){
					ejb.setIpNetworkNumber((String)attrs.get(FacilityAttributeConstant.IPNETWORKNUMBER).get(0));
				}
				//ccIpNetworkNumberV6
				if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBERV6) != null){
					ejb.setIpNetworkNumberV6((String)attrs.get(FacilityAttributeConstant.IPNETWORKNUMBERV6).get(0));
				}
				//ipProtocolNumber
				if(attrs.get(FacilityAttributeConstant.IPPROTOCOLNUMBER) != null){
					ejb.setIpProtocolNumber(new Integer((String)attrs.get(FacilityAttributeConstant.IPPROTOCOLNUMBER).get(0)));
				}
				//ccIpType
				if(attrs.get(FacilityAttributeConstant.IPTYPE) != null){
					ejb.setIpType(new Integer((String)attrs.get(FacilityAttributeConstant.IPTYPE).get(0)));
				}
				//ccLogWatch
				if(attrs.get(FacilityAttributeConstant.LOGWATCH) != null){
					ejb.setLogWatch(stringToBoolean((String)attrs.get(FacilityAttributeConstant.LOGWATCH).get(0)));
				}
				//ccMachine
				if(attrs.get(FacilityAttributeConstant.MACHINE) != null){
					ejb.setMachine((String)attrs.get(FacilityAttributeConstant.MACHINE).get(0));
				}
				//ccManagerContact
				if(attrs.get(FacilityAttributeConstant.MANAGERCONTACT) != null){
					ejb.setManagerContact((String)attrs.get(FacilityAttributeConstant.MANAGERCONTACT).get(0));
				}
				//ccManagerName
				if(attrs.get(FacilityAttributeConstant.MANAGERNAME) != null){
					ejb.setManagerName((String)attrs.get(FacilityAttributeConstant.MANAGERNAME).get(0));
				}
				//ccModifiersName
				if(attrs.get(FacilityAttributeConstant.MODIFIERSNAME) != null){
					ejb.setModifiersName((String)attrs.get(FacilityAttributeConstant.MODIFIERSNAME).get(0));
				}
				//ccModifyTimestamp
				if(attrs.get(FacilityAttributeConstant.MODIFYTIMESTAMP) != null){
					ejb.setModifyTimestamp(stringToDate((String)attrs.get(FacilityAttributeConstant.MODIFYTIMESTAMP).get(0)));
				}
				//ccNodeName
				if(attrs.get(FacilityAttributeConstant.NODENAME) != null){
					ejb.setNodeName((String)attrs.get(FacilityAttributeConstant.NODENAME).get(0));
				}
				//ccOsName
				if(attrs.get(FacilityAttributeConstant.OSNAME) != null){
					ejb.setOsName((String)attrs.get(FacilityAttributeConstant.OSNAME).get(0));
				}
				//ccOsRelease
				if(attrs.get(FacilityAttributeConstant.OSRELEASE) != null){
					ejb.setOsRelease((String)attrs.get(FacilityAttributeConstant.OSRELEASE).get(0));
				}
				//ccOsVersion
				if(attrs.get(FacilityAttributeConstant.OSVERSION) != null){
					ejb.setOsVersion((String)attrs.get(FacilityAttributeConstant.OSVERSION).get(0));
				}
				//ccPingWatch
				if(attrs.get(FacilityAttributeConstant.PINGWATCH) != null){
					ejb.setPingWatch(stringToBoolean((String)attrs.get(FacilityAttributeConstant.PINGWATCH).get(0)));
				}
				//ccPingWatchStatus
				if(attrs.get(FacilityAttributeConstant.PINGWATCHSTATUS) != null){
					ejb.setPingWatchStatus(stringToBoolean((String)attrs.get(FacilityAttributeConstant.PINGWATCHSTATUS).get(0)));
				}
				//ccPlatform
				if(attrs.get(FacilityAttributeConstant.PLATFORM) != null){
					ejb.setPlatform((String)attrs.get(FacilityAttributeConstant.PLATFORM).get(0));
				}
				//ccStatusWatch
				if(attrs.get(FacilityAttributeConstant.STATUSWATCH) != null){
					ejb.setStatusWatch(stringToBoolean((String)attrs.get(FacilityAttributeConstant.STATUSWATCH).get(0)));
				}
			}
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#store(com.clustercontrol.repository.ejb.FacilityBean)
	 */
	public void store(FacilityBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(ejb.getDn());
			
			javax.naming.directory.Attributes addAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes replaceAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes removeAttrs = 
				new javax.naming.directory.BasicAttributes();
			
			//cn
			if(ejb.getCn() != null){
				replaceAttrs.put(FacilityAttributeConstant.CN, ejb.getCn());
			}
			else if(ejb.getCn() == null){
				removeAttrs.put(FacilityAttributeConstant.CN, null);
			}
			//description
			if(attrs.get(FacilityAttributeConstant.DESCRIPTION) == null && ejb.getDescription() != null){
				addAttrs.put(FacilityAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			else if(attrs.get(FacilityAttributeConstant.DESCRIPTION) != null && ejb.getDescription() == null){
				removeAttrs.put(FacilityAttributeConstant.DESCRIPTION, null);
			}
			else if(attrs.get(FacilityAttributeConstant.DESCRIPTION) != null && ejb.getDescription() != null){
				replaceAttrs.put(FacilityAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			
			if(ejb.getType() == FacilityConstant.TYPE_NODE){
				//ccAgentControl
				if(attrs.get(FacilityAttributeConstant.AGENTCONTROL) == null && ejb.getAgentControl() != null){
					addAttrs.put(FacilityAttributeConstant.AGENTCONTROL, booleanToString(ejb.getAgentControl()));
				}
				else if(attrs.get(FacilityAttributeConstant.AGENTCONTROL) != null && ejb.getAgentControl() == null){
					removeAttrs.put(FacilityAttributeConstant.AGENTCONTROL, null);
				}
				else if(attrs.get(FacilityAttributeConstant.AGENTCONTROL) != null && ejb.getAgentControl() != null){
					replaceAttrs.put(FacilityAttributeConstant.AGENTCONTROL, booleanToString(ejb.getAgentControl()));
				}
				//ccAgentWatch
				if(attrs.get(FacilityAttributeConstant.AGENTWATCH) == null && ejb.getAgentWatch() != null){
					addAttrs.put(FacilityAttributeConstant.AGENTWATCH, booleanToString(ejb.getAgentWatch()));
				}
				else if(attrs.get(FacilityAttributeConstant.AGENTWATCH) != null && ejb.getAgentWatch() == null){
					removeAttrs.put(FacilityAttributeConstant.AGENTWATCH, null);
				}
				else if(attrs.get(FacilityAttributeConstant.AGENTWATCH) != null && ejb.getAgentWatch() != null){
					replaceAttrs.put(FacilityAttributeConstant.AGENTWATCH, booleanToString(ejb.getAgentWatch()));
				}
				//ccAgentWatchStatus
				if(attrs.get(FacilityAttributeConstant.AGENTWATCHSTATUS) == null && ejb.getAgentWatchStatus() != null){
					addAttrs.put(FacilityAttributeConstant.AGENTWATCHSTATUS, booleanToString(ejb.getAgentWatchStatus()));
				}
				else if(attrs.get(FacilityAttributeConstant.AGENTWATCHSTATUS) != null && ejb.getAgentWatchStatus() == null){
					removeAttrs.put(FacilityAttributeConstant.AGENTWATCHSTATUS, null);
				}
				else if(attrs.get(FacilityAttributeConstant.AGENTWATCHSTATUS) != null && ejb.getAgentWatchStatus() != null){
					replaceAttrs.put(FacilityAttributeConstant.AGENTWATCHSTATUS, booleanToString(ejb.getAgentWatchStatus()));
				}
				//ccCharSet
				if(attrs.get(FacilityAttributeConstant.CHARSET) == null && ejb.getCharSet() != null){
					addAttrs.put(FacilityAttributeConstant.CHARSET, ejb.getCharSet());
				}
				else if(attrs.get(FacilityAttributeConstant.CHARSET) != null && ejb.getCharSet() == null){
					removeAttrs.put(FacilityAttributeConstant.CHARSET, null);
				}
				else if(attrs.get(FacilityAttributeConstant.CHARSET) != null && ejb.getCharSet() != null){
					replaceAttrs.put(FacilityAttributeConstant.CHARSET, ejb.getCharSet());
				}
				//ccCreateTimestamp
				if(attrs.get(FacilityAttributeConstant.CREATETIMESTAMP) == null && ejb.getCreateTimestamp() != null){
					addAttrs.put(FacilityAttributeConstant.CREATETIMESTAMP, dateToString(ejb.getCreateTimestamp()));
				}
				else if(attrs.get(FacilityAttributeConstant.CREATETIMESTAMP) != null && ejb.getCreateTimestamp() == null){
					removeAttrs.put(FacilityAttributeConstant.CREATETIMESTAMP, null);
				}
				else if(attrs.get(FacilityAttributeConstant.CREATETIMESTAMP) != null && ejb.getCreateTimestamp() != null){
					replaceAttrs.put(FacilityAttributeConstant.CREATETIMESTAMP, dateToString(ejb.getCreateTimestamp()));
				}
				//ccCreatorsName
				if(attrs.get(FacilityAttributeConstant.CREATORSNAME) == null && ejb.getCreatorsName() != null){
					addAttrs.put(FacilityAttributeConstant.CREATORSNAME, ejb.getCreatorsName());
				}
				else if(attrs.get(FacilityAttributeConstant.CREATORSNAME) != null && ejb.getCreatorsName() == null){
					removeAttrs.put(FacilityAttributeConstant.CREATORSNAME, null);
				}
				else if(attrs.get(FacilityAttributeConstant.CREATORSNAME) != null && ejb.getCreatorsName() != null){
					replaceAttrs.put(FacilityAttributeConstant.CREATORSNAME, ejb.getCreatorsName());
				}
				//ccDhcpClient
				if(attrs.get(FacilityAttributeConstant.DHCPCLIENT) == null && ejb.getDhcpClient() != null){
					addAttrs.put(FacilityAttributeConstant.DHCPCLIENT, booleanToString(ejb.getDhcpClient()));
				}
				else if(attrs.get(FacilityAttributeConstant.DHCPCLIENT) != null && ejb.getDhcpClient() == null){
					removeAttrs.put(FacilityAttributeConstant.DHCPCLIENT, null);
				}
				else if(attrs.get(FacilityAttributeConstant.DHCPCLIENT) != null && ejb.getDhcpClient() != null){
					replaceAttrs.put(FacilityAttributeConstant.DHCPCLIENT, booleanToString(ejb.getDhcpClient()));
				}
				//host
				if(attrs.get(FacilityAttributeConstant.HOST) == null && ejb.getHost() != null){
					javax.naming.directory.Attribute attr =
						new javax.naming.directory.BasicAttribute(FacilityAttributeConstant.HOST);
					ArrayList list = ejb.getHost();
					for(int i = 0; i < list.size(); i++) {
						String host = (String)list.get(i);
						attr.add(i, host);
					}
					addAttrs.put(attr);
				}
				else if(attrs.get(FacilityAttributeConstant.HOST) != null && ejb.getHost() == null){
					removeAttrs.put(FacilityAttributeConstant.HOST, null);
				}
				else if(attrs.get(FacilityAttributeConstant.HOST) != null && ejb.getHost() != null){
					javax.naming.directory.Attribute attr =
						new javax.naming.directory.BasicAttribute(FacilityAttributeConstant.HOST);
					ArrayList list = ejb.getHost();
					for(int i = 0; i < list.size(); i++) {
						String host = (String)list.get(i);
						attr.add(i, host);
					}
					replaceAttrs.put(attr);
				}
				//ipNetworkNumber
				if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBER) == null && ejb.getIpNetworkNumber() != null){
					addAttrs.put(FacilityAttributeConstant.IPNETWORKNUMBER, ejb.getIpNetworkNumber());
				}
				else if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBER) != null && ejb.getIpNetworkNumber() == null){
					removeAttrs.put(FacilityAttributeConstant.IPNETWORKNUMBER, null);
				}
				else if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBER) != null && ejb.getIpNetworkNumber() != null){
					replaceAttrs.put(FacilityAttributeConstant.IPNETWORKNUMBER, ejb.getIpNetworkNumber());
				}
				//ccIpNetworkNumberV6
				if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBERV6) == null && ejb.getIpNetworkNumberV6() != null){
					addAttrs.put(FacilityAttributeConstant.IPNETWORKNUMBERV6, ejb.getIpNetworkNumberV6());
				}
				else if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBERV6) != null && ejb.getIpNetworkNumberV6() == null){
					removeAttrs.put(FacilityAttributeConstant.IPNETWORKNUMBERV6, null);
				}
				else if(attrs.get(FacilityAttributeConstant.IPNETWORKNUMBERV6) != null && ejb.getIpNetworkNumberV6() != null){
					replaceAttrs.put(FacilityAttributeConstant.IPNETWORKNUMBERV6, ejb.getIpNetworkNumberV6());
				}
				//ipProtocolNumber
				if(attrs.get(FacilityAttributeConstant.IPPROTOCOLNUMBER) == null && ejb.getIpProtocolNumber() != null){
					addAttrs.put(FacilityAttributeConstant.IPPROTOCOLNUMBER, ejb.getIpProtocolNumber().toString());
				}
				else if(attrs.get(FacilityAttributeConstant.IPPROTOCOLNUMBER) != null && ejb.getIpProtocolNumber() == null){
					removeAttrs.put(FacilityAttributeConstant.IPPROTOCOLNUMBER, null);
				}
				else if(attrs.get(FacilityAttributeConstant.IPPROTOCOLNUMBER) != null && ejb.getIpProtocolNumber() != null){
					replaceAttrs.put(FacilityAttributeConstant.IPPROTOCOLNUMBER, ejb.getIpProtocolNumber().toString());
				}
				//ccIpType
				if(attrs.get(FacilityAttributeConstant.IPTYPE) == null && ejb.getIpType() != null){
					addAttrs.put(FacilityAttributeConstant.IPTYPE, ejb.getIpType().toString());
				}
				else if(attrs.get(FacilityAttributeConstant.IPTYPE) != null && ejb.getIpType() == null){
					removeAttrs.put(FacilityAttributeConstant.IPTYPE, null);
				}
				else if(attrs.get(FacilityAttributeConstant.IPTYPE) != null && ejb.getIpType() != null){
					replaceAttrs.put(FacilityAttributeConstant.IPTYPE, ejb.getIpType().toString());
				}
				//ccLogWatch
				if(attrs.get(FacilityAttributeConstant.LOGWATCH) == null && ejb.getLogWatch() != null){
					addAttrs.put(FacilityAttributeConstant.LOGWATCH, booleanToString(ejb.getLogWatch()));
				}
				else if(attrs.get(FacilityAttributeConstant.LOGWATCH) != null && ejb.getLogWatch() == null){
					removeAttrs.put(FacilityAttributeConstant.LOGWATCH, null);
				}
				else if(attrs.get(FacilityAttributeConstant.LOGWATCH) != null && ejb.getLogWatch() != null){
					replaceAttrs.put(FacilityAttributeConstant.LOGWATCH, booleanToString(ejb.getLogWatch()));
				}
				//ccMachine
				if(attrs.get(FacilityAttributeConstant.MACHINE) == null && ejb.getMachine() != null){
					addAttrs.put(FacilityAttributeConstant.MACHINE, ejb.getMachine());
				}
				else if(attrs.get(FacilityAttributeConstant.MACHINE) != null && ejb.getMachine() == null){
					removeAttrs.put(FacilityAttributeConstant.MACHINE, null);
				}
				else if(attrs.get(FacilityAttributeConstant.MACHINE) != null && ejb.getMachine() != null){
					replaceAttrs.put(FacilityAttributeConstant.MACHINE, ejb.getMachine());
				}
				//ccManagerContact
				if(attrs.get(FacilityAttributeConstant.MANAGERCONTACT) == null && ejb.getManagerContact() != null){
					addAttrs.put(FacilityAttributeConstant.MANAGERCONTACT, ejb.getManagerContact());
				}
				else if(attrs.get(FacilityAttributeConstant.MANAGERCONTACT) != null && ejb.getManagerContact() == null){
					removeAttrs.put(FacilityAttributeConstant.MANAGERCONTACT, null);
				}
				else if(attrs.get(FacilityAttributeConstant.MANAGERCONTACT) != null && ejb.getManagerContact() != null){
					replaceAttrs.put(FacilityAttributeConstant.MANAGERCONTACT, ejb.getManagerContact());
				}
				//ccManagerName
				if(attrs.get(FacilityAttributeConstant.MANAGERNAME) == null && ejb.getManagerName() != null){
					addAttrs.put(FacilityAttributeConstant.MANAGERNAME, ejb.getManagerName());
				}
				else if(attrs.get(FacilityAttributeConstant.MANAGERNAME) != null && ejb.getManagerName() == null){
					removeAttrs.put(FacilityAttributeConstant.MANAGERNAME, null);
				}
				else if(attrs.get(FacilityAttributeConstant.MANAGERNAME) != null && ejb.getManagerName() != null){
					replaceAttrs.put(FacilityAttributeConstant.MANAGERNAME, ejb.getManagerName());
				}
				//ccModifiersName
				if(attrs.get(FacilityAttributeConstant.MODIFIERSNAME) == null && ejb.getModifiersName() != null){
					addAttrs.put(FacilityAttributeConstant.MODIFIERSNAME, ejb.getModifiersName());
				}
				else if(attrs.get(FacilityAttributeConstant.MODIFIERSNAME) != null && ejb.getModifiersName() == null){
					removeAttrs.put(FacilityAttributeConstant.MODIFIERSNAME, null);
				}
				else if(attrs.get(FacilityAttributeConstant.MODIFIERSNAME) != null && ejb.getModifiersName() != null){
					replaceAttrs.put(FacilityAttributeConstant.MODIFIERSNAME, ejb.getModifiersName());
				}
				//ccModifyTimestamp
				if(attrs.get(FacilityAttributeConstant.MODIFYTIMESTAMP) == null && ejb.getModifyTimestamp() != null){
					addAttrs.put(FacilityAttributeConstant.MODIFYTIMESTAMP, dateToString(ejb.getModifyTimestamp()));
				}
				else if(attrs.get(FacilityAttributeConstant.MODIFYTIMESTAMP) != null && ejb.getModifyTimestamp() == null){
					removeAttrs.put(FacilityAttributeConstant.MODIFYTIMESTAMP, null);
				}
				else if(attrs.get(FacilityAttributeConstant.MODIFYTIMESTAMP) != null && ejb.getModifyTimestamp() != null){
					replaceAttrs.put(FacilityAttributeConstant.MODIFYTIMESTAMP, dateToString(ejb.getModifyTimestamp()));
				}
				//ccNodeName
				if(attrs.get(FacilityAttributeConstant.NODENAME) == null && ejb.getNodeName() != null){
					addAttrs.put(FacilityAttributeConstant.NODENAME, ejb.getNodeName());
				}
				else if(attrs.get(FacilityAttributeConstant.NODENAME) != null && ejb.getNodeName() == null){
					removeAttrs.put(FacilityAttributeConstant.NODENAME, null);
				}
				else if(attrs.get(FacilityAttributeConstant.NODENAME) != null && ejb.getNodeName() != null){
					replaceAttrs.put(FacilityAttributeConstant.NODENAME, ejb.getNodeName());
				}
				//ccOsName
				if(attrs.get(FacilityAttributeConstant.OSNAME) == null && ejb.getOsName() != null){
					addAttrs.put(FacilityAttributeConstant.OSNAME, ejb.getOsName());
				}
				else if(attrs.get(FacilityAttributeConstant.OSNAME) != null && ejb.getOsName() == null){
					removeAttrs.put(FacilityAttributeConstant.OSNAME, null);
				}
				else if(attrs.get(FacilityAttributeConstant.OSNAME) != null && ejb.getOsName() != null){
					replaceAttrs.put(FacilityAttributeConstant.OSNAME, ejb.getOsName());
				}
				//ccOsRelease
				if(attrs.get(FacilityAttributeConstant.OSRELEASE) == null && ejb.getOsRelease() != null){
					addAttrs.put(FacilityAttributeConstant.OSRELEASE, ejb.getOsRelease());
				}
				else if(attrs.get(FacilityAttributeConstant.OSRELEASE) != null && ejb.getOsRelease() == null){
					removeAttrs.put(FacilityAttributeConstant.OSRELEASE, null);
				}
				else if(attrs.get(FacilityAttributeConstant.OSRELEASE) != null && ejb.getOsRelease() != null){
					replaceAttrs.put(FacilityAttributeConstant.OSRELEASE, ejb.getOsRelease());
				}
				//ccOsVersion
				if(attrs.get(FacilityAttributeConstant.OSVERSION) == null && ejb.getOsVersion() != null){
					addAttrs.put(FacilityAttributeConstant.OSVERSION, ejb.getOsVersion());
				}
				else if(attrs.get(FacilityAttributeConstant.OSVERSION) != null && ejb.getOsVersion() == null){
					removeAttrs.put(FacilityAttributeConstant.OSVERSION, null);
				}
				else if(attrs.get(FacilityAttributeConstant.OSVERSION) != null && ejb.getOsVersion() != null){
					replaceAttrs.put(FacilityAttributeConstant.OSVERSION, ejb.getOsVersion());
				}
				//ccPingWatch
				if(attrs.get(FacilityAttributeConstant.PINGWATCH) == null && ejb.getPingWatch() != null){
					addAttrs.put(FacilityAttributeConstant.PINGWATCH, booleanToString(ejb.getPingWatch()));
				}
				else if(attrs.get(FacilityAttributeConstant.PINGWATCH) != null && ejb.getPingWatch() == null){
					removeAttrs.put(FacilityAttributeConstant.PINGWATCH, null);
				}
				else if(attrs.get(FacilityAttributeConstant.PINGWATCH) != null && ejb.getPingWatch() != null){
					replaceAttrs.put(FacilityAttributeConstant.PINGWATCH, booleanToString(ejb.getPingWatch()));
				}
				//ccPingWatchStatus
				if(attrs.get(FacilityAttributeConstant.PINGWATCHSTATUS) == null && ejb.getPingWatchStatus() != null){
					addAttrs.put(FacilityAttributeConstant.PINGWATCHSTATUS, booleanToString(ejb.getPingWatchStatus()));
				}
				else if(attrs.get(FacilityAttributeConstant.PINGWATCHSTATUS) != null && ejb.getPingWatchStatus() == null){
					removeAttrs.put(FacilityAttributeConstant.PINGWATCHSTATUS, null);
				}
				else if(attrs.get(FacilityAttributeConstant.PINGWATCHSTATUS) != null && ejb.getPingWatchStatus() != null){
					replaceAttrs.put(FacilityAttributeConstant.PINGWATCHSTATUS, booleanToString(ejb.getPingWatchStatus()));
				}
				//ccPlatform
				if(attrs.get(FacilityAttributeConstant.PLATFORM) == null && ejb.getPlatform() != null){
					addAttrs.put(FacilityAttributeConstant.PLATFORM, ejb.getPlatform());
				}
				else if(attrs.get(FacilityAttributeConstant.PLATFORM) != null && ejb.getPlatform() == null){
					removeAttrs.put(FacilityAttributeConstant.PLATFORM, null);
				}
				else if(attrs.get(FacilityAttributeConstant.PLATFORM) != null && ejb.getPlatform() != null){
					replaceAttrs.put(FacilityAttributeConstant.PLATFORM, ejb.getPlatform());
				}
				//ccStatusWatch
				if(attrs.get(FacilityAttributeConstant.STATUSWATCH) == null && ejb.getStatusWatch() != null){
					addAttrs.put(FacilityAttributeConstant.STATUSWATCH, booleanToString(ejb.getStatusWatch()));
				}
				else if(attrs.get(FacilityAttributeConstant.STATUSWATCH) != null && ejb.getStatusWatch() == null){
					removeAttrs.put(FacilityAttributeConstant.STATUSWATCH, null);
				}
				else if(attrs.get(FacilityAttributeConstant.STATUSWATCH) != null && ejb.getStatusWatch() != null){
					replaceAttrs.put(FacilityAttributeConstant.STATUSWATCH, booleanToString(ejb.getStatusWatch()));
				}
			}
			//°ѹɲá
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.ADD_ATTRIBUTE, 
					addAttrs);
			//°ѹִ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REPLACE_ATTRIBUTE, 
					replaceAttrs);
			//°ѹʺ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REMOVE_ATTRIBUTE, 
					removeAttrs);
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#remove(com.clustercontrol.repository.ejb.FacilityPK)
	 */
	public void remove(FacilityPK pk) throws RemoveException, EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//ȥ
			ctx.destroySubcontext(pk.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {pk.getDn()};
            apllog.put("SYS", "006", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#create(com.clustercontrol.repository.ejb.FacilityBean)
	 */
	public FacilityPK create(FacilityBean ejb) throws CreateException, EJBException {
		FacilityPK pk = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			// Attributes for new entry
			javax.naming.directory.Attributes attrs =
				new javax.naming.directory.BasicAttributes();
			
			//objectClass
			javax.naming.directory.Attribute attr =
				new javax.naming.directory.BasicAttribute(OBJECTCLASS);
			if(ejb.getType() == FacilityConstant.TYPE_NODE){
				attr.add(0, OBJECT_CLASS_FACILITY);
				attr.add(1, OBJECT_CLASS_NODE);
			}
			else{
				attr.add(0, OBJECT_CLASS_FACILITY);
				attr.add(1, OBJECT_CLASS_SCOPE);
			}
			attrs.put(attr);
			
			//եƥID
			attrs.put(FacilityAttributeConstant.FACILITYID, ejb.getFacilityId());
			//եƥ̾
			attrs.put(FacilityAttributeConstant.CN, ejb.getCn());
			
			// dnʸ
			StringBuffer dn = new StringBuffer();
			dn.append(FacilityAttributeConstant.FACILITYID);
			dn.append("=");
			dn.append(ejb.getFacilityId());
			dn.append(",");
			dn.append(BASE_DN);
			
			//dn
			ejb.setDn(dn.toString());

			//ȥ
			ctx.createSubcontext(ejb.getDn(), attrs);

			pk = new FacilityPK(ejb.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {ejb.getDn()};
            apllog.put("SYS", "005", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
		
		return pk;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		ArrayList ret = new ArrayList();

		m_log.debug("findAll()");
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_FACILITY);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				m_log.debug("findAll() : No Search Result");
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				FacilityPK pk = new FacilityPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findAll() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}
		
		return ret;
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#findAllNode()
	 */
	public Collection findAllNode() throws FinderException {
		ArrayList ret = new ArrayList();

		m_log.debug("findAllNode()");
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_FACILITY);
		search.append(")(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_NODE);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null ) {
				m_log.debug("findAllNode() : No Search Result");
				return null;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				FacilityPK pk = new FacilityPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findAllNode() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}
		
		return ret;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#findByPrimaryKey(com.clustercontrol.repository.ejb.FacilityPK)
	 */
	public FacilityPK findByPrimaryKey(FacilityPK pk) throws FinderException {
		javax.naming.directory.DirContext ctx = null;
		try {
			m_log.debug("findByPrimaryKey() : dn = " + pk.getDn());
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			
			return pk;
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByPrimaryKey() : " + ex.getMessage());
			throw new FinderException("dn=" + pk.getDn() + " not found.");
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#findByFacilityId(java.lang.String)
	 */
	public FacilityPK findByFacilityId(String facilityId) throws FinderException {
		m_log.debug("findByFacilityId() : FacilityId = " + facilityId);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// ̾դ֥Ȥ򸡺
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_FACILITY);
		search.append(")(");
		search.append(FacilityAttributeConstant.FACILITYID);
		search.append("=");
		search.append(facilityId);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		FacilityPK pk = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				throw new FinderException("FacilityId=" + facilityId + " not found.");
			}
			
			javax.naming.directory.SearchResult aResult = null;
			javax.naming.directory.Attributes attrs = null;
			while ( results.hasMoreElements() ) {
				aResult = (javax.naming.directory.SearchResult)results.nextElement();
				attrs = aResult.getAttributes();
				break;
			}
			
			if (attrs == null) {
				throw new FinderException("FacilityId=" + facilityId + " not found.");
			}
			
			pk = new FacilityPK(aResult.getName() + "," + BASE_DN);

		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByFacilityId() : " + e.getMessage());
			throw new FinderException("FacilityId=" + facilityId + " not found.");
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return pk;
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#findNode(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public Collection findNode(
			String facilityId, 
			String facilityName, 
			String description, 
			String ipAddress, 
			String osName, 
			String osRelease, 
			String managerName, 
			String managerContact) throws FinderException {
	    
		ArrayList ret = new ArrayList();
		
		m_log.debug("findNode() : FacilityId = " + facilityId + 
				", FacilityId = " + facilityId + 
				", FacilityName = " + facilityName + 
				", Description = " + description + 
				", ipAddress = " + ipAddress + 
				", osName = " + osName + 
				", osRelease = " + osRelease + 
				", managerName = " + managerName + 
				", managerContact = " + managerContact);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_FACILITY);
		search.append(")(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_NODE);
		// եƥID򸡺ʸ
		if(facilityId != null && facilityId.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.FACILITYID);
			search.append("=");
			search.append(facilityId);
		}
		// եƥ̾򸡺ʸ
		if(facilityName != null && facilityName.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.CN);
			search.append("=");
			search.append(facilityName);
		}
		// 򸡺ʸ
		if(description != null && description.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.DESCRIPTION);
			search.append("=");
			search.append(description);
		}
		// IPɥ쥹򸡺ʸ
		if(ipAddress != null && ipAddress.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.IPNETWORKNUMBER);
			search.append("=");
			search.append(ipAddress);
		}
		// OS̾򸡺ʸ
		if(osName != null && osName.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.OSNAME);
			search.append("=");
			search.append(osName);
		}
		// OS꡼򸡺ʸ
		if(osRelease != null && osRelease.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.OSRELEASE);
			search.append("=");
			search.append(osRelease);
		}
		// Ԥ򸡺ʸ
		if(managerName != null && managerName.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.MANAGERNAME);
			search.append("=");
			search.append(managerName);
		}
		// Ϣ򸡺ʸ
		if(managerContact != null && managerContact.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.MANAGERCONTACT);
			search.append("=");
			search.append(managerContact);
		}
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null ) {
				m_log.debug("findNode() : No Search Result : " + 
				        "FacilityId = " + facilityId + 
				        ", FacilityId = " + facilityId + 
				        ", FacilityName = " + facilityName + 
				        ", Description = " + description + 
				        ", ipAddress = " + ipAddress + 
				        ", osName = " + osName + 
				        ", osRelease = " + osRelease + 
				        ", managerName = " + managerName + 
				        ", managerContact = " + managerContact);
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				FacilityPK pk = new FacilityPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findNode() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}
		
		return ret;
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.FacilityDAO#findByIpAddress(java.lang.String)
	 */
	public Collection findByIpAddress(String ipAddress) throws FinderException {
		ArrayList ret = new ArrayList();
		
		m_log.debug("findByIpAddress() : ipAddress = " + ipAddress);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_FACILITY);
		search.append(")(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_NODE);
		// IPɥ쥹򸡺ʸ
		if(ipAddress != null && ipAddress.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.IPNETWORKNUMBER);
			search.append("=");
			search.append(ipAddress);
		}
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null ) {
				m_log.debug("findByIpAddress() : No Search Result : ipAddress = " + ipAddress);
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				FacilityPK pk = new FacilityPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByIpAddress() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return ret;
	}
	
    /* (non-Javadoc)
     * @see com.clustercontrol.repository.dao.FacilityDAO#findByNodeName(java.lang.String)
     */
    public Collection findByNodeName(String nodeName) throws FinderException {
		ArrayList ret = new ArrayList();
		
		m_log.debug("findByNodeName() : nodeName = " + nodeName);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_FACILITY);
		search.append(")(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_NODE);
		// Ρ̾򸡺ʸ
		if(nodeName != null && nodeName.compareTo("") != 0){
			search.append(")(");
			search.append(FacilityAttributeConstant.NODENAME);
			search.append("=");
			search.append(nodeName);
		}
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null ) {
				m_log.debug("findByNodeName() : No Search Result : nodeName = " + nodeName);
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				FacilityPK pk = new FacilityPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByNodeName() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}
		return ret;
    }
	
	/**
	 * StringBooleanѴ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param value
	 * @return
	 */
	public Boolean stringToBoolean(String value) {
		Boolean ret = null;
		
		if(value.compareTo("TRUE") == 0){
			ret = new Boolean(true);
		}
		else{
			ret = new Boolean(false);;
		}
		
		return ret;
	}
	
	/**
	 * BooleanStringѴ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param value
	 * @return
	 */
	public String booleanToString(Boolean value) {
		String ret = null;
		
		if(value.booleanValue()){
			ret = "TRUE";
		}
		else{
			ret = "FALSE";
		}
		
		return ret;
	}
	
	/**
	 * StringDateѴ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param value
	 * @return
	 */
	public Date stringToDate(String value) {
		Date ret = null;
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

		try {
			ret = formatter.parse(value);
		} catch (ParseException e) {
		}

		return ret;
	}
	
	/**
	 * DateStringѴ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param value
	 * @return
	 */
	public String dateToString(Date value) {
		String ret = null;
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");

		ret = formatter.format(value);


		return ret;
	}
	
	/**
	 * Beanꥢ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param ejb
	 */
	protected void clearBean(FacilityBean ejb){
	    ejb.setAgentControl(null);
	    ejb.setAgentWatch(null);
	    ejb.setAgentWatchStatus(null);
	    ejb.setCharSet(null);
	    ejb.setCn(null);
	    ejb.setCreateTimestamp(null);
	    ejb.setCreatorsName(null);
	    ejb.setDescription(null);
	    ejb.setDhcpClient(null);
	    ejb.setDn(null);
	    ejb.setFacilityId(null);
	    ejb.setHost(null);
	    ejb.setIpNetworkNumber(null);
	    ejb.setIpNetworkNumberV6(null);
	    ejb.setIpProtocolNumber(null);
	    ejb.setIpType(null);
	    ejb.setLogWatch(null);
	    ejb.setMachine(null);
	    ejb.setManagerContact(null);
	    ejb.setManagerName(null);
	    ejb.setModifiersName(null);
	    ejb.setModifyTimestamp(null);
	    ejb.setNodeName(null);
	    ejb.setOsName(null);
	    ejb.setOsRelease(null);
	    ejb.setOsVersion(null);
	    ejb.setPingWatch(null);
	    ejb.setPingWatchStatus(null);
	    ejb.setPlatform(null);
	    ejb.setStatusWatch(null);
	}
}
