/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.dao;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.repository.bean.DeviceInfoAttributeConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoBean;
import com.clustercontrol.repository.ejb.entity.DeviceInfoPK;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * DeviceInfo(BMP Entity Bean)DAO饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeviceInfoDAOImpl implements DeviceInfoDAO {
	protected static Log m_log = LogFactory.getLog( DeviceInfoDAOImpl.class );
	
	protected static final String OBJECTCLASS = "objectClass";
	protected static final String BASE_DN = "ou=facility";
	protected static final String OBJECT_CLASS_DEVICE_INFO = "ccDeviceInfo";
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#init()
	 */
	public void init() {

	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#load(com.clustercontrol.repository.ejb.DeviceInfoPK, com.clustercontrol.repository.ejb.DeviceInfoBean)
	 */
	public void load(DeviceInfoPK pk, DeviceInfoBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			clearBean(ejb);
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());

			//dn
			ejb.setDn(pk.getDn());
			//cn
			ejb.setCn((String)attrs.get(DeviceInfoAttributeConstant.CN).get(0));
			//ccSnmpOID
			if(attrs.get(DeviceInfoAttributeConstant.SNMPOID) != null){
				ejb.setSnmpOID((String)attrs.get(DeviceInfoAttributeConstant.SNMPOID).get(0));
			}
			//ccDeviceIndex
			if(attrs.get(DeviceInfoAttributeConstant.DEVICEINDEX) != null){
				ejb.setDeviceIndex(new Integer((String)attrs.get(DeviceInfoAttributeConstant.DEVICEINDEX).get(0)));
			}
			//ccDeviceType
			if(attrs.get(DeviceInfoAttributeConstant.DEVICETYPE) != null){
				ejb.setDeviceType((String)attrs.get(DeviceInfoAttributeConstant.DEVICETYPE).get(0));
			}
			//description
			if(attrs.get(DeviceInfoAttributeConstant.DESCRIPTION) != null){
				ejb.setDescription((String)attrs.get(DeviceInfoAttributeConstant.DESCRIPTION).get(0));
			}
			
			//dnեƥIDФ
			String dn = ejb.getDn();
			dn = dn.replaceFirst("[\\s\\w=]*,", "");
			dn = dn.replaceFirst(",[\\s\\w=]*", "");
			dn = dn.replaceFirst(DeviceInfoAttributeConstant.FACILITYID + "=", "");
			ejb.setFacilityId(dn);
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#store(com.clustercontrol.repository.ejb.DeviceInfoBean)
	 */
	public void store(DeviceInfoBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(ejb.getDn());
			
			javax.naming.directory.Attributes addAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes replaceAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes removeAttrs = 
				new javax.naming.directory.BasicAttributes();
			
			//description
			if(attrs.get(DeviceInfoAttributeConstant.DESCRIPTION) == null && ejb.getDescription() != null){
				addAttrs.put(DeviceInfoAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			else if(attrs.get(DeviceInfoAttributeConstant.DESCRIPTION) != null && ejb.getDescription() == null){
				removeAttrs.put(DeviceInfoAttributeConstant.DESCRIPTION, null);
			}
			else if(attrs.get(DeviceInfoAttributeConstant.DESCRIPTION) != null && ejb.getDescription() != null){
				replaceAttrs.put(DeviceInfoAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			//ccSnmpOID
			if(attrs.get(DeviceInfoAttributeConstant.SNMPOID) == null && ejb.getSnmpOID() != null){
				addAttrs.put(DeviceInfoAttributeConstant.SNMPOID, ejb.getSnmpOID());
			}
			else if(attrs.get(DeviceInfoAttributeConstant.SNMPOID) != null && ejb.getSnmpOID() == null){
				removeAttrs.put(DeviceInfoAttributeConstant.SNMPOID, null);
			}
			else if(attrs.get(DeviceInfoAttributeConstant.SNMPOID) != null && ejb.getSnmpOID() != null){
				replaceAttrs.put(DeviceInfoAttributeConstant.SNMPOID, ejb.getSnmpOID());
			}
			//ccDeviceIndex
			if(attrs.get(DeviceInfoAttributeConstant.DEVICEINDEX) == null && ejb.getDeviceIndex() != null){
				addAttrs.put(DeviceInfoAttributeConstant.DEVICEINDEX, ejb.getDeviceIndex().toString());
			}
			else if(attrs.get(DeviceInfoAttributeConstant.DEVICEINDEX) != null && ejb.getDeviceIndex() == null){
				removeAttrs.put(DeviceInfoAttributeConstant.DEVICEINDEX, null);
			}
			else if(attrs.get(DeviceInfoAttributeConstant.DEVICEINDEX) != null && ejb.getDeviceIndex() != null){
				replaceAttrs.put(DeviceInfoAttributeConstant.DEVICEINDEX, ejb.getDeviceIndex().toString());
			}
			//ccDeviceType
			if(attrs.get(DeviceInfoAttributeConstant.DEVICETYPE) == null && ejb.getDeviceType() != null){
				addAttrs.put(DeviceInfoAttributeConstant.DEVICETYPE, ejb.getDeviceType());
			}
			else if(attrs.get(DeviceInfoAttributeConstant.DEVICETYPE) != null && ejb.getDeviceType() == null){
				removeAttrs.put(DeviceInfoAttributeConstant.DEVICETYPE, null);
			}
			else if(attrs.get(DeviceInfoAttributeConstant.DEVICETYPE) != null && ejb.getDeviceType() != null){
				replaceAttrs.put(DeviceInfoAttributeConstant.DEVICETYPE, ejb.getDeviceType());
			}
			//°ѹɲá
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.ADD_ATTRIBUTE, 
					addAttrs);
			//°ѹִ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REPLACE_ATTRIBUTE, 
					replaceAttrs);
			//°ѹʺ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REMOVE_ATTRIBUTE, 
					removeAttrs);
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#remove(com.clustercontrol.repository.ejb.DeviceInfoPK)
	 */
	public void remove(DeviceInfoPK pk) throws RemoveException, EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//ȥ
			ctx.destroySubcontext(pk.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {pk.getDn()};
            apllog.put("SYS", "004", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#create(com.clustercontrol.repository.ejb.DeviceInfoBean)
	 */
	public DeviceInfoPK create(DeviceInfoBean ejb) throws CreateException, EJBException {
		DeviceInfoPK pk = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			// Attributes for new entry
			javax.naming.directory.Attributes attrs =
				new javax.naming.directory.BasicAttributes();
			
			attrs.put(OBJECTCLASS, OBJECT_CLASS_DEVICE_INFO);
			attrs.put(DeviceInfoAttributeConstant.CN, ejb.getCn());
			
			// dnʸ
			StringBuffer dn = new StringBuffer();
			dn.append(DeviceInfoAttributeConstant.CN);
			dn.append("=");
			dn.append(ejb.getCn());
			dn.append(",");
			dn.append(DeviceInfoAttributeConstant.FACILITYID);
			dn.append("=");
			dn.append(ejb.getFacilityId());
			dn.append(",");
			dn.append(BASE_DN);
			
			//dn
			ejb.setDn(dn.toString());

			//ȥ
			ctx.createSubcontext(ejb.getDn(), attrs);

			pk = new DeviceInfoPK(ejb.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {ejb.getDn()};
            apllog.put("SYS", "003", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
		return pk;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		ArrayList ret = new ArrayList();

		m_log.debug("findAll()");
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_DEVICE_INFO);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null ) {
				m_log.debug("findAll() : No Search Result");
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = (javax.naming.directory.SearchResult)results.nextElement();
				DeviceInfoPK pk = new DeviceInfoPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findAll() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return ret;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#findByPrimaryKey(com.clustercontrol.repository.ejb.FacilityPK)
	 */
	public DeviceInfoPK findByPrimaryKey(DeviceInfoPK pk) throws FinderException {
		javax.naming.directory.DirContext ctx = null;
		try {
			m_log.debug("findByPrimaryKey() : dn = " + pk.getDn());
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			
			return pk;
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByPrimaryKey() : " + ex.getMessage());
			throw new FinderException("dn=" + pk.getDn() + " not found.");
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#findByFacilityId(java.lang.String)
	 */
	public Collection findByFacilityId(String facilityId) throws FinderException {
		ArrayList ret = new ArrayList();

		m_log.debug("findByFacilityId() : FacilityId = " + facilityId);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// dnʸ
		StringBuffer baseDn = new StringBuffer();
		baseDn.append(DeviceInfoAttributeConstant.FACILITYID);
		baseDn.append("=");
		baseDn.append(facilityId);
		baseDn.append(",");
		baseDn.append(BASE_DN);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_DEVICE_INFO);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(baseDn.toString(), search.toString(), constraints);
			
			if (results == null ) {
				m_log.debug("findByFacilityId() : No Search Result : FacilityId = " + facilityId);
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = (javax.naming.directory.SearchResult)results.nextElement();
				DeviceInfoPK pk = new DeviceInfoPK(aResult.getName() + "," + baseDn.toString());
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByFacilityId() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return ret;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.repository.dao.DeviceInfoDAO#findByFacilityIdAndName(java.lang.String, java.lang.String)
	 */
	public DeviceInfoPK findByFacilityIdAndName(String facilityId, String name) throws FinderException {
		m_log.debug("findByFacilityIdAndName() : FacilityId = " + facilityId + ", FacilityName = " + name);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// dnʸ
		StringBuffer baseDn = new StringBuffer();
		baseDn.append(DeviceInfoAttributeConstant.FACILITYID);
		baseDn.append("=");
		baseDn.append(facilityId);
		baseDn.append(",");
		baseDn.append(BASE_DN);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_DEVICE_INFO);
		search.append(")(");
		search.append(DeviceInfoAttributeConstant.CN);
		search.append("=");
		search.append(name);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		DeviceInfoPK pk = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(baseDn.toString(), search.toString(), constraints);
			
			//̤
			if ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = (javax.naming.directory.SearchResult)results.nextElement();
				pk = new DeviceInfoPK(aResult.getName() + "," + baseDn.toString());
			}
			else{
				throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
			}
			
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByFacilityIdAndName() : " + ex.getMessage());
			throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}
		
		return pk;
	}
	
	/**
	 * Beanꥢ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param ejb
	 */
	protected void clearBean(DeviceInfoBean ejb){
	    ejb.setCn(null);
	    ejb.setDescription(null);
	    ejb.setDeviceIndex(null);
	    ejb.setDeviceType(null);
	    ejb.setDn(null);
	    ejb.setFacilityId(null);
	    ejb.setSnmpOID(null);
	}
}
