/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.action.ModifyScopeProperty;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.dialog.ScopeCreateDialog;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.util.Messages;

/**
 * פκѹˤ롢ѹԤ󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeModifyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.ScopeModifyAction";

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // װꡢ򤵤Ƥ륢ƥ
        // ץĥ꡼ꡢ򤵤Ƥ륹פ
        ScopeListView view = (ScopeListView) this.viewPart
                .getAdapter(ScopeListView.class);

        FacilityTreeComposite tree = view.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)view.getListComposite();
        
        FacilityTreeItem item = null;
        if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
        }
        else if(list.getTableViewer().getTable().isFocusControl()){
        	item = list.getSelectItem();
        }
        else{
        	return;
        }

        // ̤ξϡλ
        if (item == null) {
            return;
        }
        // ݥåȡΡɤ򤷤Ƥϡλ
        FacilityInfo info = item.getData();
        if (item == null || info.getType() == FacilityConstant.TYPE_COMPOSITE
                || info.getType() == FacilityConstant.TYPE_NODE) {
            return;
        }

        // 
        String facilityId = info.getFacilityId();
        ScopeCreateDialog dialog = new ScopeCreateDialog(this.viewPart
                .getSite().getShell(), facilityId, true);

        // ˤѹ򤵤줿硢ƤäϿԤ
        if (dialog.open() == IDialogConstants.OK_ID) {
            Property property = dialog.getInputData();

            if (new ModifyScopeProperty().edit(property)) {
                // 
                MessageBox box = new MessageBox(this.viewPart.getSite()
                        .getShell(), SWT.ICON_INFORMATION);
                box.setText(Messages.getString("successful"));
                box.setMessage(Messages.getString("message.repository.18"));
                box.open();
            } else {
                // 
                MessageBox box = new MessageBox(this.viewPart.getSite()
                        .getShell(), SWT.ICON_ERROR);
                box.setText(Messages.getString("failed"));
                box.setMessage(Messages.getString("message.repository.19"));
                box.open();
            }

            tree.update();
            view.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}