/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.action.ReleaseNode;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.dialog.NodeReleaseDialog;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.util.Messages;

/**
 * Ρˤ롢ΡɤΥ׳ƲԤ󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeReleaseAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.NodeReleaseAction";

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // װꡢ򤵤Ƥ륢ƥ
        // ץĥ꡼ꡢ򤵤Ƥ륹פ
        ScopeListView view = (ScopeListView) this.viewPart
                .getAdapter(ScopeListView.class);

        FacilityTreeComposite tree = view.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)view.getListComposite();
        
        FacilityTreeItem item = null;
        if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
        }
        else if(list.getTableViewer().getTable().isFocusControl()){
        	item = list.getSelectItem();
        }
        else{
        	return;
        }

        // ̤ξϡλ
        if (item == null) {
            return;
        }
        // װʳ򤷤Ƥϡλ
        FacilityInfo info = item.getData();
        if (info.getType() != FacilityConstant.TYPE_SCOPE) {
            return;
        }

        // 
        String facilityId = info.getFacilityId();
        NodeReleaseDialog dialog = new NodeReleaseDialog(this.viewPart
                .getSite().getShell(), facilityId);

        // ˤѹ򤵤줿硢ƤäϿԤ
        if (dialog.open() == IDialogConstants.OK_ID) {
            String[] items = dialog.getFilterItems();

            if (new ReleaseNode().release(facilityId, items)) {
                // 
                MessageBox box = new MessageBox(this.viewPart.getSite()
                        .getShell(), SWT.ICON_INFORMATION);
                box.setText(Messages.getString("successful"));
                box.setMessage(Messages.getString("message.repository.12"));
                box.open();
            } else {
                // 
                MessageBox box = new MessageBox(this.viewPart.getSite()
                        .getShell(), SWT.ICON_ERROR);
                box.setText(Messages.getString("failed"));
                box.setMessage(Messages.getString("message.repository.13"));
                box.open();
            }

            tree.update();
            view.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}