/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.action.GetScopeProperty;
import com.clustercontrol.util.Messages;

/**
 * פκѹ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeCreateDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** ɽΡɤΥեƥID */
    private String facilityId = "";

    /** ѹѥȽ̥ե饰 */
    private boolean isModifyDialog = false;

    /** Ρ°ץѥƥ */
    private PropertySheet propertySheet = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ꤷΥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param facilityId
     *            ɽΡɤΥեƥID
     * @param isModifyDialog
     *            ѹѥȤѤϡtrue
     */
    public ScopeCreateDialog(Shell parent, String facilityId,
            boolean isModifyDialog) {
        super(parent);

        this.facilityId = facilityId;
        this.isModifyDialog = isModifyDialog;
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(450, 400);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages
                .getString("dialog.repository.scope.create.modify"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * °ץѥƥ
         */

        // ٥
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // ץѥƥڤ
        Property property = null;
        if (this.isModifyDialog) {
            property = new GetScopeProperty().getProperty(this.facilityId,
                    PropertyConstant.MODE_MODIFY);
        } else {
            property = new GetScopeProperty().getProperty(null,
                    PropertyConstant.MODE_ADD);
        }
        this.propertySheet.setInput(property);

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ѹѥʤΤ֤ޤ
     * 
     * @return ѹѥξ硢true
     */
    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("register");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}