/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.action.GetNodeProperty;
import com.clustercontrol.repository.bean.NodePropertyConstant;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * Ρɤκѹ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeCreateDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** ɽΡɤΥեƥID */
    private String facilityId = "";

    /** ѹоݥפΥեƥID */
    private String scopeId = "";

    /** ѹѥȽ̥ե饰 */
    private boolean isModifyDialog = false;

    /** ϿˡפǤΥΡɻե饰 */
    private boolean isNodeSelected = true;

    /** Ρñ饸ܥ */
    private Button radioCreateTypeNode = null;

    /** ñ饸ܥ */
    private Button radioCreateTypeScope = null;

    /** ʸɽƥ */
    private Text textScope = null;

    /** ׻ɽܥ */
    private Button buttonScope = null;

    /** Ρ°ץѥƥ */
    private PropertySheet propertySheet = null;
    
    /** ꥢ¹ԥե饰 */
    private boolean isClearDone = false;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ꤷΥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param facilityId
     *            ɽΡɤΥեƥID
     * @param isModifyDialog
     *            ѹѥȤѤϡtrue
     */
    public NodeCreateDialog(Shell parent, String facilityId,
            boolean isModifyDialog) {
        super(parent);

        this.facilityId = facilityId;
        this.isModifyDialog = isModifyDialog;
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages
                .getString("dialog.repository.node.create.modify"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * Ͽˡ
         */

        // 롼
        Group group = new Group(parent, SWT.SHADOW_NONE);
        layout = new GridLayout(1, true);
        group.setLayout(layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        group.setLayoutData(gridData);
        group.setText(Messages.getString("registration.method"));

        // Ρñ
        this.radioCreateTypeNode = new Button(group, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.radioCreateTypeNode.setLayoutData(gridData);
        this.radioCreateTypeNode.setText(Messages
                .getString("registration.method.node.base"));

        // ñ
        this.radioCreateTypeScope = new Button(group, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.radioCreateTypeScope.setLayoutData(gridData);
        this.radioCreateTypeScope.setText(Messages
                .getString("registration.method.scope.base"));

        // ׻
        Composite composite = new Composite(group, SWT.NONE);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        composite.setLayout(rowLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData(gridData);
        // ߡ٥
        Label dummy = new Label(composite, SWT.NONE);
        dummy.setLayoutData(new RowData(12, SizeConstant.SIZE_LABEL_HEIGHT));
        // ʸƥ
        this.textScope = new Text(composite, SWT.BORDER | SWT.LEFT
                | SWT.READ_ONLY);
        this.textScope.setText("");
        this.textScope.setLayoutData(new RowData(300,
                SizeConstant.SIZE_TEXT_HEIGHT));
        this.buttonScope = new Button(composite, SWT.PUSH);
        this.buttonScope.setText(Messages.getString("refer"));
        this.buttonScope.pack();
        if (!this.isModifyDialog) {
            this.buttonScope.setEnabled(false);
        }
        this.buttonScope.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(getParentShell(),
                        true);
                if (dialog.open() == IDialogConstants.OK_ID) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() == FacilityConstant.TYPE_COMPOSITE) {
                        textScope.setText("");
                        scopeId = "";
                    } else {
                        FacilityPath facilityPath = new FacilityPath(
                                ClusterControlUIPlugin.getDefault()
                                        .getSeparator());
                        textScope.setText(facilityPath.getPath(selectItem));
                        scopeId = selectItem.getData().getFacilityId();
                    }
                }
            }
        }

        );

        // ǥեȤǤϥΡñ̤
        this.radioCreateTypeNode.setSelection(true);
        this.textScope.setEnabled(false);
        this.buttonScope.setEnabled(false);

        // 饸ܥΥ٥
        this.radioCreateTypeNode.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                textScope.setEnabled(false);
                buttonScope.setEnabled(false);
            }
        });
        this.radioCreateTypeScope.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                textScope.setEnabled(true);
                buttonScope.setEnabled(true);
            }
        });

        // Ͽξ硢״ϢϻԲĤȤ롣
        if (!this.isModifyDialog) {
            this.radioCreateTypeScope.setEnabled(false);
        }

        /*
         * °ץѥƥ
         */

        // ٥
        Label label = new Label(parent, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);
        this.propertySheet.setCopy(true);

        // ץѥƥڤ
        Property property = null;
        if (this.isModifyDialog) {
            property = new GetNodeProperty().getProperty(this.facilityId,
                    PropertyConstant.MODE_MODIFY);
        } else {
            property = new GetNodeProperty().getProperty(this.facilityId,
                    PropertyConstant.MODE_ADD);
        }
        this.propertySheet.setInput(property);

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ¸Υܥ˲äꥢܥɲäޤ
     * 
     * @param parent
     *            ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
        // ꥢܥ
        this.createButton(parent, IDialogConstants.OPEN_ID, Messages
                .getString("clear"), false);
        this.getButton(IDialogConstants.OPEN_ID).addSelectionListener(
                new SelectionAdapter() {
                    public void widgetSelected(SelectionEvent e) {
                        // ץѥƥڤ
                        Property property = null;
                        if (isModifyDialog()) {
                            property = new GetNodeProperty().getProperty(null,
                                    PropertyConstant.MODE_MODIFY);

                            //եƥID
                            ArrayList list = PropertyUtil.getProperty(property,
                                    NodePropertyConstant.FACILITY_ID);
                            ((Property) list.get(0)).setValue(getFacilityId());
                        } else {
                            property = new GetNodeProperty().getProperty(null,
                                    PropertyConstant.MODE_ADD);
                        }

                        //BooleanǥΥץѥƥnullꤹ
                        PropertyUtil.setPropertyValue(property,
                                PropertyConstant.EDITOR_BOOL, null);

                        setInputData(property);
                        
                        // ꥢ¹ԥե饰 
                        isClearDone = true;
                    }
                });

        super.createButtonsForButtonBar(parent);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
    	ValidateResult result = null;
    	
        this.isNodeSelected = this.radioCreateTypeNode.getSelection();

        if(this.isNodeSelected){
			//եƥIDϥå
	        ArrayList values = PropertyUtil.getPropertyValue(getInputData(), "facilityId");
			String value = (String)values.get(0);
			if(value.compareTo("") == 0){
	            result = new ValidateResult();
	            result.setID(Messages.getString("message.hinemos.1"));
	            result.setMessage(Messages.getString("message.repository.21"));
	            result.setValid(false);
	            return result;
			}
			
			//եƥ̾ϥå
	        values = PropertyUtil.getPropertyValue(getInputData(), "facilityName");
			value = (String)values.get(0);
			if(value.compareTo("") == 0){
	            result = new ValidateResult();
	            result.setID(Messages.getString("message.hinemos.1"));
	            result.setMessage(Messages.getString("message.repository.22"));
	            result.setValid(false);
	            return result;
			}
			
			//Ρ̾ϥå
	        values = PropertyUtil.getPropertyValue(getInputData(), "nodeName");
			value = (String)values.get(0);
			if(value.compareTo("") == 0){
	            result = new ValidateResult();
	            result.setID(Messages.getString("message.hinemos.1"));
	            result.setMessage(Messages.getString("message.repository.23"));
	            result.setValid(false);
	            return result;
			}
        }
        else{
			//פϥå
			if(scopeId.compareTo("") == 0){
	            result = new ValidateResult();
	            result.setID(Messages.getString("message.hinemos.1"));
	            result.setMessage(Messages.getString("message.hinemos.3"));
	            result.setValid(false);
	            return result;
			}
        }

        return result;
    }

    /**
     * ѹѥʤΤ֤ޤ
     * 
     * @return ѹѥξ硢true
     */
    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    /**
     * ϿˡפˤơΡñ̤򤵤Ƥ뤫֤ޤ
     * 
     * @return Ρñ̤򤵤Ƥ硢true
     */
    public boolean isNodeSelected() {
        return this.isNodeSelected;
    }

    /**
     * ѹоݥפΥեƥID֤ޤ
     * 
     * @return ѹоݥפΥեƥID
     */
    public String getScopeId() {
        return this.scopeId;
    }
    
    /**
     * ꥢܥ󤬥åƤ뤫֤ޤ
     * 
     * @return ꥢܥ󤬥åƤ硢true
     */
    public boolean isClearDone() {
        return this.isClearDone;
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * ͤݻǡǥꤷޤ
     * 
     * @param property
     */
    public void setInputData(Property property) {
        propertySheet.setInput(property);
    }

    /**
     * @return Returns the facilityId.
     */
    public String getFacilityId() {
        return facilityId;
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        if (isModifyDialog()) {
            return Messages.getString("modify");
        } else {
            return Messages.getString("register");
        }
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}