/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.GetNodeScope;
import com.clustercontrol.repository.action.GetNodeScopeTableDefine;
import com.clustercontrol.repository.bean.NodeScopeTabelDefine;
import com.clustercontrol.util.Messages;

/**
 * Ρɤγץݥåȥ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeScopeComposite extends Composite {

    // ----- instance ե ----- //

    /** եƥID٥ */
    private Label facilityIdLabel = null;

    /** եƥ̾٥ */
    private Label facilityNameLabel = null;

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public NodeScopeComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance ᥽å ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.facilityIdLabel = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        this.facilityIdLabel.setLayoutData(gridData);

        this.facilityNameLabel = new Label(this, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        this.facilityNameLabel.setLayoutData(gridData);

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeScopeTableDefine.get(),
                NodeScopeTabelDefine.SORT_COLUMN_INDEX,
                NodeScopeTabelDefine.SORT_ORDER);

        this.update();
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * ꤵ줿Ρɤξɽޤ
     * 
     * @param facilityId
     *            եƥID
     * @param facilityName
     *            եƥ̾
     */
    public void update(String facilityId, String facilityName) {
        ArrayList data = null;

        if (facilityId != null) {
            data = new GetNodeScope().getNodeScope(facilityId);
            this.facilityIdLabel.setText(Messages.getString("facility.id")
                    + " : " + facilityId);
        } else {
            this.facilityIdLabel.setText(Messages.getString("facility.id")
                    + " : ");
        }

        if (facilityName != null) {
            this.facilityNameLabel.setText(Messages.getString("facility.name")
                    + " : " + facilityName);
        } else {
            this.facilityNameLabel.setText(Messages.getString("facility.name")
                    + " : ");
        }
        
        if(data == null)
        	data = new ArrayList();

        this.tableViewer.setInput(data);
    }
}