/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.GetNodeList;
import com.clustercontrol.repository.action.GetNodeListTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ʣǽʥΡɰݥåȥ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeFilterComposite extends Composite {

    // ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;

    /** ɽƥ٥ */
    private Label statuslabel = null;

    /** ץ٥ */
    private Label totalLabel = null;

    /**  */
    private Property condition = null;

    /** פΥեƥID */
    private String scopeId = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public NodeFilterComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    /**
     * ꤷפ°Ρɤɽ륤󥹥󥹤֤ޤ
     * <p>
     * 
     * Υ󥹥󥹤Ͼ˸ꤵ줿Ƥɽupdate(NodeFilterProperty) ¹ԤƤɽƤѹϤޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     * @param facilityId
     *            פΥեƥID
     */
    public NodeFilterComposite(Composite parent, int style, String facilityId) {
        super(parent, style);

        this.scopeId = facilityId;
        this.initialize();
    }

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.statuslabel = new Label(this, SWT.LEFT);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.statuslabel.setLayoutData(gridData);

        Table table = new Table(this, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
                | SWT.V_SCROLL | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeListTableDefine.get(), 0, 1);

        this.totalLabel = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.totalLabel.setLayoutData(gridData);

        this.update();
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * ݥåȤ򹹿ޤ
     * <p>
     * 
     * 郎ꤵƤ硢ξ˥ҥåȤΡɤΰ ɽޤ <br>
     * 郎ꤵƤʤϡΡɤɽޤ
     */
    public void update() {
        // ǡ
        ArrayList list = null;
        if (this.scopeId == null) {
            if (this.condition == null) {
                this.statuslabel.setText("");
                list = new GetNodeList().getAll();
            } else {
                this.statuslabel.setText(Messages.getString("filtered.list"));
                list = new GetNodeList().get(this.condition);
            }
        } else {
            this.statuslabel.setText("");
            list = new GetNodeList().get(this.scopeId);
        }

        // ơ֥빹
        this.tableViewer.setInput(list);

        // 󹹿
        String[] args = { String.valueOf(list.size()) };
        String message = null;
        if (this.scopeId == null) {
            if (this.condition == null) {
                message = Messages.getString("records", args);
            } else {
                message = Messages.getString("filtered.records", args);
            }
        } else {
            message = Messages.getString("records", args);
        }
        this.totalLabel.setText(message);
    }

    /**
     * ˥ҥåȤΡɤΰɽޤ
     * <p>
     * 
     * conditionnullξ硢Ρɤɽޤ
     * 
     * @param condition
     *            
     */
    public void update(Property condition) {
        this.condition = condition;

        this.update();
    }
}