/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.quartzmanager.ejb.session;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

import com.clustercontrol.quartzmanager.bean.QuartzConstant;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="QuartzManager"	
 *           jndi-name="QuartzManager"
 *           type="Stateless" 
 *           transaction-type="Container"
 *                    
 * @ejb.permission
 *     unchecked="true"
 *           
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class QuartzManagerBean implements javax.ejb.SessionBean {
	protected static Log m_log = LogFactory.getLog( QuartzManagerBean.class ); 
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * 塼Ͽ
	 * 
	 * @ejb.interface-method
     *     
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param job
	 * @param trigger ȥꥬ
	 * @throws NamingException
	 * @throws SchedulerException
	 */
	public void addSchedule(JobDetail job, Trigger trigger) throws NamingException, SchedulerException {
		m_log.debug("addSchedule() : start");
		
		// QuartzScheduler
		Scheduler scheduler = getScheduler();

		// Scheduler˥֤Ͽ
		scheduler.scheduleJob(job, trigger);
	}
	
    /**
     * 塼
     * 
     * @ejb.interface-method
     *     
	 * @version 2.0.0
	 * @since 2.0.0
     * 
     * @param jobName ̾
     * @param jobGroup ֥롼
     * @throws NamingException
     * @throws SchedulerException
     */
    public void deleteSchedule(String jobName, String jobGroup) throws NamingException, SchedulerException {
        m_log.debug("deleteSchedule() : Job Group =" + jobGroup + "Job Name =" + jobName);
        
        // QuartzScheduler
        Scheduler scheduler = getScheduler();

		// Scheduler饸֤
		scheduler.deleteJob(jobName, jobGroup);
    }
    
    /**
	 * 塼
	 * 
	 * @ejb.interface-method
     *     
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param jobName ̾
     * @param jobGroup ֥롼
	 * @throws NamingException
	 * @throws SchedulerException 
	 */
	public void pauseSchedule(String jobName, String jobGroup) throws NamingException, SchedulerException {
		m_log.debug("deleteSchedule() : Job Group =" + jobGroup + "Job Name =" + jobName);
		
		// QuartzScheduler
		Scheduler scheduler = getScheduler();

		// ֤ݡ
		scheduler.pauseJob(jobName, jobGroup);
	}
    
    /**
	 * ־ܺټ
	 * 
     * @ejb.interface-method
     *     
	 * @version 2.0.0
	 * @since 2.0.0
     * 
	 * @param jobName ̾
     * @param jobGroup ֥롼
     * @return ־ܺ
     * @throws NamingException
     * @throws SchedulerException
     */
	public JobDetail getJobDetail(String jobName, String jobGroup) throws NamingException, SchedulerException {
		m_log.debug("getJobDetail() : Job Group =" + jobGroup + "Job Name =" + jobName);
		
		// QuartzScheduler
		Scheduler scheduler = getScheduler();
	        
		// JobDetail
		JobDetail jobDetail = scheduler.getJobDetail(jobName, jobGroup);
	        
	    return jobDetail;
    }
    
    /**
	 * ̾ꥹȼ
	 * 
     * @ejb.interface-method
     *     
	 * @version 2.0.0
	 * @since 2.0.0
     * 
	 * @param jobGroup ֥롼
     * @return ̾ꥹ
     * @throws NamingException
     * @throws SchedulerException
     */
	public String[] getJobs(String jobGroup) throws NamingException, SchedulerException {
		m_log.debug("getJobs() : Job Group =" + jobGroup);
		
		// QuartzScheduler
		Scheduler scheduler = getScheduler();
	        
        //̾ꥹȼ
		String[] jobs = scheduler.getJobNames(jobGroup);
	        
	    return jobs;
    }
	
	/**
	 * QuartzScheduler
	 * 
	 * @ejb.interface-method
     *     
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return Scheduler
	 * @throws NamingException
	 */
	public Scheduler getScheduler() throws NamingException {

        //QuartzScheduleråå
		InitialContext context = new InitialContext();
		Scheduler scheduler = (Scheduler)context.lookup(QuartzConstant.QUARTZ_NAME);
		
		return scheduler;
	}
}
