/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ץƻץѥƥ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ProcessProperties {
    protected static Log m_log = LogFactory.getLog( ProcessProperties.class );

	private static final String START_SECOND = "10";
	private static final String VALID_SECOND = "15";
    
	private static final String START_SECOND_KEY = "monitor.process.start.second";
	private static final String VALID_SECOND_KEY = "monitor.process.valid.second";
	
	private static ProcessProperties m_instance = null;
	
	/** ץƻͼϻ֡á */
	private int m_startSecond;
	/** SNMPݡ顼ƻ֡á */
	private int m_validSecond;
	
	/**
	 * Υ֥Ȥޤ
	 * 
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return ConnectionManager ͥޥ͡
	 */
	public static ProcessProperties getProperties() {
		if (m_instance==null) {
			m_instance = new ProcessProperties();
		}
		return m_instance;
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private ProcessProperties() {
		this.setValue();
	}
	
	/**
	 * ץƻץѥƥե뤫
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {
		
	    Properties properties = new Properties();
		
		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "process-monitor.properties";
			
			// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
			properties.load(new FileInputStream(propertyFile));
			
			String startSecond = properties.getProperty(START_SECOND_KEY, START_SECOND);
			String validSecond = properties.getProperty(VALID_SECOND_KEY, VALID_SECOND);
			
			m_startSecond = new Integer(startSecond).intValue();
			m_validSecond = new Integer(validSecond).intValue();
			
			
		} catch (Exception e) {
			m_log.error("setValue(): " + e.getMessage());
		}
	}

	/**
	 * @return m_startSecond ᤷޤ
	 */
	public int getStartSecond() {
		return m_startSecond;
	}

	/**
	 * @return m_validSecond ᤷޤ
	 */
	public int getValidSecond() {
		return m_validSecond;
	}
}
