/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.factory.AddMonitorProcess;
import com.clustercontrol.process.factory.DeleteMonitorProcess;
import com.clustercontrol.process.factory.ModifyMonitorProcess;
import com.clustercontrol.process.factory.SelectMonitorProcess;

/**
 * @ejb.bean name="MonitorProcessController"
 *           jndi-name="MonitorProcessController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 */
public abstract class MonitorProcessControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorProcessControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * ץƻϿޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="ProcessMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ξ
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean addProcess(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();

		// ץƻϿ
		AddMonitorProcess process = new AddMonitorProcess();
		return  process.add(info, pri.getName());
	}
	
	/**
	 * ץƻ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="ProcessMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ξ
	 * @return ѹ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean modifyProcess(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();

		// ץƻ򹹿
		ModifyMonitorProcess process = new ModifyMonitorProcess();
		return  process.modify(info, pri.getName());
	}

	/**
	 * ץƻޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="ProcessMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param monitorId ƻID
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean deleteProcess(String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException{

		// ץƻ
		DeleteMonitorProcess process = new DeleteMonitorProcess();
		return  process.delete(MonitorConstant.STRING_PROCESS, monitorId);
	}
	
	/**
	 * ץƻ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="ProcessMonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param monitorId ִƻID
	 * @return ץƻ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public MonitorInfo getProcess(String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {

		// ץƻ
		SelectMonitorProcess process = new SelectMonitorProcess();
		MonitorInfo info = process.getMonitor(MonitorConstant.STRING_PROCESS, monitorId);

		return info;
	}

	/**
	 * ץƻꥹȤ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="ProcessMonitorRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public ArrayList getProcessList() throws CreateException, FinderException, SchedulerException, NamingException {

		// ץƻ
		SelectMonitorProcess process = new SelectMonitorProcess();
		ArrayList list = process.getMonitorList(MonitorConstant.STRING_PROCESS);

		return list;
	}
	
	/**
	 * ץƻΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getProcessListTableDefine(Locale local) {
		
		/** ơ֥ */
		SelectMonitorProcess process = new SelectMonitorProcess();
		ArrayList tableDefine = process.getMonitorListTableDefine(local);

		return tableDefine;
	}
}
