/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorBlockComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.ping.action.GetPing;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.util.Messages;

/**
 * pingƻѹ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PingCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //

    /** ͤݻ륪֥ */
    private MonitorInfo inputData = null;

    /** ͤݻ륪֥ */
    private ValidateResult validateResult = null;
    
    /** ѹоݤδƻID */
    private String monitorId = null;
    
    /** ƻܾ */
    MonitorBasicScopeComposite m_monitorBasic = null;
    
    /** ƻ ʬ */
    private MonitorRuleComposite m_monitorRule = null;
    
    /** ¹Բ */
	protected Combo m_comboRunCount = null;
	
	/** ¹Դֳ֡á */
	protected Combo m_comboRunInterval = null;
		
	/** ॢȡʥߥá */
	protected Text m_comboTimeout = null;
    
    /** ƻñ */
    private MonitorBlockComposite m_monitorBlock = null;
    
    /** ʹƻȽ */
    private NumericValueInfoComposite m_numericValueInfo= null;
    
    /** ξ */
    private NotifyInfoComposite notifyInfo = null;
    
    /** ּ¹ */
    private Button m_checkJobRun = null;
    
    /** ּ¹Ծ */
    private NumericRunJobComposite m_jobRun = null;
    
    /** ͭˤ */
    private Button confirmValid = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public PingCreateDialog(Shell parent) {
        super(parent);
    }

    /**
     * ѹѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param notifyId
     *            ѹID
     */
    public PingCreateDialog(Shell parent, String monitorId) {
        super(parent);

        this.monitorId = monitorId;
    }

    // ----- instance ᥽å ----- //

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.ping.create.modify"));

        // ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        // ƻܾ
        m_monitorBasic = new MonitorBasicScopeComposite(parent, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorBasic.setLayoutData(gridData);
        
        /*
         * ƻ殺롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.rule") + " : ");
        
        // 롼
        Group groupRule = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData(gridData);

        m_monitorRule = new MonitorRuleComposite(groupRule, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorRule.setLayoutData(gridData);
        
        /*
         * å殺롼
         */
        // ٥
        label = new Label(groupRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("check.rule") + " : ");
        
        // 롼
        Group groupCheckRule = new Group(groupRule, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData(gridData);
        
        /*
         * ¹Բ
         */
        // ٥
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("run.count") + " : ");
        // ܥܥå
        this.m_comboRunCount = new Combo(groupCheckRule, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunCount.setLayoutData(gridData);
        this.m_comboRunCount.add(PingRunCountConstant.STRING_COUNT_01);
        this.m_comboRunCount.add(PingRunCountConstant.STRING_COUNT_02);
        
        // 
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ¹Դֳ
         */
        // ٥
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("run.interval") + " : ");
        // ܥܥå
        this.m_comboRunInterval = new Combo(groupCheckRule, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData(gridData);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_01);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_02);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_05);
        
        // 
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ॢ(ߥ)
         */
        // ٥
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("time.out.milli.sec") + " : ");
        // ܥܥå
        this.m_comboTimeout = new Text(groupCheckRule, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboTimeout.addVerifyListener(new PositiveNumberVerifyListener());
        this.m_comboTimeout.setLayoutData(gridData);
        
        // 
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ƻñ̥롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.block") + " : ");
        
        // 롼
        Group groupMonitorBlock = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupMonitorBlock.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupMonitorBlock.setLayoutData(gridData);
        
        // ƻñ̾
        m_monitorBlock = new MonitorBlockComposite(groupMonitorBlock, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorBlock.setLayoutData(gridData);
        
		
		/*
         * Ρñ̤ηȽ롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("def.result.node") + " : ");
        
        // 롼
        Group groupDefResultNode = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupDefResultNode.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupDefResultNode.setLayoutData(gridData);
        
        // Ƚ
        m_numericValueInfo = new NumericValueInfoComposite(groupDefResultNode, 
        		SWT.NONE,
        		false,
        		Messages.getString("ping.reach"),
        		Messages.getString("time.period.milli.sec"),
        		Messages.getString("less"),
        		Messages.getString("less"),
        		NumericValueInfoComposite.INPUT_VERIFICATION_POSITIVE_REAL,
        		NumericValueInfoComposite.INPUT_VERIFICATION_POSITIVE_INTEGER,
        		Float.valueOf(0f),
        		Float.valueOf(100f),
        		Float.valueOf(0f),
        		null);
        
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_numericValueInfo.setLayoutData(gridData);
		
		/*
         * ξ°롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.attribute") + " : ");
        
        // 롼
        Group groupNotifyAttribute = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData(gridData);
        
        // ξIDץꥱID
		this.notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		notifyInfo.setLayoutData(gridData);
		
		// ּ¹
        this.m_checkJobRun = new Button(groupNotifyAttribute, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_checkJobRun.setLayoutData(gridData);
        m_checkJobRun.setText(Messages.getString("run") + " : ");
        m_checkJobRun.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	m_jobRun.setEnabled(m_checkJobRun.getSelection());
            }
        });
		
		// ּ¹ԥ롼
        Group groupRunJob = new Group(groupNotifyAttribute, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRunJob.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData(gridData);
        
        // ¹ԡʼ¹ԡIDϢưƽмԻ
		this.m_jobRun = new NumericRunJobComposite(groupRunJob, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_jobRun.setLayoutData(gridData);
		
        /*
         * ̵ͭ
         */
        this.confirmValid = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData(gridData);
        this.confirmValid.setText(Messages.getString("setting.valid.confirmed"));

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData(gridData);


        // Ŭ
        // åɥ쥤ȤѤ硢ʤȲ̤äѤˤʤޤ
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // IDꤵƤ硢ξɽ롣
        MonitorInfo info = null; 
        if(this.monitorId != null){
        	info = new GetPing().getPing(this.monitorId);        	
        }
        else{
        	info = new MonitorInfo();
        }
        this.setInputData(info);
        
    }

    /**
     * Ƥ֤ޤ
     * 
     * @return Ƥݻξ
     */
    public MonitorInfo getInputData() {
        return this.inputData;
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param monitor
     *            ͤȤѤξ
     */
    protected void setInputData(MonitorInfo monitor) {

        this.inputData = monitor;
        
        // ƻܾ
        m_monitorBasic.setInputData(monitor);
        
        // ƻ
        m_monitorRule.setInputData(monitor);
        
        // ƻ pingƻ
        MonitorPingInfo pingInfo = (MonitorPingInfo)monitor.getCheckInfo();
        if(pingInfo == null){
        	pingInfo = new MonitorPingInfo();
        }
        if (pingInfo.getRunCount() != null) {
            this.m_comboRunCount.setText(PingRunCountConstant.typeToString(pingInfo.getRunCount().intValue()));
        }
        if (pingInfo.getRunInterval() != null) {
            this.m_comboRunInterval.setText(PingRunIntervalConstant.typeToString(pingInfo.getRunInterval().intValue()));
        }
        if (pingInfo.getTimeout() != null) {
            this.m_comboTimeout.setText(pingInfo.getTimeout().toString());
        }
        
        // ƻñ
        m_monitorBlock.setInputData(monitor);
        
        // Ρñ̤ηȽ
        m_numericValueInfo.setInputData(monitor);
    	
        // ξ°
        if (monitor.getNotifyId() != null) {
        	this.notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
        	this.notifyInfo.setApplication(monitor.getApplication());
        }
        
        // ּ¹
        m_checkJobRun.setSelection(YesNoConstant.typeToBoolean(monitor.getJobRun()));
        
        // ƽ٤Υּ¹
        m_jobRun.setInputData(monitor);
        m_jobRun.setEnabled(YesNoConstant.typeToBoolean(monitor.getJobRun()));
        
        // ̵ͭ
        if (monitor.getValid() == ValidConstant.TYPE_VALID) {
            this.confirmValid.setSelection(true);
        }
    }

    /**
     * ͤѤξޤ
     * 
     * @return ͤݻξ
     */
    protected MonitorInfo createInputData() {
    	MonitorInfo info = new MonitorInfo();

    	info.setMonitorTypeId(MonitorConstant.STRING_PING);
    	info.setMonitorType(MonitorTypeConstant.TYPE_NUMERIC);
    	
    	// ƻܾ
    	validateResult = m_monitorBasic.createInputData(info);
    	if(validateResult != null){
        	return null;
        }
        
        // ƻ ʬ
        validateResult = m_monitorRule.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // ƻ pingƻ
        MonitorPingInfo pingInfo = new MonitorPingInfo();
        pingInfo.setMonitorTypeId(MonitorConstant.STRING_PING);
        pingInfo.setMonitorId(info.getMonitorId());
        if (this.m_comboRunCount.getText() != null
                && !"".equals((this.m_comboRunCount.getText()).trim())) {
        	pingInfo.setRunCount(PingRunCountConstant.stringToType(this.m_comboRunCount.getText()));
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.ping.1"));
            return null;
        }
        if (this.m_comboRunInterval.getText() != null
                && !"".equals((this.m_comboRunInterval.getText()).trim())) {
        	pingInfo.setRunInterval(PingRunIntervalConstant.stringToType(this.m_comboRunInterval.getText()));
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.ping.2"));
            return null;
        }
        if (this.m_comboTimeout.getText() != null
                && !"".equals((this.m_comboTimeout.getText()).trim())) {
        	
        	try{
        		Integer timeout = new Integer(this.m_comboTimeout.getText().trim());
            	pingInfo.setTimeout(timeout);
        	}
        	catch(NumberFormatException e){
        		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.ping.3"));
                return null;
        	}
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.ping.3"));
            return null;
        }
        info.setCheckInfo((MonitorCheckInfo)pingInfo);
        
        // ƻñ
        validateResult = m_monitorBlock.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // Ρñ̤ηȽ
        validateResult = m_numericValueInfo.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // ξ°
        if (this.notifyInfo.getText() != null
                && !"".equals((this.notifyInfo.getText()).trim())) {
        	info.setNotifyId(notifyInfo.getText());
        }
//        else{
//        	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.9"));
//            return null;
//        }
        if (this.notifyInfo.getApplication() != null
                && !"".equals((this.notifyInfo.getApplication()).trim())) {
        	info.setApplication(notifyInfo.getApplication());
        }
        else{
        	if (this.notifyInfo.getText() != null
                    && !"".equals((this.notifyInfo.getText()).trim())) {
            	info.setNotifyId(notifyInfo.getText());
            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
                return null;
            }
        }
        
        // ּ¹
        info.setJobRun(YesNoConstant.booleanToType(m_checkJobRun.getSelection()));
        
        // ƽ٤Υּ¹
        validateResult = m_jobRun.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // ͭ/̵
        if (this.confirmValid.getSelection()) {
        	info.setValid(ValidConstant.TYPE_VALID);
        } else {
        	info.setValid(ValidConstant.TYPE_INVALID);
        }

        return info;
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        // 
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /**
     * ̵ͤξꤷޤ
     *  
     */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}