/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.util.Messages;

/**
 * ɥ쥹ãǽɤǧ륯饹Ǥ
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ReachAddress {
	
	protected static Log m_log = LogFactory.getLog( ReachAddress.class );
	
	/**  */
	private int m_sentCount = PingRunCountConstant.TYPE_COUNT_01;
	
	/** ֳ֡ʥߥá */
	private int m_sentInterval = PingRunIntervalConstant.TYPE_SEC_01;
	
	/** ॢȡʥߥá */
    private int m_timeout = 1000;
    
    /** å */
    private String m_message = null;
    
    /** ꥸʥå */
    private String m_messageOrg = null;
    
    /** pingãΨ% */
    private int m_reachRatio = 0;
    
    /** ѥåʶΨ% */
    private int m_lost = 0;
    
    /** ʿѻ֡ʥߥá */
    private long m_average = 0;
    
    // isReachableåɥդǤϤʤᡢƱȤ뤿˻
    private static Object m_syncObj = new Object();

	/**
	 * 󥹥ȥ饯
	 */
	public ReachAddress(int sentNum, int sentInterval, int timeout){
		
		m_sentCount = sentNum;
		m_sentInterval = sentInterval;
		m_timeout = timeout;
	}
	
    /**
     * ɥ쥹ãǽɤƥȤޤ
     * 
     * @param info
     * @return PINGƻ륹ơ
     */
    public boolean isReachable(String ipNetworkNumber, String nodeName) {
    	
    	String addressText = null;
    	if(ipNetworkNumber != null && !"".equals(ipNetworkNumber)){
    		addressText = ipNetworkNumber;
    	}
    	else if(nodeName != null && !"".equals(nodeName)){
    		addressText = nodeName;
    	}
    	else{
    		m_log.debug("isReachable(): " + Messages.getString("message.ping.5"));
    		m_message = Messages.getString("message.ping.5");
    		m_messageOrg = null;
    		return false;
    	}
    	
    	boolean result = this.isReachable(addressText);
        return result;
    }

    /**
     * ꤵ줿ɥ쥹ãǽɤƥȤޤ
     * 
     * @param addressText
     * @return PINGƻ륹ơ
     */
    public boolean isReachable(String addressText) {

    	m_message = null;
        m_messageOrg = null;
        m_reachRatio = 0;
        m_lost = 0;
        m_average = 0;
    	
        try {
            long max = 0;
            long min = 0;
            long sum = 0;
            int num = 0;
            
            // ꥸʥå
            StringBuffer buffer = new StringBuffer();
            
            InetAddress address = InetAddress.getByName(addressText);
            buffer.append("Pinging " + address.getHostName() + " [" + address.getHostAddress() + "].\n\n");

            int i = 0;
            for (; i < m_sentCount; i++) {
                long start = System.currentTimeMillis();

	    		// Reachability Υå ICMP Ѥ
	    		boolean isReachable;
	    		// isReachableåɥդǤϤʤᡢƱ
	    		synchronized (m_syncObj) {
	    			isReachable = address.isReachable(m_timeout);
	    		}
                
                long end = System.currentTimeMillis();
                long time = end - start;

                if (isReachable) {
                	buffer.append("Reply from " + address.getHostAddress() + ": ");

                    sum += time;

                    if (i == 0) {
                        max = time;
                        min = time;
                    } else {
                        if (time > max) {
                            max = time;
                        } else if (time < min) {
                            min = time;
                        }
                    }
                    num++;

                    if (time > 0) {
                    	buffer.append("time=" + time + "ms\n");
                    } else {
                    	buffer.append("time<1ms\n");
                    }
                } else {
                    if (time >= m_timeout) {
                    	buffer.append("Request timed out.\n");
                    } else {
                    	buffer.append("Reply from " + address.getHostAddress() + ": Destination net unreachable.\n");
//                        num++;
                    }
                }
                
                if(i < m_sentCount-1){
                	try {
                        Thread.sleep(m_sentInterval);
                    } catch (InterruptedException e) {
                        break;
                    }
                }
            }

            buffer.append("\nPing statistics for " + address.getHostAddress() + ":\n");
            //ѥåʶΨ
            if (num == 0) {
                m_lost = 100;
            } else {
                m_lost = (i - num) * 100 / i;
            }
            
            //pingãΨ
//          m_reachRatio = num/i * 100 ;
            m_reachRatio = num * 100 /i;
            //å
            m_message = "Packets: Sent = " + i + 
						", Received = " + num + 
						", Lost = " + (i-num) + " (" + m_lost + "% loss),";
            
            buffer.append("\t" + m_message + "\n");
            
            if (num != 0) {
            	buffer.append("Approximate round trip times in milli-seconds:\n");

            	// ʿѻ֡ʥߥá
            	if (num != 0) {
                    m_average = sum / num;
                } else {
                    m_average = 0;
                }
                
                buffer.append("\tMinimum = " + min 
                                   + "ms, Maximum = " + max 
                                   + "ms, Average = " + m_average + "ms\n");
            }
            
            m_messageOrg = buffer.toString();
            return true;

        } catch (UnknownHostException e) {
        	m_log.debug("isReachable(): " + Messages.getString("message.ping.6") + e.getMessage());
        	
    		m_message = Messages.getString("message.ping.6") + " (" + e.getMessage() + ")";
        } catch (IOException e) {
        	m_log.debug("isReachable(): " + Messages.getString("message.ping.6") + e.getMessage());
        	
    		m_message = Messages.getString("message.ping.6") + " (" + e.getMessage() + ")";
        }
        return false;
    }
    
	/**
	 * @return åᤷޤ
	 */
	public String getMessage() {
		return m_message;
	}
	/**
	 * @return ꥸʥᤷޤ
	 */
	public String getMessageOrg() {
		return m_messageOrg;
	}
	/**
	 * @return pingãΨ(%)ᤷޤ
	 */
	public int getReachRatio() {
		return m_reachRatio;
	}
	/**
	 * @return ѥåʶΨ()ᤷޤ
	 */
	public int getLost() {
		return m_lost;
	}
	/**
	 * @return ʿѡʥߥáˤᤷޤ
	 */
	public long getAverage() {
		return m_average;
	}
}
