/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.DeleteMonitorNumericValueType;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;

/**
 * pingƻ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class DeleteMonitorPing extends DeleteMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitorPing.class );

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	public boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {
		
		// pingƻ
		MonitorPingInfoPK pk = new MonitorPingInfoPK(m_monitorId, m_monitorTypeId);
		MonitorPingInfoLocal pingLocal = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// pingƻ
		pingLocal.remove();
        
		return true;
	}
}
