/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performanceMGR.jmx;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;

public class PerformanceRestartManager {
	protected static Log m_log = LogFactory.getLog( PerformanceRestartManager.class );
	
	public void restartAll() {
        try {
        	CollectorHome home = JNDIConnectionManager.getCollectorHome();
        	Collection pks = home.findAll();
        	
        	Iterator itr = pks.iterator();
        	while(itr.hasNext()){
        		Collector collector = (Collector)itr.next();
        		
        		// Ƴޤ
        		boolean restarted = collector.restartCollect();
        		
        		m_log.debug("restart " + collector.getCollectorID() + " " + restarted);
        	}
		} catch (RemoteException e) {
			e.printStackTrace();
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
