/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;
import java.util.ArrayList;

import com.clustercontrol.performanceMGR.bean.DeviceData;

/**
 * ܤοƻҴطݻ桼ƥƥ饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemTreeItem  implements Serializable {
    /** ƥ */
    private CollectorItemCategoryInfo category = null;

    /**  */
    private CollectorItemTreeItem parent = null;

    /** 󥪥֥ */
    private ICollectorItemInfo data = null;

    /** ҤγǼꥹ */
    private ArrayList<CollectorItemTreeItem> childrens = null;
    
    /** ǥХ */
    private DeviceData deviceData = null;

    public CollectorItemTreeItem(
    		CollectorItemTreeItem parent, 
    		ICollectorItemInfo data,
    		DeviceData deviceData) {
    	// ǥХ
       	this.deviceData = deviceData;
       		
    	// ǤܥƥξϡʬȤΥƥꤹ롣
    	if (data instanceof CollectorItemCategoryInfo){
            this.setCategory((CollectorItemCategoryInfo)data);
        } else
        // ǤܥɤξϡƤΥƥƱƥȤ롣
        if (data instanceof CollectorItemCodeInfo) {
            this.setCategory(parent.getCategory());
            this.category.addItem((CollectorItemCodeInfo)data);
        }

        this.setParent(parent);  // Ƥ
        this.setData(data);  // 󥪥֥Ȥ

        if (parent != null) {
            parent.addChildren(this);
        }

        this.childrens = new ArrayList<CollectorItemTreeItem>();
    }
    
    /**
     * Ƥꤷޤ
     * <p>
     * 
     * @return 
     */
    private void setParent(CollectorItemTreeItem parent) {
        this.parent = parent;
    }

    /**
     * Ҥɲäޤ
     * <p>
     * 
     * κݡchildeοƤϤΥ֥ȤȤꤵޤ
     * 
     * @param child
     *            
     */
    private void addChildren(CollectorItemTreeItem child) {
        child.setParent(this);
        childrens.add(child);
    }

    /**
     * ܥɤޤ
     * 
     * @return itemCode ܥ
     */
    public String getItemCode() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).getItemCode();
    	} else {
    		return null;
    	}
    }

    /**
     * ̾ޤ
     * 
     * @return ̾
     */
    public String getItemName() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).getItemName();
    	} else {
    		return null;
    	}
    }

    /**
     * ܺپɽǽݤʻҹܤ뤫ݤˤޤ
     */
    public boolean hasBreakdown() {
        return (childrens.size() != 0);
    }

    /**
     * deviceFlag ޤ
     * 
     * @return deviceFlag
     */
    public boolean isDeviceFlag() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).isDeviceFlag();
    	} else {
    		return false;
    	}
    }

    /**
     * ǥХ̤ޤ
     * 
     * @return deviceType
     */
    public String getDeviceType() {
        return ((CollectorItemCodeInfo)data).getDeviceType();
    }
    
    /**
     * isRangeFixed ޤ
     * 
     * @return isRangeFixed
     */
    public boolean isRangeFixed() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).isRangeFixed();
    	} else {
    		return false;
    	}
    }

    /**
     * measure ޤ
     * 
     * @return measure
     */
    public String getMeasure() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).getMeasure();
    	} else{
    		return null;
    	}
    }

    /**
     * category ޤ
     * 
     * @return category
     */
    public CollectorItemCategoryInfo getCategory() {
        return category;
    }

    /**
     * category ꤷޤ
     * 
     * @param category
     */
    private void setCategory(CollectorItemCategoryInfo category) {
        this.category = category;
    }

    /**
     * childrens ޤ
     * 
     * @return childrens
     */
    public ArrayList getChildrens() {
        return childrens;
    }

    /**
     * childrens ꤷޤ
     * 
     * @param childrens
     */
//    private void setChildrens(ArrayList childrens) {
//        this.childrens = childrens;
//    }

    /**
     * data ޤ
     * 
     * @return data
     */
    public ICollectorItemInfo getData() {
        return data;
    }

    /**
     * data ꤷޤ
     * 
     * @param data
     */
    private void setData(ICollectorItemInfo data) {
        this.data = data;
    }

    /**
     * parent ޤ
     * 
     * @return parent
     */
    public CollectorItemTreeItem getParent() {
        return parent;
    }
    
    
    
    
    
    
    
    
    
    
	public int size() {
		return childrens.size();
	}
	
	public DeviceData getDeviceData(){
		return deviceData;
	}
}