/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.util.Messages;
import com.clustercontrol.performanceMGR.util.Repository;

/**
 * ܥɤξեȥꥯ饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCodeTable {
	private static final ArrayList<CollectorItemCategoryInfo> m_categoryList; // ƥΥꥹ
	private static final ArrayList<CollectorItemTreeItem> m_itemTree; // ܤΥĥ꡼
	private static final HashMap<String, CollectorItemTreeItem> m_codeTable; // ܥɤ
	
	public CollectorItemCodeTable() {
	}
	
	static {
		m_categoryList = new ArrayList<CollectorItemCategoryInfo>();
		m_itemTree = new ArrayList<CollectorItemTreeItem>();
		m_codeTable = new HashMap<String, CollectorItemTreeItem>();
		
		// ƥꥳɤ饫ƥ򻲾Ȥ뤿Υơ֥
		HashMap<String, CollectorItemTreeItem> categoryTable = 
			new HashMap<String, CollectorItemTreeItem>();
		
		// եɤ߹
		Properties properties = new Properties();
		
		try {
			// ǥեȥ
			Locale locale = Locale.getDefault();
			
			String homeDir = System.getProperty("jboss.server.home.dir");
			String confDir = homeDir + File.separator + "conf" + File.separator;
			String propertyFile;
			// 줬ܸξ
			if(locale.getLanguage().equals("ja")){
				propertyFile = confDir + "performance_ja.properties";
			} else { // ܸʳξ
				propertyFile = confDir + "performance.properties";
			}
			
			// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
			properties.load(new FileInputStream(propertyFile));
			
			// ƥɤ߹
			int num = Integer.parseInt(properties.getProperty("collector.category.num"));
			for(int i=0; i < num; i++){
				String categoryCode = properties.getProperty("collector.category.code." + i);
				String categoryName = properties.getProperty("collector.category.name." + i);
				if(categoryCode != null && categoryName != null){
					CollectorItemCategoryInfo category = new CollectorItemCategoryInfo(categoryCode, categoryName);
					m_categoryList.add(category);
					
					CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null);  // ƤǤϤʤnull
					m_itemTree.add(categoryItem);
					
					// ƥꥳɤǥƥϿ
					categoryTable.put(categoryCode, categoryItem);
				}
			}
			
			// ܥɤɤ߹
			num = Integer.parseInt(properties.getProperty("collector.item.num"));
			
			for(int i=0; i < num; i++){
				String itemCode = properties.getProperty("collector.item.code." + i);
				String categoryCode = properties.getProperty("collector.item.category.code." + i);
				String parentCode = properties.getProperty("collector.item.parent.code." + i);
				String itemName = properties.getProperty("collector.item.name." + i);
				String measure = properties.getProperty("collector.item.measure." + i);
				String deviceFlagString = properties.getProperty("collector.device.support." + i);
				String deviceType = properties.getProperty("collector.device.type." + i);
				String rangeFixedString = properties.getProperty("collector.graph.range." + i);
				
				if(itemCode != null && categoryCode != null
						&& deviceFlagString != null && rangeFixedString != null){
					boolean deviceFlag = Boolean.parseBoolean(deviceFlagString);
					
					boolean rangeFixed;
					if(rangeFixedString.equals("fix")){
						rangeFixed = true;
					} else {
						rangeFixed = false;
					}
					
					// ƥ̾Ĵ٤ޤ
					CollectorItemTreeItem categoryTreeItem = categoryTable.get(categoryCode);
					String category = null;
					if(categoryTreeItem != null){
						category = categoryTreeItem.getCategory().getCategoryName();
					}
					
					CollectorItemCodeInfo codeInfo = new CollectorItemCodeInfo(
							itemCode,
							categoryCode,
							parentCode,
							category,
							itemName,
							measure,
							deviceFlag,
							deviceType,
							rangeFixed
					);
					
					// ƤΥ֥Ȥ¸ߤʤnull
					CollectorItemTreeItem parentItem = 
						(CollectorItemTreeItem) m_codeTable.get(parentCode);
					
					// ƤΥɤ¸ߤʤϥƥľǤȤ
					if(parentItem == null){
						parentItem = categoryTreeItem;
					}
					
					CollectorItemTreeItem ctItem = 
						new CollectorItemTreeItem(parentItem, codeInfo, null);
					
					// ܥɤ򥭡ȤϿ
					m_codeTable.put(itemCode, ctItem);
				}
			}
		} catch (Exception e) {
			m_codeTable.clear();
			m_itemTree.clear();
			m_codeTable.clear();
			// 顼
			e.printStackTrace();
		}
	}
	
	/**
	 * ܥɤι֤̾ޤ
	 * 
	 * @param itemCode
	 * @return ܥɤι̾
	 */
	public static String getItemName(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode))
		.getItemName();
	}
	
	/**
	 * ܥɤι̾ǥХ̾ޤ֤ޤ
	 * 
	 * @param itemCode ܥ
	 * @param deviceName ǥХ
	 * @return ܥɤι̾
	 */
	public static String getFullItemName(String itemCode, String deviceName) {
		String name;
		if (deviceName == null || deviceName.equals(Messages.getString("none"))) {
			name = ((CollectorItemTreeItem) m_codeTable.get(itemCode))
			.getItemName();
		} else {
			name = ((CollectorItemTreeItem) m_codeTable.get(itemCode))
			.getItemName()
			+ "(" + deviceName + ")";
		}
		
		return name;
	}
	
	/**
	 * ܥɤι̾ǥХ̾ޤ֤ޤ
	 * 
	 * @param collectorItemInfo ܾ
	 * @return ܥɤι̾
	 */
	public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
		String itemCode = collectorItemInfo.getCollectorItemCode();
		
		// ǥХ̤μԤܤݤǽϤѹ
		if(isDeviceSupport(itemCode)){
			// ǥХ̾ޤ᤿֤̾
			return getFullItemName(
					collectorItemInfo.getCollectorItemCode(), 
					collectorItemInfo.getDeviceName()
			);
		} else {   	
			return getItemName(itemCode);
		}
	}
	
	/**
	 * ܥɤǽͤñ̤֤ޤ
	 * 
	 * @return ǽͤñ
	 */
	public static String getMeasure(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode)).getMeasure();
	}
	
	/**
	 * ǽͤͤɴʬΨݤ֤ޤ
	 * 
	 * @return true ɴʬΨ false ɴʬΨǤϤʤ
	 */
	public static boolean isRangeFixed(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode))
		.isRangeFixed();
	}
	
	/**
	 * ǥХ̤ǽͤݤ֤ޤ
	 * 
	 * @return true ǥХ̤ǽ͡false ǥХ̤ǽͤǤϤʤ
	 */
	public static boolean isDeviceSupport(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode)).isDeviceFlag();
	}
	
	/**
	 * ǥХ̤֤ޤ
	 * 
	 * @return ǥХ
	 */
	public static String getDeviceType(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode)).getDeviceType();
	}
	
	/**
	 * ƥ֤ޤ
	 * 
	 * @return ƥ
	 */
	public static int getCategorySize() {
		return m_categoryList.size();
	}
	
	/**
	 * ꥤǥåΥƥ֤̾ޤ
	 * 
	 * @return ƥ̾
	 */
	public static String getCategoryName(int index) {
		return ((CollectorItemCategoryInfo) m_categoryList.get(index))
		.getCategoryName();
	}
	
	/**
	 * ܥɤΥƥ֤̾ޤ
	 * 
	 * @return ƥ̾
	 */
	public static String getCategoryName(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode))
		.getCategory().getCategoryName();
	}
	
	/**
	 * ꥤǥåΥƥꥳɤ֤ޤ
	 * 
	 * @return ƥꥳ
	 */
	public static String getCategoryCode(int index) {
		return ((CollectorItemCategoryInfo) m_categoryList.get(index))
		.getCategoryCode();
	}
	
	/**
	 * ܥɤΥƥꥳɤ֤ޤ
	 * 
	 * @return ƥꥳ
	 */
	public static String getCategoryCode(String itemCode) {
		return ((CollectorItemTreeItem) m_codeTable.get(itemCode))
		.getCategory().getCategoryCode();
	}
	
	/**
	 * ƤΥɤ֤ޤ
	 * 
	 * @return ƤΥ
	 */
	public static String[] getCodeAll() {
		TreeSet<String> set = new TreeSet<String>(m_codeTable.keySet());
		return (String[])set.toArray(new String[set.size()]);
	}
	
	/**
	 * μIDμΥǥХDBܥĥ꡼֤ޤ
	 * μIDnullξϥݥȥ꤫ǥХ롣
	 * 
	 * @param facilityId եƥID
	 * @param collectorId ID
	 * @return
	 */
	public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId){
		List<DeviceData> deviceList = new ArrayList<DeviceData>();
		
		if(collectorId == null){
			if(facilityId != null){
				// ݥȥ꤫ǥХ
				Repository repository = new Repository();
				
				// եƥΡɤξݥȥ꤫ǥХ
				if(repository.isNode(facilityId)){
					deviceList = repository.getDeviceList(facilityId);
				}
			}
		} else {
			// DBǥХ
			// ǥХѤDAO
			DeviceDAO dao = new DeviceDAO();
			
			// ǥХDB
			Collection devicList = dao.selectDeviceByCollectorID(collectorId);
			
			// ǥХ
			Iterator itr = devicList.iterator();
			while(itr.hasNext()){
				DeviceData device = (DeviceData)itr.next();
				
				if(device.getFacilityId().equals(facilityId)){
					deviceList.add(device);
				}
			}
		}
		
		return getCollectorTree(facilityId, deviceList);
	}
	
	/**
	 * ΥեƥΥǥХ򸵤ˡܥĥ꡼֤ޤ
	 *  
	 */
	public static CollectorItemTreeItem[] getCollectorTree(String facilityId, List deviceList){
		CollectorItemTreeItem[] returnTrees = new CollectorItemTreeItem[m_categoryList.size()];
		
		for(int i=0; i<returnTrees.length; i++){
			final CollectorItemTreeItem masterTree = (CollectorItemTreeItem)m_itemTree.get(i);
			
			// ƥ(Ǿ)Ǥ
			returnTrees[i] = new CollectorItemTreeItem(
					null,  // Ǥλʤ
					masterTree.getData(),
					null   // ǥХʤ
			);
			
			// ޥμܥĥ꡼(ץѥƥ줿Τɤ߹)Υƥ(Ǿ)
			// Ǥ롣
			List children = masterTree.getChildrens();
			Iterator itr = children.iterator();
			
			// ޥλǤ򥳥ԡΤ롣
			// ǥХꤵƤϡǥХ˴Ť
			// ǥХ̼ܤΥĥ꡼롣
			// ǥХ󤬤ʤϡǥХ̼ܤϺʤ
			while(itr.hasNext()){
				CollectorItemTreeItem masterTreeChild = (CollectorItemTreeItem)itr.next();
				CollectorItemCodeInfo masterCodeInfo = (CollectorItemCodeInfo)masterTreeChild.getData();
				
				if(masterCodeInfo.isDeviceFlag()){ // ǥХбξ					
					if(deviceList != null){
						String deviceType = masterCodeInfo.getDeviceType();

						Iterator idev = deviceList.iterator();
						while(idev.hasNext()){
							DeviceData device = (DeviceData)idev.next();
							if(device.getDeviceType().equals(deviceType)){
								makeTree(returnTrees[i], masterTreeChild, device);
							}
						}
					}
				} else {
					// ǥХʤǥĥ꡼Ǥ
					makeTree(returnTrees[i], masterTreeChild, null);					
				}
			}
		}
		
		return returnTrees;
	}
	
	/**
	 * ΥեƥΥǥХ򸵤ˡܥĥ꡼֤ޤ
	 * (IDˤnullꤵޤ)
	 * 
	 * @param facilityID եƥID
	 * @param dataSet ǥХ
	 * @return Υեƥǽʼܤΰ(IDnull)
	 */
	public static List getAvailableCollectorItemList(String facilityId){
		List<DeviceData> deviceList = new ArrayList<DeviceData>();
		ArrayList<CollectorItemInfo> retItemList = new ArrayList<CollectorItemInfo>();
		int collectorItemId = 0;  // ֵѤꥹȤμID
		
		if(facilityId != null){
			// ݥȥ꤫ǥХ
			Repository repository = new Repository();
			
			// եƥΡɤξݥȥ꤫ǥХ
			if(repository.isNode(facilityId)){
				deviceList = repository.getDeviceList(facilityId);
			}
		}
		
		String[] codes = getCodeAll();
		
		for(int i=0; i<codes.length; i++){
			String itemCode = codes[i];
			
			CollectorItemInfo itemInfo = null;
			
			int deviceIndex = 0;
			String deviceName = Messages.getString("none");
			// ǥХ̤μ򥵥ݡȤݤȽ
			if(!isDeviceSupport(itemCode)){
				// ǥХ̤μ򥵥ݡȤʤ
				itemInfo = new CollectorItemInfo(
						null,  // ID
						collectorItemId,  // ID
						itemCode,  // ܥ
						deviceIndex,   // ǥХΥǥå
						deviceName,  // ǥХ̾
						false  // ͥե饰
				);
				retItemList.add(collectorItemId, itemInfo);
				collectorItemId++;   // ID򥤥󥯥
			} else {
				// ǥХ̤μ򥵥ݡȤ
				if(deviceList != null){  // ǥХϿƤ
					// ǥХο롼
					Iterator itr = deviceList.iterator();
					while(itr.hasNext()){
						DeviceData deviceData = (DeviceData)itr.next();
						
						// ɤǰǥХ̤
						String deviceType = getDeviceType(itemCode);
						
						// ܥɤꤵ줿ǥХ̤Ȱפ
						if(deviceData.getDeviceType().equals(deviceType)){							
							deviceIndex = deviceData.getDeviceIndex();   // ǥХΥǥå
							deviceName = deviceData.getDeviceName();  // ǥХ̾
							
							itemInfo = new CollectorItemInfo(
									null,  // ID
									collectorItemId,  // ID
									itemCode,  // ܥ
									deviceIndex,   // ǥХΥǥå
									deviceName,  // ǥХ̾
									false  // ͥե饰
							);
							retItemList.add(collectorItemId, itemInfo);
							collectorItemId++;   // ID򥤥󥯥
						}
					}
				}
			}
		}
		return retItemList;
	}
	
	private static void makeTree(CollectorItemTreeItem parent, CollectorItemTreeItem masterItem, DeviceData deviceData){
		CollectorItemTreeItem treeItem = new CollectorItemTreeItem(parent, masterItem.getData(), deviceData);
		
		List children = masterItem.getChildrens();
		Iterator itr = children.iterator();
		
		while(itr.hasNext()){
			CollectorItemTreeItem masterTreeChild = (CollectorItemTreeItem)itr.next();
			makeTree(treeItem, masterTreeChild, deviceData);
		}
	}
	
	public static HashMap getItemCodeMap(){
		return m_codeTable;
	}
}