/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;
import java.util.ArrayList;


/**
 * Υƥ꡼ݻ륯饹
 * ӥɽκݤڤӡΥƥ꡼CPU,Memmory,Disk,Net)ξݻ륯饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCategoryInfo implements ICollectorItemInfo, Serializable {
    private String categoryCode;

    private String categoryName;

    private ArrayList<CollectorItemCodeInfo> itemCodeList; // ܥɤΥꥹ

    public CollectorItemCategoryInfo(String categoryCode, String categoryName) {
        this.categoryCode = categoryCode;
        this.categoryName = categoryName;
        this.itemCodeList = new ArrayList<CollectorItemCodeInfo>();
    }

    /**
     * ƥ˼ܤɲäޤ
     * 
     * @param item
     */
    public void addItem(CollectorItemCodeInfo item) {
        itemCodeList.add(item);
    }

    /**
     * ƥ˴ޤޤܤ֤ޤ
     * 
     * @param index
     */
    public CollectorItemCodeInfo getItem(int index) {
        return (CollectorItemCodeInfo) itemCodeList.get(index);
    }

    /**
     * @return categoryCode ᤷޤ
     */
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * @param categoryCode
     *            categoryCode ꡣ
     */
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    /**
     * @return categoryName ᤷޤ
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * @param categoryName
     *            categoryName ꡣ
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /**
     * @return itemCodeList ᤷޤ
     */
    public ArrayList getItemCodeList() {
        return itemCodeList;
    }

    /**
     * @param itemCodeList
     *            itemCodeList ꡣ
     */
    public void setItemCodeList(ArrayList<CollectorItemCodeInfo> itemCodeList) {
        this.itemCodeList = itemCodeList;
    }

	public String getName() {
		return getCategoryName();
	}

	public String getCode() {
		return getCategoryCode();
	}
}