/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.monitor.factory;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeTable;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoUtil;

/**
 * Ƚꥯ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunMonitorPerformance2 extends RunMonitorNumericValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorPerformance2.class );
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** ; */
	protected MonitorPerfInfoLocal m_perf = null;
	
	/** ̾ */
	private String m_itemName = null;
	
	/** ͥեޥå */
	protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorPerformance2() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * ƻ¹
	 * (ǽʹƻǤϥפȽˡۤʤ뤿ῷ)
	 * 
	 * @param monitorTypeId ƻƻоID
	 * @param monitorId ƻID
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws JMSException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	public void run(String monitorTypeId, String monitorId, CollectedDataInfo data)
	throws FinderException, RemoveException, JMSException, NamingException, CreateException {
		
		String facilityId = data.getFacilityID();
		
		if(facilityId == null || "".equals(facilityId)){
			return;
		}
		
		// ǽͤ
		m_value = (float)data.getValue();
		
		m_now = new Date();
		
		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;
		
		m_priorityMap = new HashMap();
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_INFO),		new ArrayList<String>());
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_WARNING),	new ArrayList<String>());
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_CRITICAL),	new ArrayList<String>());
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_UNKNOWN),	new ArrayList<String>());
		
		try 
		{
			// ƻܾ
			boolean notify = this.setMonitorInfo(m_monitorTypeId, m_monitorId);
			if(!notify){
				// ΤʤϽλ
				return;
			}
			
			// Ƚ
			setJudgementInfo();
			
			// ƻå
			setCheckInfo();

			boolean isNode = false;
			// ƻоݤȤƻꤷեƥΡɤξ
			if(m_repository.isNode(this.m_facilityId)){
				isNode = true;
			}

			// ƻͤǤɤȽ
			boolean result = collect(facilityId);
			
			// ƻ̤٤
			int priority = getCheckResult(result);		
			
			// ȽоݥեƥΡɤξ
			// (ƻоݥեƥȽоݥեƥȤ̤ΤΤؤ
			//  ƻоݥեƥ꥽ƻǻꤷեƥID
			//  ȽоݥեƥΥ᥽åɤƤӽФݤϤ줿ѤߥǡΥեƥID)
			if(m_repository.isNode(facilityId)){
				if((MonitorBlockConstant.TYPE_NODE == m_monitorBlock ||
						(MonitorBlockConstant.TYPE_SCOPE == m_monitorBlock && isNode) ||
						MonitorBlockConstant.TYPE_ALL == m_monitorBlock)){
					
					// ִƻ
					if(data.getDate().getTime() == 0){
						notify(true, facilityId, priority, new Date());
					} else {
						notify(true, facilityId, priority, data.getDate());
					}
				}
			}
			// Ƚоݥեƥפξ
			else {  
				if(MonitorBlockConstant.TYPE_SCOPE == m_monitorBlock || 
						MonitorBlockConstant.TYPE_ALL == m_monitorBlock){
					
					// ִƻ
					if(data.getDate().getTime() == 0){
						notify(false, facilityId, priority, new Date());
					} else {
						notify(false, facilityId, priority, data.getDate());
					}
				}
			}
		} catch (FinderException e) {
			m_log.error("run():" + e.getMessage());
			e.printStackTrace();
			throw e;
		} catch (JMSException e) {
			e.printStackTrace();
			throw e;
		} catch (NamingException e) {
			m_log.error("run():" + e.getMessage());
			e.printStackTrace();
			throw e;
		} catch (CreateException e) {
			m_log.error("run():" + e.getMessage());
			e.printStackTrace();
			throw e;
		} finally {
			// λ
			this.terminate();
		}
	}
	
	/* ( Javadoc)
	 * ǽʹƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		// ǽʹƻ
		MonitorPerfInfoPK pk = new MonitorPerfInfoPK(m_monitorId, m_monitorTypeId);
		m_perf = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
		m_itemName = CollectorItemCodeTable.getFullItemName(m_perf.getItemCode(), m_perf.getDeviceName());
	}
	
	/* ( Javadoc)
	 * åID
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int result) {
		
		if(result == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(result == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(result == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
	
	/* ( Javadoc)
	 * å
	 */
	@Override
	public String getMessage(int result) {
		String valueString;
		if(Float.isNaN(m_value)){
			valueString = "NaN";
		} else {
			valueString = m_numberFormat.format(m_value);
		}
		return m_itemName + " : " + valueString;
	}

	/* ( Javadoc)
	 * å
	 */
	@Override
	public String getMessageForScope(int result){
		String valueString;
		if(Float.isNaN(m_value)){
			valueString = "NaN";
		} else {
			valueString = m_numberFormat.format(m_value);
		}
		return m_itemName + " : " + valueString;
	}
	
	/* ( Javadoc)
	 * ꥸʥå
	 */
	@Override
	public String getMessageOrg(int result) {
		String valueString;
		if(Float.isNaN(m_value)){
			valueString = "NaN";
		} else {
			valueString = m_numberFormat.format(m_value);
		}
		return m_itemName + " : " + valueString;
	}
	
	/* ( Javadoc)
	 * ꥸʥå
	 */
	@Override
	public String getMessageOrgForScope(int result){
		String valueString;
		if(Float.isNaN(m_value)){
			valueString = "NaN";
		} else {
			valueString = m_numberFormat.format(m_value);
		}
		return m_itemName + " : " + valueString;
	}

	@Override
	public boolean collect(String facilityId) {
		// ǽͤNaNǤʤСͤϼǤƤ
		return !Float.isNaN(m_value);
	}
}
