/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performanceMGR.monitor.factory;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorUtil;
import com.clustercontrol.performanceMGR.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performanceMGR.monitor.ejb.session.MonitorPerfRunManagementHome;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * ǽʹƻϿ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddMonitorPerformance extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorPerformance.class );
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		// ID
		String collectorId = (CollectorUtil.generateGUID(this));
		
		// ǽƻ
		MonitorPerfCheckInfo mpInfo = (MonitorPerfCheckInfo)m_monitorInfo.getCheckInfo();
		
		MonitorPerfInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				collectorId,
				mpInfo.getItemCode(),
				mpInfo.getDeviceIndex(),
				mpInfo.getDeviceName());
		
		// ܾݻꥹ
		ArrayList itemList = new ArrayList();
		
		// ܾ
		CollectorItemInfo itemInfo = new CollectorItemInfo(
				mpInfo.getCollectorId(),
				0,                        // ID
				mpInfo.getItemCode(),
				mpInfo.getDeviceIndex(),
				mpInfo.getDeviceName()
				);
		
		itemList.add(itemInfo);
		
		// ǽμϿ
		ModifySchedule scheduler = new ModifySchedule();
		boolean result = scheduler.addSchedule(
				m_monitorInfo.getMonitorId(),
				collectorId,
				m_monitorInfo.getFacilityId(),
				m_monitorInfo.getRunInterval(),
				itemList,
				m_monitorInfo.getValid());
		
		return result;
	}

	/**
	 * ƻϿ
	 * 
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 */
	@Override
	public boolean addMonitorInfo(String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException {
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			// ƻ
			m_monitor = MonitorInfoUtil.getLocalHome().create(
					m_monitorInfo.getMonitorTypeId(),
					m_monitorInfo.getMonitorId(),
					m_monitorInfo.getMonitorType(),
					m_monitorInfo.getDescription(),
					m_monitorInfo.getFacilityId(),
					m_monitorInfo.getRunInterval(),
					m_monitorInfo.getTimeout(),
					m_monitorInfo.getCalendarId(),
					m_monitorInfo.getMonitorBlock(),
					m_monitorInfo.getDeterminationId(),
					m_monitorInfo.getFailurePriority(),
					m_monitorInfo.getNotifyId(),
					m_monitorInfo.getApplication(),
					m_monitorInfo.getJobRun(),
					m_monitorInfo.getFailureMessageId(),
					m_monitorInfo.getFailureMessage(),
					m_monitorInfo.getFailureJobRun(),
					m_monitorInfo.getFailureJobId(),
					m_monitorInfo.getFailureJobInhibitionFlg(),
					m_monitorInfo.getFailureJobFailurePriority(),
					now,
					now,
					user,
					user
			);
			
			// Ƚ
			if(addJudgementInfo()){
				// ƻå
				if(addCheckInfo()){
					return true;
				}
			}
			return false;
		} catch (CreateException e) {
			outputLog(e, "addMonitorInfo()");
            e.printStackTrace();
			throw e;
		} catch (NamingException e) {
			outputLog(e, "addMonitorInfo()");
			e.printStackTrace();
			throw e;
		}
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorPerfRunManagementHome.JNDI_NAME;
	}
	
	/**
     * ץꥱ˥
     * 
     * @param e 㳰
     */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("PERF", "perf");
		String[] args = {m_monitorInfo.getMonitorTypeId(), m_monitorInfo.getMonitorId() };
        apllog.put("SYS", "007", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
