/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.job;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

import com.clustercontrol.performanceMGR.bean.CollectorType;
import com.clustercontrol.performanceMGR.bean.QuartzConstant;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorLocal;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorUtil;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;

public class CollectJob implements Job{
	protected static Log m_log = LogFactory.getLog( CollectJob.class );

	private long m_sleepTime1 = 3000;  // λ֤餷Ƶư
	private long m_sleepTime2 = 10000;  // λ֤餷Ƶư
	
	public void execute(JobExecutionContext context) throws JobExecutionException {
		// ǥХå
//		m_log.debug("execute start : ");
		
		// ޤ
		JobDataMap dataMap = context.getJobDetail().getJobDataMap();
		
		CollectorPK pk  = (CollectorPK)dataMap.get("pk");
		int collectorType  = dataMap.getInt("type");
		
		// ǥХå
//		m_log.debug("execute : " + pk + "  type : " + collectorType);
		
		// EntityBeanåå
		try {
			CollectorLocal bean = null;
			bean = CollectorUtil.getLocalHome().findByPrimaryKey(pk);
			
			// ֳ֤
			int intarval = bean.getInterval();
			// 2ʳͱͽ֤꤬
			// ֳ֤m_sleepTime2ÿ꾮ϡm_sleepTime1λ֤餷ƽ¹Ԥ
			if(m_sleepTime2 > intarval*1000){
				Thread.sleep(m_sleepTime1);
			} else {
				Thread.sleep(m_sleepTime2);
			}
			
			if(bean.getCollectorID() == null || 
					collectorType == CollectorType.UNKNOWN){
				// 쥯ưƤʤ
				m_log.warn("˽Ƥʤ CollectorBean ˥ޤ");
			} else if(collectorType == CollectorType.REALTIME){
				// ꥢ륿ξ
				
				// ޤǻȤƤʤϼߤ롣
				if (!bean.checkLifetime()){
					m_log.debug("ȤƤʤ  : " + pk.collectorID);
					bean.stopCollect();
					bean.remove();
					return;
				}
				
				// DBؤνϤϹԤ鷺ݡ顼ͼΤ߹Ԥ
				bean.fetchMibValue();
			} else if(collectorType == CollectorType.RECORD) {
				// Ӽξ
				
				// ݡ顼ͼDB˽Ϥ
				bean.storeCalcValue();
			} else if(collectorType == CollectorType.MONITOR) {
				// ʹƻξ
				
				// ݡ顼ͼDB˽Ϥ
				bean.monitorCalcValue();
			} else {
				// ⤷ʤ
			}			
		} catch (NamingException e) {
			m_log.error(e);
			// ꥢ륿ξ
			if(collectorType == CollectorType.REALTIME){
				// Quartzμ֤
				deleteJob(pk.getCollectorID());
			}
		} catch (FinderException e) {
			m_log.debug(pk.collectorID + " ϴߤƤ褦Ǥ");
			m_log.error(e);
			// ꥢ륿ξ
			if(collectorType == CollectorType.REALTIME){
				// Quartzμ֤
				deleteJob(pk.getCollectorID());
			}
		} catch (InterruptedException e) {
			m_log.error(e);
			// ꥢ륿ξ
			if(collectorType == CollectorType.REALTIME){
				// Quartzμ֤
				deleteJob(pk.getCollectorID());
			}
		} catch (EJBException e) {
			m_log.error(e);
		} catch (RemoveException e) {
			m_log.error(e);
			// ꥢ륿ξ
			if(collectorType == CollectorType.REALTIME){
				// Quartzμ֤
				deleteJob(pk.getCollectorID());
			}
		}
		
		// ǥХå
//		m_log.debug("execute end   : " + pk);
	}
	
	/**
	 * ư֤ޤ
	 */
	private void deleteJob(String collectorId) {
		m_log.debug("deleteJob() start : " + collectorId);
		
        //QuartzScheduleråå
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);

			// ϿƤ른֤(ϿƤʤϲ⤪ʤ)
            scheduler.deleteJob(collectorId, QuartzConstant.GROUP_COLLECT);
		} catch (NamingException e) {
			throw new EJBException(e);
        } catch (SchedulerException e) {
            m_log.error(e);
        }
        
        m_log.debug("deleteJob() end   : " + collectorId);
	}
}