/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.performanceMGR.util.ConnectionManager;

/**
 * եƥDB¸ɤ߽ФDAO饹
 * 
 * 
 * @version 1.0
 * @since 1.0
 */
public class ScopeSnapDAO {

	//	
	protected static Log m_log = LogFactory.getLog(ScopeSnapDAO.class );
	
	/**
	 * 󥹥ȥ饯
	 *
	 */
	public ScopeSnapDAO(){
	}
	
	/**
	 * IDȥեƥIDեƥոޤ
	 * 
	 * ΥեƥǤΤǡեƥIDǤϰդ˷ޤޤ
	 * ǡIDղä뤳ȤǰոԤޤ
	 * @param collectorIDID
	 * @param facilityIDեƥID
	 * @returnեƥ
	 * @throws SQLException
	 */
	public FacilityInfo selectScopeSnap(String collectorID, String facilityID)
	throws EJBException{
		
		m_log.debug("selectScopeSnap() start :" + collectorID + " " + facilityID);
		
		FacilityInfo finfo = null;
		String type =null;
		Connection conn = null;
		PreparedStatement stmt =null;
		// ̥å
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//		SQLʸκ
			String sql = "SELECT * FROM SCOPE_SNAP WHERE COLLECTORID=? AND FACILITYID = ?";
			// SQLʸȯԽ
			 stmt = conn.prepareStatement(sql);
			
			
			stmt.setString(1, collectorID);
			stmt.setString(2, facilityID);
			res = stmt.executeQuery();
			
			if(res.next()) {
				
				finfo =new  FacilityInfo();
				finfo.setFacilityId(res.getString("FACILITYID"));
				finfo.setFacilityName(res.getString("FACILITY_NAME"));
				
				type = res.getString("FACILITY_TYPE");
				if(type.equals("node")){
					finfo.setType(2);
				}else if(type.equals("scope")){
					finfo.setType(1);
				}else if(type.equals("comp")){
					finfo.setType(0);
				}
			} else {
				
				String msg = "Select Error In ScopeSnapDAO";
				m_log.error("selectScopeSnap() error :" + collectorID + " SQLException ");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("selectScopeSnap() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectScopeSnap() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectScopeSnap() start :" + collectorID + " " + facilityID);
		return finfo;
	}
	/**
	 * IDȥեƥIDǰդ˥եƥޤ
	 * @param collectorIDID
	 * @param facilityIDեƥID
	 * @throws SQLException
	 */
	public void deleteScopeSnap(String collectorID, String facilityID)
	throws EJBException{
		
		m_log.debug("deleteScopeSnap() start :" + collectorID + " " + facilityID);
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "DELETE FROM SCOPE_SNAP WHERE COLLECTORID = ? AND FACILITYID=?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			int row;
			
			stmt.setString(1,collectorID);
			stmt.setString(2, facilityID);
			
			row = stmt.executeUpdate();
			
			if (row != 1 ) {
				
				String msg = "Deletet Error In ScopeSnapDAO";
				m_log.error("deleteScopeSnap() error :" + collectorID + " SQLException ");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("deleteScopeSnap() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteScopeSnap() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("deleteScopeSnap() start :" + collectorID + " " + facilityID);
		}	
		
	}
	
	/**
	 * եƥ򥤥󥵡Ȥޤ
	 * @param collectorIDID
	 * @param finfoեƥ
	 * @throws SQLException
	 * @throws CreateException
	 */
	public void insertScopeSnap(String collectorID, FacilityInfo finfo)
	throws CreateException,EJBException{
		m_log.debug("insertScopeSnap() start :" + collectorID + " " + finfo.getFacilityId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "INSERT INTO SCOPE_SNAP " +
			"(collectorID, " +
			"facilityID," +
			"facility_name," +
			"facility_type)" +
			"values (?,?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,collectorID);
			stmt.setString(2,finfo.getFacilityId());
			stmt.setString(3,finfo.getFacilityName());
			int i = finfo.getType();
			if(i == FacilityConstant.TYPE_COMPOSITE){
				stmt.setString(4,"comp");
			} else if(i == FacilityConstant.TYPE_SCOPE){
				stmt.setString(4,"scope");
			} else if(i == FacilityConstant.TYPE_NODE){
				stmt.setString(4,"node");
			}
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "Insert Error In ScopeSnapDAO";
				m_log.error("insertScopeSnap() error :" + collectorID + " CreateException ");
				throw new CreateException(msg);
			}
		} catch (SQLException e) {
			m_log.error("insertScopeSnap() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("insertScopeSnap() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("insertScopeSnap() end   :" + collectorID + " " + finfo.getFacilityId());
		}	
	}
	/**
	 * бեƥ򸡺ޤ
	 * @param collectorIDID
	 * @returnեƥID򥭡Ȥϥåơ֥
	 * @throws SQLException
	 */
	public Hashtable selectScopeSnapByCollectorID(String collectorID)
	throws EJBException{
		
		m_log.debug("selectScopeSnapByCollectorID() start :" + collectorID );
		
		Hashtable<String, FacilityInfo> ret = new Hashtable<String, FacilityInfo>();
		String type = null;
		Connection conn = null;
		PreparedStatement stmt = null;
		// ̥å
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQLʸκ
			String sql = "SELECT * FROM SCOPE_SNAP WHERE COLLECTORID=?";
			// SQLʸȯԽ
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, collectorID);
			res = stmt.executeQuery();
			
			while(res.next()) {
				
				FacilityInfo finfo =new  FacilityInfo();
				finfo.setFacilityId(res.getString("FACILITYID"));
				finfo.setFacilityName(res.getString("FACILITY_NAME"));
				
				type = res.getString("FACILITY_TYPE");
				if(type.equals("node")){
					finfo.setType(FacilityConstant.TYPE_NODE);
				}else if(type.equals("scope")){
					finfo.setType(FacilityConstant.TYPE_SCOPE);
				}else if(type.equals("comp")){
					finfo.setType(FacilityConstant.TYPE_COMPOSITE);
				}
				
				ret.put(res.getString("FACILITYID"),finfo);
			} 
		} catch (SQLException e) {
			m_log.error("selectScopeSnapByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(res != null){
					res.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectScopeSnapByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectScopeSnapByCollectorID() end :" + collectorID );
		
		return ret;
	}
	/**
	 * бեƥȰޤ
	 * @param collectorIDID
	 * @throws SQLException
	 */
	public void deleteScopeSnapByCollectorID(String collectorID)
	throws EJBException{
		
		m_log.debug("deleteScopeSnapByCollectorID() start :" + collectorID );
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "DELETE FROM SCOPE_SNAP WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,collectorID );
			stmt.executeUpdate();
		} catch (SQLException e) {
			m_log.error("deleteScopeSnapByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteScopeSnapByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("deleteScopeSnapByCollectorID() start :" + collectorID );
		}	
		
	}
}
