/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.performanceMGR.bean.RawValue;
import com.clustercontrol.performanceMGR.util.ConnectionManager;

/**
 * ǽͤDB¸ɤ߽ФDAO饹
 * 
 * 
 * @version 1.0
 * @since 1.0
 */
public class RecordDataDAO {
	
//	
	protected static Log m_log = LogFactory.getLog(RecordDataDAO.class);
	
	/**
	 * 󥹥ȥ饯
	 *
	 */
	public RecordDataDAO(){
	}
	
	/**
	 * 줿ǽͤIDSNMPOIDեƥID֡ʳϤλλλˤǸޤ
	 *
	 * 
	 * @param collectorID ID
	 * @param OIDSNMPOID
	 * @param facilityID եƥID
	 * @param startDate (Ρ˳ϻ
	 * @param stopDateʸΡ˽λ
	 * @return줿ǽͤΥ쥯
	 * @throws EJBException
	 */
	/*
	 * UptimeӤƥǡʤʬ0Ǥ᤿ΤϤС
	 */
	public List selectRecordData(
			String collectorID, 
			String OID, 
			String facilityID, 
			Date startDate,
			Date stopDate )
	throws EJBException{
		
		m_log.debug("selectRecordData() start :" + collectorID + " " + OID );
		ArrayList ret = new ArrayList();		
		Connection conn = null;
		PreparedStatement stmt =null;
		ResultSet res = null; 

		// ƤͤnullǤʤȽꤹ뤿Υե饰
		boolean checkAllNull = true;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			String sql = "SELECT V1.DATE_TIME, V2.VALUE FROM " +
						"( SELECT DATE_TIME FROM PERFORMANCE_DATA " +
						"WHERE COLLECTORID=? AND OBJECTID='.1.3.6.1.2.1.25.1.1.0' " +
						"AND FACILITYID=? AND DATE_TIME BETWEEN ? AND ? ) AS V1 " +
					"LEFT OUTER JOIN  " +
						"(SELECT DATE_TIME ,VALUE FROM PERFORMANCE_DATA " +
						"WHERE COLLECTORID=? AND OBJECTID=? " +
						"AND FACILITYID=? AND DATE_TIME BETWEEN ? AND ? ) AS V2 USING (DATE_TIME)";

			
			// SQLʸȯԽ
			stmt = conn.prepareStatement(sql);
			
			Timestamp start = new Timestamp(startDate.getTime());
			Timestamp stop  = new Timestamp(stopDate.getTime());
			
			stmt.setString(1, collectorID);
			stmt.setString(2, facilityID);
			stmt.setTimestamp(3, start);
			stmt.setTimestamp(4, stop);
			stmt.setString(5, collectorID);
			stmt.setString(6, OID);
			stmt.setString(7, facilityID);
			stmt.setTimestamp(8, start);
			stmt.setTimestamp(9, stop);
			
			res = stmt.executeQuery();

			long value = 0;
			while(res.next()) {
				if(res.getString("VALUE") != null){
					checkAllNull = false;  // ƤͤnullǤʤȽ
					value = res.getLong("VALUE");
				} else {
					value = 0;
				}
				
				RawValue rv=  new RawValue(new Date(res.getTimestamp("DATE_TIME").getTime()),
						value);

				ret.add(rv);				
			}
		} catch (SQLException e) {
			m_log.error("selectRecordData() error :" + facilityID + " EJBException ",e);
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectRecordData() error :" + facilityID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("selectRecordData() end :" + collectorID + " " + OID );

		if(checkAllNull){
			return new ArrayList();
		} else {
			return ret;
		}
	}
	
	
	/**
	 * 줿ǽͤIDSNMPΥåȡեƥID֡ʳϤλλλˤǸޤ
	 *
	 * 
	 * @param collectorID ID
	 * @param tmpArraySNMPOID(UPTimeޤޤʤ)
	 * @param facilityID եƥID
	 * @param startDate (Ρ˳ϻ
	 * @param stopDateʸΡ˽λ
	 * @return줿ǽͤArrayList hashtable
	 * @throws EJBException
	 */
	/*
	 * UptimeӤƥǡʤʬ0Ǥ᤿ΤϤС
	 */
	public java.util.Hashtable selectRecordData10(
			String collectorID, 
			HashSet tmpSet, 
			String facilityID, 
			Date startDate,
			Date stopDate )
	throws EJBException{

		m_log.debug("selectRecordData() start :" + collectorID  );
		Hashtable ret = new Hashtable();		
		Connection conn = null;
		Statement stmt =null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQLʸκ	
			Timestamp start = new Timestamp(startDate.getTime());
			Timestamp stop  = new Timestamp(stopDate.getTime());

			Iterator it = null;
						
			String sql = "SELECT VV0.DATE_TIME, VV0.VALUE";
			for(int i = 0 ; i < tmpSet.size(); i++ ){
				sql = sql + ", " + "V" + i + ".VALUE";
			}
			
			sql = sql + " FROM ( SELECT DATE_TIME , VALUE FROM PERFORMANCE_DATA " +
						"WHERE COLLECTORID='" + collectorID + "'" +
						" AND OBJECTID='.1.3.6.1.2.1.25.1.1.0'" +
						" AND FACILITYID='" + facilityID + "'" +
						" AND DATE_TIME BETWEEN '" +  start.toString() + "'" +
						" AND '" + stop.toString() + "'" +
						") AS VV0 ";
			
			//ѤΥϥåarraylist
			ArrayList al1 = new ArrayList();
			ret.put("datetime", al1);

			int i = 0;
			String oid ;
			for(it = tmpSet.iterator();it.hasNext(); ){
				
				oid= (String)it.next();
				sql = sql +" LEFT OUTER JOIN  " +
						"(SELECT DATE_TIME , VALUE FROM PERFORMANCE_DATA " +
						"WHERE COLLECTORID='" + collectorID + "'" +
						" AND OBJECTID='"  + oid + "'" +
						" AND FACILITYID='" + facilityID + "'" +
						" AND DATE_TIME BETWEEN '" +  start.toString() + "'" +
						" AND '" + stop.toString() + "'" +
						") AS V"+ i + " USING (DATE_TIME)";
				
//				ѤΥϥåarraylist
				ArrayList al = new ArrayList();
				ret.put(oid , al);
	
				i++;
			}
				sql = sql + " ORDER BY DATE_TIME";

			// SQLʸȯԽ
			stmt = conn.createStatement();

			ResultSet res = stmt.executeQuery(sql);
			
			/*
			 *
			 */
			while(res.next()) {
						
				((ArrayList)ret.get("datetime")).add(new Date(res.getTimestamp("DATE_TIME").getTime()));

				int j = 0;
				for(it = tmpSet.iterator();it.hasNext(); ){
				 ((ArrayList)ret.get((String)it.next())).add(new Long(res.getLong(j+3)));
				 j++;
				}
								
			}
		} catch (SQLException e) {
			m_log.error("selectRecordData() error :" + facilityID + " EJBException ",e);
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectRecordData() error :" + facilityID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("selectRecordData() end :" + collectorID );		
		
			return ret;
	}
	/**
	 * ǽͤIDǺޤ
	 * 
	 * ɳդ줿ǽͤǺޤ
	 * 
	 * @param collectorIDID
	 * @throws SQLException
	 */
	public void deleteRecordData(String collectorID)
	throws EJBException{
		
		m_log.debug("deleteRecordData() start :" + collectorID );
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//conn.setAutoCommit(false);
			//SQLʸ
			String sql = "DELETE FROM PERFORMANCE_DATA WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,collectorID );
			
			stmt.executeUpdate();
		} catch (SQLException e) {
			m_log.error("deleteRecordData() error :" + collectorID + " EJBException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteRecordData() error :" + collectorID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("deleteRecordData() end :" + collectorID );
		}	
	}
	
	/**
	 * ǽͤ򥤥󥵡Ȥޤ
	 * 
	 * @param collectorIDID
	 * @param OIDSNMPOID
	 * @param date
	 * @param facilityID եƥID
	 * @param value ǽ
	 * @throws SQLException
	 */
	public void insertRecordData(String collectorID,
			String OID, 
			Date date, 
			String facilityID, 
			long value)
	throws EJBException{
		
		m_log.debug("insertRecordData() start :" + collectorID  + " " + OID + " " + date.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		Timestamp time = new Timestamp(date.getTime());
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "INSERT INTO PERFORMANCE_DATA " +
			"(collectorID, " +
			"ObjectID," +
			"date_time," +
			"facilityid," +
			"value)" +
			"values (?,?,?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,collectorID);
			stmt.setString(2, OID);
			stmt.setTimestamp(3,time);
			stmt.setString(4, facilityID);
			stmt.setLong(5, value);
			
			stmt.executeUpdate();
			
		} catch (SQLException e) {
			m_log.error("insertRecordData() error :" + collectorID + " EJBException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("insertRecordData() error :" + collectorID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("insertRecordData() end :" + collectorID  + " " + OID + " " + date.toString());
		}	
	}
	
	public ArrayList selectObjectID(String collectorID, String facilityID, String oid) {
		return null;
	}
}
