/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.util.ConnectionManager;


/**
 * DBԤ饹
 * 
 * @version 2.0.0
 * @since 1.0
 */
public class CollectorItemDAO {
	
	//
	protected static Log m_log = LogFactory.getLog( CollectorItemDAO.class );
	
	/**
	 * 󥹥ȥ饯
	 *
	 */
	public CollectorItemDAO(){
		
	}
	
	/**
	 * IDȼIDǸԤ
	 * @param collectorID
	 * @param collectorItemID
	 * @return ܾ
	 * @throws SQLException
	 */
	public CollectorItemInfo selectCollectorItem(String collectorID, int collectorItemID)
	throws EJBException{
		m_log.debug("selectCollectorItem() start : " + collectorID + " " + collectorItemID);
		
		CollectorItemInfo cinfo = null;

		Connection conn = null;
		PreparedStatement stmt = null;
		// ̥å
		ResultSet res=null;
		
		try {
			//ͥޤ
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQLʸκ
			String sql = "SELECT * FROM COLLECTOR_ITEM WHERE COLLECTORID=? AND ITEMID = ?";
			// SQLʸȯԽ
			
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, collectorID);
			stmt.setInt(2, collectorItemID);
			res = stmt.executeQuery();
			
			if(res.next()) {
				
				cinfo =new  CollectorItemInfo(
						res.getString("COLLECTORID"),
						res.getInt("ITEMID"),
						res.getString("ITEM_CODE"),
						res.getInt("DEVICE_INDEX"),
						res.getString("DEVICE_NAME")
				);
			}
		} catch (SQLException e) {
			m_log.error("selectCollectorIte() error :" + collectorID + " " + collectorItemID + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectCollectorIte() error :" + collectorID + " " + collectorItemID + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("selectCollectorItem() end   : " + collectorID + " " + collectorItemID);
		return cinfo;
		
	}
	
	/**
	 * ܾ򥤥󥵡Ȥ
	 * @param cinfo
	 * @throws SQLException
	 */	
	public void registCollectorItem(CollectorItemInfo cinfo)
	throws EJBException{
		
		m_log.debug("registCollectorItem() start :"
				+ cinfo.getCollectorID() + " " + cinfo.getCollectorItemID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//		SQLʸκ
			//SQLʸ
			String sql = "INSERT INTO COLLECTOR_ITEM " +
			"(collectorID, " +
			"itemID," +
			"item_code," +
			"device_index," +
			"device_name," +
			"monitor_flag)" +
			"values (?,?,?,?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,cinfo.getCollectorID());
			stmt.setInt(2,  cinfo.getCollectorItemID());
			stmt.setString(3,cinfo.getCollectorItemCode());
			stmt.setInt(4, cinfo.getDeviceIndex());
			stmt.setString(5, cinfo.getDeviceName());
			stmt.setBoolean(6, false);
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("registCollectorItem() error :" + cinfo.toString() + " SQLException " + msg);
				
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("registCollectorItem() error :" + cinfo.toString() + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("registCollectorItem() error :" + cinfo.toString() + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			
			m_log.debug("registCollectorItem() end   :" + cinfo.toString());
		}
	}
	
	/**
	 * IDǸԤ
	 * 
	 * ˴ޤޤܤ礷Ƽ
	 * @param collectorID
	 * @returnܾΥ쥯
	 * @throws SQLException
	 */
	public Collection selectCollectorItemByCollectorID(String collectorID)
	throws EJBException{
		
		m_log.debug("selectCollectorItemByCollectorID() start :"
				+collectorID);
		
		ArrayList<CollectorItemInfo> ret = new ArrayList<CollectorItemInfo>();
		Connection conn = null;
		PreparedStatement stmt =null;
		// ̥å
		ResultSet res=null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQLʸκ
			String sql = "SELECT * FROM COLLECTOR_ITEM WHERE COLLECTORID=? " + 
			"ORDER BY ITEMID;";
			// SQLʸȯԽ
			stmt = conn.prepareStatement(sql);
			
			
			stmt.setString(1, collectorID);
			res = stmt.executeQuery();
			
			while(res.next()) {
				
				CollectorItemInfo  cinfo = new  CollectorItemInfo(
						res.getString("COLLECTORID"),
						res.getInt("ITEMID"),
						res.getString("ITEM_CODE"),
						res.getInt("DEVICE_INDEX"),
						res.getString("DEVICE_NAME")
				);
				
				ret.add(cinfo);
			} 
		} catch (SQLException e) {
			m_log.error("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectCollectorItemByCollectorID() end   :" + collectorID);
		return ret;
	}
	
	/**
	 * IDǺԤ
	 * 
	 * ˴ޤޤܾ礷ƺ
	 * @param collectorID
	 * @throws SQLException
	 */
	public void deleteCollectorItemByCollectorID(String collectorID)
	{
		m_log.debug("deleteCollectorItemByCollectorID() start :" + collectorID);
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "DELETE FROM COLLECTOR_ITEM WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,collectorID );
			stmt.executeUpdate();
			
		} catch (SQLException e) {
			m_log.error("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}	
		
		
		m_log.debug("deleteCollectorItemByCollectorID() end   :" + collectorID);
	}
}
	
