/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.util.ConnectionManager;

/**
 * ǽͤDB¸ɤ߽ФDAO饹
 * 
 * 
 * @version 2.0.0
 * @since 1.0
 */
public class CalculatedDataDAO {
	
//	
	protected static Log m_log = LogFactory.getLog(CalculatedDataDAO.class);
	
	/**
	 * 󥹥ȥ饯
	 */
	public CalculatedDataDAO(){
	}
	
	/**
	 * 줿ǽͤIDSNMPOIDեƥID֡ʳϤλλλˤǸޤ
	 *
	 * 
	 * @param collectorID ID
	 * @param itemCodeܥ
	 * @param deviceIndex  ǥХֹ
	 * @param facilityID եƥID
	 * @param startDate (Ρ˳ϻ
	 * @param stopDateʸΡ˽λ
	 * @return줿ǽͤΥ쥯
	 * @throws EJBException
	 */
	public List select(
			String collectorID, 
			String itemCode, 
			int deviceIndex,
			String facilityID,
			Date startDate,
			Date stopDate )
	throws EJBException{
		
		m_log.debug("select() start :" + collectorID + " " + itemCode + " " + deviceIndex + " " + facilityID);
		ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();  // DBǡǼꥹ
		
		Connection conn = null;
		PreparedStatement stmt =null;
		ResultSet res = null; 
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQLʸκ
			String sql = "SELECT * FROM CALCULATED_DATA WHERE " + 
			"COLLECTORID=? AND " + 
			"ITEM_CODE=? AND " + 
			"DEVICE_INDEX=? AND " + 
			"FACILITYID=? AND " + 
			"DATE_TIME BETWEEN ? AND ?" +
			"ORDER BY DATE_TIME";
			
			// SQLʸȯԽ
			stmt = conn.prepareStatement(sql);
			
			Timestamp start = new Timestamp(startDate.getTime());
			Timestamp stop  = new Timestamp(stopDate.getTime());
			
			stmt.setString(1,collectorID);
			stmt.setString(2, itemCode);
			stmt.setInt(3, deviceIndex);
			stmt.setString(4, facilityID);
			stmt.setTimestamp(5, start);
			stmt.setTimestamp(6, stop);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				CollectedDataInfo data = new CollectedDataInfo(facilityID, itemCode, deviceIndex);
				data.setDate(new Date(res.getTimestamp("DATE_TIME").getTime()));
				
				if(res.getObject("VALUE") != null){	
					data.setValue(res.getDouble("VALUE"));
				} else {
					data.setValue(Double.NaN);  // DBnulläƤǽͤǽä
				}
				ret.add(data);
			}
		} catch (SQLException e) {
			m_log.error("select() error :" + facilityID + " EJBException ",e);
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("select() error :" + facilityID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("select() end   :" + collectorID + " " + itemCode + " " + deviceIndex + " " + facilityID);
		
		return ret;
	}
	
	/**
	 * ǽͤIDǺޤ
	 * 
	 * ɳդ줿ǽͤǺޤ
	 * 
	 * @param collectorIDID
	 * @throws SQLException
	 */
	public void delete(String collectorID)
	throws EJBException{
		
		m_log.debug("delete() start :" + collectorID );

		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//conn.setAutoCommit(false);
			//SQLʸ
			String sql = "DELETE FROM CALCULATED_DATA WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,collectorID );
			
			stmt.executeUpdate();
		} catch (SQLException e) {
			m_log.error("delete() error :" + collectorID + " EJBException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("delete() error :" + collectorID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("delete() end   :" + collectorID );
		}	
	}
	
	/**
	 * ǽͤ򥤥󥵡Ȥޤ
	 * 
	 * @param collectorIDID
	 * @param data ׻Ѥǽ;
	 * @throws SQLException
	 */
	public void insert(String collectorID, CollectedDataInfo data)
	throws EJBException{
		
		m_log.debug("insert() start : " + collectorID +
				" " + data.getItemCode() +
				" " + data.getDeviceIndex() +
				" " + data.getFacilityID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		Timestamp time = new Timestamp(data.getDate().getTime());
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "INSERT INTO CALCULATED_DATA " +
			"(collectorId, " +
			"item_code, " +
			"device_index, " +
			"date_time, " +
			"facilityid, " +
			"value) " +
			"values (?,?,?,?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,collectorID);
			stmt.setString(2, data.getItemCode());
			stmt.setInt(3, data.getDeviceIndex());
			stmt.setTimestamp(4, time);
			stmt.setString(5, data.getFacilityID());
			if(Double.isNaN(data.getValue())){
				stmt.setNull(6, Types.DOUBLE);  // ǽͤǽänull񤭹
			} else {
				stmt.setDouble(6, data.getValue());
			}
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				throw new SQLException(msg);
			}
		} catch (SQLException e) {
			m_log.error("insert() error :" + collectorID + " EJBException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("insert() error :" + collectorID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("insert() end   : " + collectorID +
					" " + data.getItemCode() +
					" " + data.getDeviceIndex() +
					" " + data.getFacilityID());
		}	
	}
	/**
	 * ¸֤᤮ͤޤ
	 * @param collectorID
	 * @param startDate
	 * @throws EJBException
	 */
	public void deleteOverPresave(String collectorID , Date startDate)
		throws EJBException{
			
			m_log.debug("deleteOrverPresave() start :" + collectorID + " " + startDate.toString());

			Connection conn = null;
			PreparedStatement stmt = null;
			Timestamp time = new Timestamp(startDate.getTime());
			
			try{
				conn = ConnectionManager.getConnectionManager().getConnection();
				//conn.setAutoCommit(false);
				//SQLʸ
				String sql = "DELETE FROM CALCULATED_DATA WHERE COLLECTORID = ? AND DATE_TIME < ?";
				//SQLʸΥå
				stmt = conn.prepareStatement(sql);
				
				stmt.setString(1,collectorID );
				stmt.setTimestamp(2,time);
				
				stmt.executeUpdate();
			} catch (SQLException e) {
				m_log.debug("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException ");

				throw new EJBException(e.getMessage());
			}  finally{
				
				//ͥ󡢷̥åȡץڥɥơȥȤΥ
				try {
					if(stmt != null){
						stmt.close();
					}
					if(conn != null){
						conn.close();
					}
				} catch (SQLException e1) {
					m_log.debug("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException ");
					throw new EJBException(e1.getMessage());
				}
				m_log.debug("deleteOrverPresave() end :" + collectorID + " " + startDate.toString() + "  EJBException ");
			}	
	}

/**
 * ƥȤޤ
 * @param collectorID
 * @return
 * @throws EJBException
 */
	public int recountFromDB(String collectorID)throws EJBException{
		
		m_log.debug("recountFromDB() start :" + collectorID );
		
		Connection conn = null;
		PreparedStatement stmt =null;
		ResultSet res = null; 
		int ret = 0;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQLʸκ
			String sql = "SELECT COUNT(*) AS COLLECT_COUNT FROM calculated_data " +
			"WHERE collectorid =? group by item_code , facilityid limit 1";
			
			// SQLʸȯԽ
			stmt = conn.prepareStatement(sql);
			
			
			stmt.setString(1,collectorID);
			
			res = stmt.executeQuery();
			
			if(res.next()){
				ret = res.getInt("COLLECT_COUNT");
			}
		} catch (SQLException e) {
			m_log.error("recountFromDB() error :" + collectorID + " EJBException ",e);
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("recountFromDB() error :" + collectorID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("recountFromDB() end   :" + collectorID + " ");
		
		return ret;
	}
}
