/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/


package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.EJBException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;

/**
 * оݥץĥ꡼γƥסΡɤδطݻ
 * Υեƥʥפ⤷ϥΡɡˤǽͤ򻻽Ф֤ǽ󶡤륯饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class ScopeTree implements Serializable {
	//	
	protected static Log m_log = LogFactory.getLog(ScopeTree.class);
	
//	//** 롼ȤȤʤեƥID */
//	private static String rootScopeID = "root";
//	//**롼ȤȤʤեƥ̾Ρ*/
//	private static String rootScopeName = "root";
	
	private Hashtable m_scopeTable;  // ׾ݻơ֥
	private Hashtable m_nodeTable;   // Ρɾݻơ֥
	
	private long m_lastCollectTime;			// ǽݻ
	
	// MIBݤ󤬹Ƥ뤫Υե饰
	// ݡ󥰤˼Ԥ󤬹ƤʤfalseȤʤ
	private boolean updateFlag;

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param treeItem FacilityTreeItemγإ֥
	 */
	public ScopeTree(FacilityTreeItem treeItem){
		m_log.debug("ScopeTree 󥹥ȥ饯");
		
		m_scopeTable = new Hashtable();
		m_nodeTable = new Hashtable();
		
		this.setScopeTree(treeItem);
	}
	
	/**
	 * եƥĥ꡼˥פɲäޤ
	 * 
	 * @param facilityID
	 * @param facilityName
	 * @param parents
	 */
	public void addScope(final String facilityID, final String facilityName, final String parent) {
		Scope scope = new Scope(facilityID, facilityName);
		
		// ƥեƥ
		Scope parentScope = (Scope)m_scopeTable.get(parent);
			
		if (parentScope == null) {
		} else {
			// ɲåեƥ˿ƤϿ롣
			scope.addParents(parentScope);
				
			// ƥեƥϿ롣
			parentScope.addChildren(scope);		
		}
		
		// եƥơ֥˥եƥɲ
		m_scopeTable.put(facilityID, scope);
	}
	
	/**
	 * եƥĥ꡼˥Ρɤɲäޤ
	 * 
	 * @param facilityID
	 * @param facilityName
	 * @param parents
	 */
	public void addNode(final String facilityID, final String facilityName, final String parent) {
		// ƱIDΥΡɤϿƤ뤫ɤĴ٤
		Node node = (Node)m_nodeTable.get(facilityID);
		if(node == null){
			node = new Node(facilityID, facilityName);
		}
		
		// ƥեƥ
		Scope parentScope = (Scope)m_scopeTable.get(parent);	
		if (parentScope == null) {
			// 顼
		} else {
			// ɲåեƥ˿ƤϿ롣
			node.addParents(parentScope);
			
			// ƥեƥ˥ΡɤϿ롣
			parentScope.addChildren(node);		
		}
		
		// Ρɥơ֥˥Ρɤɲ
		m_nodeTable.put(facilityID, node);
	}
	
	/**
	 * ΥեƥIDΥեƥ⤷ϥΡɤ¸ߤ뤫ݤȽꤷޤ
	 * 
	 * @param facilityID
	 * @returntrue ¸ߤ롡false ¸ߤʤ
	 */
	public boolean contains(String facilityID){
		Scope scope = (Scope)m_scopeTable.get(facilityID);	
		Node node = (Node)m_nodeTable.get(facilityID);
		if(scope == null && node == null){
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * եƥ˴ޤޤΡɤΥեƥIDΥꥹȤ֤ޤ
	 * 
	 * @param facilityID եƥID
	 * @return ΡɤΥեƥIDΥꥹ
	 */
	public String[] getNodeIDList(String facilityID){
		Scope scope = (Scope)m_scopeTable.get(facilityID);	
		
		String[] nodeListFaciliyID = null;
		
		HashSet nodeListSet = new HashSet();
		if (scope != null){
			// եƥפǤä
			scope.getNode(nodeListSet);
			Node[] nodeList = new Node[nodeListSet.size()];
			nodeListSet.toArray(nodeList);
			
			nodeListFaciliyID = new String[nodeList.length];
			for(int i=0; i<nodeList.length; i++){
				nodeListFaciliyID[i] = nodeList[i].getFacilityID();
			}
		} else {
			// եƥΡɤǤä
			Node node = ((Node)m_nodeTable.get(facilityID));
			
			if(node != null){
				nodeListFaciliyID = new String[1];
				nodeListFaciliyID[0] = node.getFacilityID();
			} else {
				// 顼
				String message= "Facility not found : " + facilityID;
				throw new EJBException(message);
			}
		}
		
		return nodeListFaciliyID;
	}
	
	/**
	 * եƥΥ֥եƥΥեƥIDΥꥹȤ֤ޤ
	 * 
	 * @param facilityID
	 * @return ֥եƥΥեƥIDΥꥹ
	 */
	public String[] getSubScopeIDList(String facilityID){
		Scope scope = (Scope)m_scopeTable.get(facilityID);
		
		if(scope == null){
			// 顼
			String message= "Facility not found : " + facilityID;
			throw new EJBException(message);
		}	
		
		return scope.getChildrenID();
	}
	
	/**
	 * եƥʲ˴ޤޤΡɤMIBͤꤹ롣
	 * 
	 * @param facilityId եƥID
	 * @param oids оݤOID
	 * @param interval ֳ
	 */
	synchronized public void fetchMibValue(final String facilityId, final OIDInfo[] oids, int interval){
		// եƥβ˴ޤޤƤΥΡɤΥեƥID
		String[] nodeFid = getNodeIDList(facilityId);

		for(int i=0; i<nodeFid.length; i++){
			Node node = ((Node)m_nodeTable.get(nodeFid[i]));
			
			if(node != null){
				// MIBͤꤹ
				long lastCollectTime = node.fetchMibValue(oids, interval);

				// ݻ
				long collectTimeBuffer = m_lastCollectTime;
				
				// ƤΥΡɤǻפ뤿˺Ǹ˼줿ΡɤͤμȤ
				m_lastCollectTime = Math.max(m_lastCollectTime, lastCollectTime);
				
				// Ⱥμ郎ۤʤХե饰trueȤ
				updateFlag = m_lastCollectTime != collectTimeBuffer;
			} else {
				// 顼
				String message= "Facility not found : " + nodeFid[i];
				throw new EJBException(message);
			}
		}
	}
	
	/**
	 * оݥեƥǽͤ򻻽Ф֤
	 * 
	 * @param facilityID եƥID
	 * @param itemCodeܥ 
	 * @param deviceIndexǥХΥǥå 
	 * @return ׻줿ǽǡ
	 */
	synchronized public CollectedDataInfo getValue(
			final String facilityID, 
			final String itemCode, 
			final int deviceIndex){
		double value = Double.NaN;
		
		// פξ
		Facility facility = (Facility)m_scopeTable.get(facilityID);
		
		// Ρɤξ
		if(facility == null){
			facility = (Facility)m_nodeTable.get(facilityID);
		}
		
		if(facility == null){
			// 顼
			// ϿƤʤեƥ򻲾Ȥ褦Ȥ
			String message= "Facility not found : " + facilityID;
			throw new EJBException(message);
		} else {
			value = facility.calcValue(itemCode, deviceIndex);
		}		
		
		CollectedDataInfo ret = new CollectedDataInfo(facilityID, itemCode, deviceIndex);
		
		// ݡ󥰤η̤ǤƤ뤫ݤǼѤ
		// ƱǤduplicate keyȯDB˳ǼǤʤ
		if(updateFlag){
			ret.setDate(new Date(m_lastCollectTime));  // 
		} else {
			ret.setDate(new Date());  // 
		}

		ret.setValue(value);  // ǽͤ
		
		return ret;
	}

	/**
	 * ꥢ륿ͤ򻻽ФǤʤäˡη׻η׻֤ͤ
	 * 
	 * @param facilityID եƥID
	 * @param itemCodeܥ 
	 * @param deviceIndexǥХΥǥå 
	 * @return ׻줿ǽǡ
	 */
	synchronized public CollectedDataInfo getTempValue(
			final String facilityID, 
			final String itemCode, 
			final int deviceIndex){
		double value = Double.NaN;
		
		Facility facility = (Facility)m_scopeTable.get(facilityID);
		
		if(facility == null){
			facility = (Facility)m_nodeTable.get(facilityID);
		}
		
		if (facility == null){
			// 顼
			// ϿƤʤեƥ򻲾Ȥ褦Ȥ
			String message= "Facility not found : " + facilityID;
			throw new EJBException(message);
		} else {
			value = facility.getCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex));
		}
		
		CollectedDataInfo ret = new CollectedDataInfo(facilityID, itemCode, deviceIndex);
		if(m_lastCollectTime == 0){
			// ޤǰ٤Ƥʤ(μ)
			ret.setDate(new Date());  // 
			ret.setValue(Double.NaN); // ǽͤȤNaN
		} else {
			ret.setDate(new Date(m_lastCollectTime));  // 
			ret.setValue(value);  // ǽͤ
		}
		
		return ret;
	}

	/**
	 * Υեƥ֤ޤ
     *
	 * @param facilityID եƥID(פ⤷ϥΡ)
	 * @return
	 */
	public Facility getFacility(final String facilityID){
		Scope scope = (Scope)m_scopeTable.get(facilityID);	
		Node node = (Node)m_nodeTable.get(facilityID);
		
		if (scope != null && node == null){
			return scope;		
		} else if (scope == null && node != null){
			return node;
		} else {
			// 顼
			String message= "Facility not found : " + facilityID;
			throw new EJBException(message);
		}
	}
	
	/**
	 * եƥĥ꡼Ƥꤷޤ
	 * 
	 * @param treeItem FacilityTreeItemγإ֥
	 */
	private void setScopeTree(FacilityTreeItem treeItem) {
		FacilityInfo info = treeItem.getData();
		
		// եƥפξ
		if(info.getType() == FacilityConstant.TYPE_SCOPE){
			this.addScope(info.getFacilityId(), 
					info.getFacilityName(), 
					treeItem.getParent().getData().getFacilityId()
					);
		} else 			
		// եƥΡɤξ
		if(info.getType() == FacilityConstant.TYPE_NODE){			
			this.addNode(
					info.getFacilityId(),
					info.getFacilityName(),
					treeItem.getParent().getData().getFacilityId()
					);
		}
		
		// ҥեƥ
		FacilityTreeItem[] tmpItem = treeItem.getChildren();
		
		if(tmpItem.length != 0){  // ҥեƥФƺƵŪ
			for(int i = 0; i < tmpItem.length; i++){
				setScopeTree(tmpItem[i]);
			}
		}
	}

	/**
	 * ΥեƥIDΥ֥ȤפݤȽꤷޤ
	 * @param facilityID եƥID
	 * @return ΥեƥIDΥ֥Ȥפξ true ֤ޤ
	 */
	public boolean isScope(final String facilityID){
		return m_scopeTable.get(facilityID) != null;
	}
	
	/**
	 * ΥեƥIDΥ֥ȤΡɤݤȽꤷޤ
	 * @param facilityID եƥID
	 * @return ΥեƥIDΥ֥ȤΡɤξ true ֤ޤ
	 */
	public boolean isNode(final String facilityID){
		return m_nodeTable.get(facilityID) != null;
	}
	
	/**
	 * ϿƤƤΥפޤ
	 * @return פΥեƥID
	 */
	public String[] getAllFacilityIdList(){
		// ֵͤǼ
		String[] ret = new String[m_nodeTable.size() + m_scopeTable.size()];

		int i=0;
		
		// פΥեƥID
		Iterator itr = m_scopeTable.values().iterator();
		while(itr.hasNext()){
			Scope scope = (Scope)itr.next();
			ret[i] = scope.getFacilityID();
			i++;
		}

		// ΡɤΥեƥID
		itr = m_nodeTable.values().iterator();
		while(itr.hasNext()){
			Node node = (Node)itr.next();
			ret[i] = node.getFacilityID();
			i++;
		}
		
		return ret;
	}

	/**
	 *  ߥݡ餫餳Υ֥Ȥ˼MIBͤ
	 *  Ǹ˼Τλޤ
	 *  
	 * @return ǽ
	 */
	public long getLastCollectTime() {
		return m_lastCollectTime;
	}
}
