/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Facilityμ饹
 * 
 * ̤פǤեƥǽͤ򻻽Сݻޤ
 * ҥեƥʿͤǽͤȤƻФޤ
 * ScopeTree饹ǻѤ뤳ȤŪȤ饹Ǥ
 * 
 * @version 1.0
 * @since 1.0
 */
public class Scope extends Facility {
	//	
	protected static Log m_log = LogFactory.getLog( Node.class );
	
	private TreeSet m_children = null;
	private HashSet m_nodes = null;	// ΥפľˤΡɤΥꥹ
	
	Scope(final String facilityID, final String faclityName){
		super(facilityID, faclityName, Facility.SCOPE);
		m_children = new TreeSet();
		m_nodes = new HashSet();
	}
	
	/**
	 * եƥλҶΥեƥɲä롣
	 * @param child ҶΥեƥ
	 */
	public void addChildren(final Facility child){
		m_children.add(child);
		
		// ǤΡɤξϥΡɥơ֥ˤɲä
		if(child.getType() == Facility.NODE) {
			m_nodes.add(child);
		}
	}
	
	/**
	 * Υեƥʲ˴ޤޤΡɤޤ
	 * @param nodeSet
	 * @return HashSet
	 */
	public HashSet getNode(HashSet nodeSet){
		Iterator itr = m_children.iterator();
		
		// ΥľΥΡɤɲä롣
		nodeSet.addAll(m_nodes);
		
		// ҥפΥΡɤƵŪ˼롣
		while(itr.hasNext()){
			// ҥפ롣
			Facility child = (Facility)itr.next();
			
			// оݤλҥפפξϺƵŪ˼롣
			if(child.getType() == Facility.SCOPE){
				((Scope)child).getNode(nodeSet);
			}
		}
		
		return nodeSet;
	}
	
	/**
	 * ΥեƥΰʲΥեƥ˴ޤޤΡɤοޤ
	 * @return int ΥեƥʲƤΥեƥο
	 */
	public int getNodeCount() {
		int count = 0;
		Iterator itr = m_children.iterator();
		
		// ҥեƥΥΡɤƵŪ˼롣
		while(itr.hasNext()){
			// ҥեƥ롣
			Facility child = (Facility)itr.next();
			
			count += child.getNodeCount();
		}
		
		return count;
	}
	
	/**
	 * ǽͤ
	 * @return ǽ 
	 */
	public double calcValue(final String itemCode, final int deviceIndex){
		double total = 0;
		int counter = 0;
		
		Iterator itr = m_children.iterator();
		
		while(itr.hasNext()){
			// ҥեƥ
			Facility child = (Facility)itr.next();
			
			// ҥեƥλ¹˥ΡɤޤޤϤΥեƥ׻оݤȤ롣
			if(child.getNodeCount() != 0) {
				double childValue = child.calcValue(itemCode, deviceIndex);

				// Ƕλз̤׻ǽξϡͤѤ
				if(Double.isNaN(childValue)){
					childValue = 
						child.getCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex));
				}
				
				// ǽͤλФǤʤ(ǽͻмʬ줬0ˤʤ褦ʾ)ϡ
				// childValue ͤϡNaNȤʤ롣
				// Ǥϡǽͤ˻ФǤƤΡɤǽͤΤߤѤ
				// ɽͤλФԤ
				// ʿѤʬȤʤΡɿϡǽͤ򻻽ФǤΡɤοȤʤ롣
				if(!Double.isNaN(childValue)){
					total += childValue;
					counter++;
				}
			}
		}
		
		double returnValue;
		
		// ɽͤΡɤʿѤǵ롣
		// ʬȤʤ륹׿0ξϡʿͤ׻ǤʤᡢɽͤNaNȤ롣
		if(counter != 0){
			returnValue = (double)total / counter;
		} else {
			returnValue = Double.NaN;
		}
		
		// ǽͤФǤϥХåե¸
		if(!Double.isNaN(returnValue)){
			setCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex), returnValue);
		}
		
		m_log.debug("calcValue() : " + m_facilityID + " " + 
				itemCode + " " + deviceIndex + "  " + returnValue);
		
		return returnValue;
	}
	
	/**
	 * ΥեƥλҶΥեƥΥեƥIDΥꥹȤ֤ޤ
	 * 
	 * @returnҶΥեƥΥꥹ
	 */
	public String[] getChildrenID(){
		String[] facilityIDs = new String[m_children.size()];
		
		Iterator itr = m_children.iterator();
		
		for(int i=0; itr.hasNext(); i++){
			facilityIDs[i] = ((Facility)itr.next()).getFacilityID();
		}
		return facilityIDs;
	}
}
