/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.lang.Double;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.dao.RecordDataDAO;
import com.clustercontrol.performanceMGR.util.CalculationMethod;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.SnmpSharedTable;

/**
 * FacilityΥΡɼ饹
 * ̤ΡɤǤեƥǽͤݻޤ
 * ScopeTree饹ǻѤ뤳ȤŪȤ饹Ǥ
 * 
 * @version 1.0
 * @since 1.0
 */
public class Node extends Facility {
	//	
	protected static Log m_log = LogFactory.getLog( Node.class );
	
	private HashMap m_mibValueSet; // ǽͤη׻ɬפMIBͤν
	
	private long lastCollectTime;   // ǽ
		
	/**
	 *󥹥ȥ饯 
	 * @param facilityID
	 * @param faclityName
	 * @param ipAddress
	 */
	Node(final String facilityID, final String faclityName){
		super(facilityID, faclityName, Facility.NODE);
		
		m_mibValueSet = new HashMap();
	}
	
	/**
	 * ǽͤᤷޤ
	 * 
	 * @param  itemCode ܥ
	 * @param  deviceIndex ǥХֹ
	 * @return ǽ
	 */
	public double calcValue(final String itemCode, final int deviceIndex){
		double value = CalculationMethod.getPerformance(itemCode, deviceIndex, m_mibValueSet);
		
		m_log.debug("calcValue() : " + m_facilityID + " " + 
				itemCode + " " + deviceIndex + "  " + value);
		
		// ǽͤФǤϥХåե¸
		if(!Double.isNaN(value)){
			setCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex), value);
		}
		
		return value;
	}

	
	/**
	 * ݡ顼ͤޤ
	 * 
	 * @param oids оݤOID
	 * @param interval ֳ
	 * @return ƤΥΡɤǰפ뤿˺Ǹ˼줿ͤμȤ
	 */
	public long fetchMibValue(final OIDInfo[] oids, int interval) {
		m_log.debug("fetchMibValue() start :");
		
		// ͤ񤭹OIDͤ2ٽ񤭹ޤʤ褦˽񤭹OIDݻ
		HashSet<String> checkOid = new HashSet<String>();  
		
		// SNMPͤζͭơ֥ååפޤ
		SnmpSharedTable sst = null;
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			
			Object obj = iniCtx.lookup(SnmpPollerConstant.JNDI_NAME);

			// ֥Ȥ򥭥㥹Ȥޤ
			sst = (SnmpSharedTable)PortableRemoteObject.narrow(obj, SnmpSharedTable.class);
		} catch (NamingException e) {
			// 顼
			throw new EJBException(e.getMessage());
		}
		
		// ǽͤλФɬפMIBͤ
		for(int i=0; i<oids.length; i++){
			// ǥХƤоݤȤ뤫ݤǾʬ
			if(!oids[i].isAllIndex()){
				
				String oid = oids[i].getOID();
				ValueObject value = sst.getValue(getFacilityID(), interval, oid);
				
				if(value == null){
					// 顼
					m_log.debug("Node : " + getFacilityID() + " can't get value " + oids[i].getOID());
					
					// оݤOIDͤޤåȤƤʤΤ߽Ԥ
					if(!checkOid.contains(oid)){	
						// ͤ򥻥åȤ
						setMibValueSet(oids[i].getBaseOid(), oids[i].getOidIndex(), 0);
						checkOid.add(oid);  // 񤭹ߺѤߤOIDꤹ
					}
				} else {
					String mibValueString = (String)value.getValue();
					
					// ǥХå
					m_log.debug("Node : " + getFacilityID() + " " + oids[i].getOID() + " " + value);
					
					// оݤOIDͤޤåȤƤʤΤ߽Ԥ
					if(!checkOid.contains(oid)){	
						// ͤ򥻥åȤ
						setMibValueSet(oids[i].getBaseOid(), oids[i].getOidIndex(), Long.parseLong(mibValueString));
						checkOid.add(oid);  // 񤭹ߺѤߤOIDꤹ
						lastCollectTime = Math.max(lastCollectTime, value.getDate());
					}
				}
				
			} else {
				int j=0; // ơ֥륤ǥå򥤥󥯥Ȥ뤿ѿ
				
				String oid = oids[i].getBaseOid() + "." + j;			
				
				// оݤOIDͤޤåȤƤʤΤ߽Ԥ
				if(!checkOid.contains(oid)){	
					// ơ֥륤ǥå0ΤΤ¸ߤʤᡢߡǡ
					setMibValueSet(oids[i].getBaseOid(), j++, Long.MIN_VALUE);
					checkOid.add(oid);  // 񤭹ߺѤߤOIDꤹ
				}
				
				oid = oids[i].getBaseOid() + "." + j;
				ValueObject value = null;
				while((value = sst.getValue(getFacilityID(), interval, oid)) != null){
					// ǥХå
					m_log.debug("Node : " + getFacilityID() + " " + oids[i].getOID() + " " + value);
					
					// оݤOIDͤޤåȤƤʤΤ߽Ԥ
					if(!checkOid.contains(oid)){	
						// ͤ򥻥åȤ(ǥå0ˤͤ򤤤줺ˡ1ͤ)
						setMibValueSet(oids[i].getBaseOid(), j, Long.parseLong((String)value.getValue()));
						checkOid.add(oid);  // 񤭹ߺѤߤOIDꤹ
						lastCollectTime = Math.max(lastCollectTime, value.getDate());
					}
					j++;  // 󥯥
					oid = oids[i].getBaseOid() + "." + j;
				}
				
				if(j == 1){
					// 顼
					m_log.debug("Node : " + getFacilityID() + " can't get value " + oids[i].getBaseOid() + ".*");
				}
			}
		}
		
		m_log.debug("fetchMibValue() end :");
		return lastCollectTime;
	}
	
	/**
	 * 
	 * ǿMIBͤꤷޤ
	 *  
	 * @param baseOid оOIDκǸ"."ɽʸ
	 * @param tableIndexоOIDκǸ"."ʲο
	 * @param mibValue
	 */
	private void setMibValueSet(final String baseOid, final int tableIndex, final long mibValue) {
		m_log.trace("setMibValueSet() :" + baseOid + " " + tableIndex + "  " + mibValue);
		long[][] mibValueSetList = (long[][])m_mibValueSet.get(baseOid);
		
		// ͤǼ󤬳ݤƤʤ
		if (mibValueSetList == null){
			mibValueSetList = new long[tableIndex+1][2];
			
			// ơ֥ɲ
			m_mibValueSet.put(baseOid, mibValueSetList);
		} else 	if (mibValueSetList.length <= tableIndex){	// ߳ݤƤΰΥǥå礭
			// ΰ	
			long[][]buffer = new long[tableIndex+1][2];
			
			// ˳ݤΰ򥳥ԡ
			for(int i=0; i<mibValueSetList.length; i++){
				buffer[i] = mibValueSetList[i];
			}
			
			mibValueSetList = buffer;
			
			// ơ֥ɲ
			m_mibValueSet.put(baseOid, mibValueSetList);
		}
		
		// ǥץԡ
		// ޤݻƤͤͤȤꡣ
		mibValueSetList[tableIndex][0] = mibValueSetList[tableIndex][1];
		
		// ͤꡣ
		mibValueSetList[tableIndex][1] = mibValue;
	}
	
	/**
	 * ʬȤ֤
	 * @return HashSet 
	 */
	public HashSet getNode(HashSet nodeSet){
		nodeSet.add(this);
		return nodeSet;
	}
	
	/**
	 * ʬȤ򥫥Ȥ֤
	 */
	public int getNodeCount(){
		return 1;
	}
	
	/**
	 * ݻƤMIBͤDB˽Ϥ
	 *
	 */
	public void storeMibValue(String collectorId){
		m_log.debug("storeRowMibValue() :" + collectorId);

		// DBسǼ
		Date date = new Date();  // ߤλȤ
		
		// MIBͤǼ뤿Υơ֥˥ǽʥ֥Ȥ
		RecordDataDAO dao = new RecordDataDAO();
		
		// m_mibValueSet ΥOID(ǸΥǥå)
		Iterator itr = m_mibValueSet.keySet().iterator();  

		while(itr.hasNext()){
			String baseOid = (String)itr.next();

			long[][] mibValueSetList = (long[][])m_mibValueSet.get(baseOid);

			for(int i=0; i<mibValueSetList.length; i++){
				String fullOid = baseOid + "." + i;
				
				dao.insertRecordData(
						collectorId, 
						fullOid,
						date,
						getFacilityID(),
						mibValueSetList[i][0]);
			}
		}
	}
}
