/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

import com.clustercontrol.performanceMGR.dao.CalculatedDataDAO;

/**
 * ƥեƥƵŪǽͤλФ򤹤Τɬפʥ᥽åɤ֥ȥ饯ȥ饹
 * 
 * @version 1.0
 * @since 1.0
 */
public abstract class Facility implements Serializable, Comparable {
	/** ̤֥ݥåȡפǤ뤳Ȥɽ */
	public static final int COMPOSITE = 0;
    
	/** ̤֥ספǤ뤳Ȥɽ */
	public static final int SCOPE = 1;
	
	/** ̤֥ΡɡפǤ뤳Ȥɽ */
	public static final int NODE = 2;
	
	protected String m_facilityID;
	private String m_facilityName;
	private int m_type;
	private HashSet m_parents = null;
	private HashMap m_calcValues;
	private HashMap m_calcTempValues;
	
	public Facility(String facilityID, String faclityName, int type) {
		m_facilityID = facilityID;
		m_facilityName = faclityName;
		m_type = type;
		m_parents = new HashSet();
		m_calcValues = new HashMap();
		m_calcTempValues = new HashMap();
	}
	
	/**
	 * DB ѥ󥹥ȥ饯
	 * 
	 * @param facilityID
	 * @param faclityName
	 * @param type
	 */
	public Facility(String facilityID, String faclityName, String type) {
		m_facilityID = facilityID;
		m_facilityName = faclityName;
		setTypeString(type);
		m_parents = new HashSet();
	}
	
	/**
	 * Ǥɲäޤ
	 * @param paretnt 
	 */
	public void addParents(Facility paretnt){
		
		this.getParents().add(paretnt);
	}
	
	/**
	 *  ΥեƥΰʲΥפ˴ޤޤΡɤο֤ޤ
	 * @return Ρɤο
	 */
	protected int getNodeCount(){
		return 0;
	}

	/**
	 * ׻Ѥǽ֤ͤޤ
	 * @return ׻Ѥǽ
	 */
	abstract public double calcValue(final String itemCode, final int deviceIndex);
	
	/**
	 * եƥIDޤ
	 * @return FacilityID ᤷޤ
	 */
	public String getFacilityID() {
		return m_facilityID;
	}
	
	/**
	 * եƥ̾Τޤ
	 * @return FacilityName եƥ̾
	 */
	public String getFacilityName() {
		return m_facilityName;
	}
	
	/**
	 * ƤΥեƥޤ
	 * @return Parents ƤΥեƥ
	 */
	public HashSet getParents() {
		return m_parents;
	}
	
	/**
	 * typeޤ
	 * @return Type 
	 */
	public int getType() {
		return m_type;
	}
	
	/**
	 * typeޤ
	 * @return Type "scope" or "node"
	 */
	public String getTypeString() {
		String returnValue = null;
		if(m_type == Facility.SCOPE){
			returnValue = "scope";
		} else if(m_type == Facility.NODE){
			returnValue = "node";	
		}
		return returnValue;
	}

	/**
	 * եƥIDꤷޤ
	 * @param facilityid եƥID
	 */
	public void setFacilityID(String facilityid) {
		m_facilityID = facilityid;
	}
	
	/**
	 * typeꤷޤ
	 * @param type "scope" or "node"
	 */
	public void setTypeString(String type) {
		if(type.equals("scope")){
			this.m_type = Facility.SCOPE;
		} else if(type.equals("node")){
			this.m_type = Facility.NODE;		
		}
	}
	
	/**
	 * ΥեƥȻꤵ줿եƥνӤޤ
	 * @param o оݤΥեƥ
	 * @return Υ֥Ȥꤵ줿֥Ȥ꾮
	 *         ϥ礭
	 */
	public int compareTo(Object o){
		return m_facilityID.compareTo(((Facility)o).getFacilityID());
	}
	
	public double getCalcValueBuffer(CollectorItemPK item){
		Double value = (Double)m_calcTempValues.get(item);
		
		if(value == null){
			return Double.NaN;
		} else {
			return value.doubleValue();
		}
	}
	
	public void setCalcValueBuffer(CollectorItemPK item, double data){
		m_calcTempValues.put(item, new Double(data));
	}
}
