/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;

/**
 * ܤPK饹
 * 
 * @version 1.0
 * @since 1.0
 *
 */
public class CollectorItemPK implements Serializable
{
   private String itemCode;
   private int    deviceIndex;

   public CollectorItemPK(){}

   /**
    * 󥹥ȥ饯
    * ܥɤȥǥХֹꤷ֤ǡCollectorItemPK饹Υ󥹥󥹤ޤ
    * 
    * @param itemCode ܥ
    * @param deviceIndex ǥХֹ
    */
   public CollectorItemPK(String itemCode, int deviceIndex){
      this.itemCode = itemCode;
      this.deviceIndex = deviceIndex;
   }

   /**
    * ܥɤޤ
    * @return ID
    */
   public String getItemCode(){
      return itemCode;
   }
   
   /**
    * ǥХֹޤ
    * @return ID
    */
   public int getDeviceIndex(){
      return deviceIndex;
   }
   
   /**
    * Υ֥Ȥ¾Υ֥Ȥɤ򼨤ޤ
    */
   public boolean equals(Object o) {  	
	   if(this == o){
		   return true;
	   }
	   
	   if(o instanceof CollectorItemPK){
		   CollectorItemPK other = (CollectorItemPK)o;
		   boolean equals = false;
		   
		   if(this.itemCode == null || other.itemCode == null){
			   equals = false;
		   } else  if(itemCode.equals(other.itemCode) && deviceIndex == other.deviceIndex){
			   equals = true;
		   }
		   
		   return equals;
	   } else {
		   return false;
	   }
   }
   
   /**
    * ֥ȤΥϥå女֤ͤޤ
    */
   public int hashCode() {
	   int result = 17;
	   
	   result = 37*result + ((this.itemCode != null) ? this.itemCode.hashCode() : 0);
	   result = 37*result + deviceIndex;
	   
	   return result;
   }
}
