/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import javax.ejb.RemoveException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;

/**
 * ѤߥǡκԤ󥯥饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class DeleteCollectedDataAction implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.performance.view.action.DeleteCollectedDataAction";
	
    private IViewPart viewPart; // ӥ塼

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        /*
         * ƤӽФViewäƤޤ
         */
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        CurrentListView listView = (CurrentListView) page
                .findView(Messages.getString("VIEW_CURRENT_LIST"));

        /*
         * ơ֥ФƤIDޤ
         */
        if (listView.getSelectedID() != null) {
    		// ʤξ硢顼ɽ
        	if(!RecordController.getInstance().checkPermissionWrite()){
        		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
        				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
        		return;
        	}
        	
            String msg = Messages.getString("MESSAGE_0028") + " " + 
            listView.getSelectedID() + 
            Messages.getString("MESSAGE_0016");

            if (MessageDialog.openQuestion(null, Messages
                    .getString("MESSAGE_0020"), msg)) { // "ǧ"

                // Bean
                RecordController controller = RecordController.getInstance();
                // ޥ͡Ȥ³˼Ԥϥ顼ɽ
                if (controller == null) {
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),
                            Messages.getString("CONNECTION_ERROR_MESSAGE"));
                    return;
                }

                try {
                    // å
                    RecordController.getInstance().unlock();
                	
                    // ǡ
                    if (!controller.deleteRecordCollector(listView
                            .getSelectedID())) {
                        // ǡκ˼Ԥϥ顼ɽ
                        MessageDialog.openError(
                                        this.viewPart.getSite().getShell(),
                                        Messages.getString("MESSAGE_0020"),
                                        Messages.getString("DELETE_DATA_ERROR_MESSAGE"));
                    }
                } catch (RemoveException e) {
                    // åäƤ뤿Ǥʤν
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),
                            Messages.getString("DELETE_DATA_LOCKED_MESSAGE"));
                }

                //ѤߤΥꥹȤΥեåԤޤ
                listView.refresh();
            } else {
            }
        } else {

            String msg = Messages.getString("MESSAGE_0014");

            MessageDialog.openError(null,
                    Messages.getString("ERROR_IN_JP"), msg);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}