/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.bean.GraphConstant;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.composite.RecordGraphHolderComposite;
import com.clustercontrol.performance.preference.PerformancePreferencePage;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.view.ScopeListBaseView;

import org.jfree.data.time.Second;
/**
 * ӥɽԤView饹
 * 
 * @version 1.0
 * @since 1.
 */
public class RecordGraphView extends ScopeListBaseView {

    public static final String ID = Messages.getString("VIEW_RECORD_GRAPH");

    private RecordGraphHolderComposite graphCompositeR = null;

    public RealtimeGraphComposite graphComposite = null;

    // ɽоݤμ
    private CollectorProperty collectorProperty;

    //ɽδܾ(ɽֳ֤ʤ)ݻΰݤ롣
    public RealtimeCollectorInfo collectorInfo;

    public RealtimeCollectorItemInfo collectorItemInfo;

    private Composite parent;
    
	public FacilityTreeItem item;
    
	private PerformancePreferencePage perfPrePage;
	
    // staticǤʤСͳߤ뤳ȤǤʤ
    static boolean isRequestCollectorToRun = false;
	
    /**
     *  
     */
    public RecordGraphView() {
        super();
        initialize();
    }

    
    private void initialize() {

        //ɽδܾ(ɽֳ֤ʤ)ݻΰݤ롣
        collectorInfo = new RealtimeCollectorInfo();
        //ɽɽǡܾ(ɽֳ֤ʤ)ݻΰݤ롣
        collectorItemInfo = new RealtimeCollectorItemInfo();
        
        // ͤ0(auto)Ǥ.auto򥻥åȤƤ.
        collectorInfo.setGraphPlotNum(0);
		
		// ץե󥹥饹Υ󥹥󥹤롣
		perfPrePage = new PerformancePreferencePage();
    }
    
    
    /**
     * 򤵤줿(Ρ)ξɽޤ
     * 
     * @param item
     *            ץĥ꡼ƥ
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {
  	  
		if (this.collectorProperty != null) {
			//פΥѥ˼IDɲä
			Label pathLabel = this.getPathLabel();
			pathLabel.setText(this.getPathLabel().getText() + " \n" 
					+Messages.getString("COLLECTION_ID") + " : " + collectorProperty.getCollectorData().getCollectorID());
			this.getBaseComposite().layout(true, true);
		}
    	
  	  if (collectorInfo.getFacilityId() != null && 
			  collectorInfo.getFacilityId().equals(item.getData().getFacilityId())) {
		  // ⤷ʤ(ϢǤؤн)
	  } else {
	  	  //򤵤줿׾򥰥մܾ˽񤭹ࡣ
	  	  collectorInfo.setFacilityId(item.getData().getFacilityId());
	  	  collectorInfo.setSubScopeNum(item.getChildren().length);
	  	  		  
	  	  //򤵤줿פΥ֥׾򥰥մܾ˽񤭹ࡣ
			  //ǡľܥǤꥹȤǤǤʤΤǰöݻ롣
	  	  FacilityTreeItem[] childrenList = item.getChildren();
	  	  
	  	  // եƥID¤ؤ
    	  Arrays.sort(childrenList, new Comparator(){
    		  public int compare(Object o1, Object o2) {
    			  if (o1 instanceof FacilityTreeItem && o2 instanceof FacilityTreeItem) {
    				  String object1 = ((FacilityTreeItem) o1).getData().getFacilityId();
    				  String object2 = ((FacilityTreeItem) o2).getData().getFacilityId();
    				  
    				  return object1.compareTo(object2);
    			  }
    			  return 0;
    		  }
    	  });
	  	  
	  	  if (item.getChildren().length > 0) {
	  		  ArrayList subScopeFacilityId = new ArrayList();
	  		  ArrayList subScopeFacilityName = new ArrayList();
	
	  		  for (int i = 0; i < childrenList.length; i++) {
	  			  subScopeFacilityId.add(childrenList[i].getData().getFacilityId());
	  			  subScopeFacilityName.add(childrenList[i].getData().getFacilityName());
	  		  }
	  		  collectorInfo.setSubScopeFacilityId(subScopeFacilityId);
	  		  collectorInfo.setSubScopeFacilityName(subScopeFacilityName);
	  	  }
	  	  this.update();
	    }
    }
    
    
//	/**
//	 * ǥդɽޤ******ʤǤϻȤƤʤĳ
//	 */
//	public void drawGraph(GraphProperty[] property) {
//		
//		// դ¤٤sash(+ץ٥)
//		graphCompositeR.redrawGraph(property);
//	}

    /**
     * . ꥹȤǼܤꤷƥܥ򲡲Ȥ˸ƤФ롣 
     */
    public void initialize(CollectorProperty property) {
    	
		// ɽƤ륰դȥפΥѥõɽĤʤ褦ˤ.
  	    if (graphComposite != null) {
			graphComposite.dispose();	// դξõ
			this.getPathLabel().setText(Messages.getString("SCOPE") + " : ");	// פν
			this.getBaseComposite().layout(true, true);
			collectorInfo.setFacilityId(null);
    	    }
    	
        this.collectorProperty = property;
        
    	// ˽סtreeʤѤĤġĥ꡼񤭤뤳ȤˤꥫޥƤ롣 
        this.item =  collectorProperty.getCollectorData().getFacilityTree();
        this.getScopeTreeComposite().setScopeTree(collectorProperty.getCollectorData()
                .getFacilityTree());
        
        int interval = property.getCollectorData().getInterval();
        
        // ӥդǤϡǥɽֳ֤ꤵΤǡ
        // intervalͤ򥻥åȤ롣
        collectorInfo.setInterval(interval);
        
        collectorInfo.setCollectStartTime(collectorProperty.getCollectorData().getStartDate());
        collectorInfo.setCollectEndTime(collectorProperty.getCollectorData().getStopDate());
        
        // ɽϰϤʤɤꤻɽդΤ߻ꤷƼ¹Ԥ⤢Τǡͤ򥻥åȤɬפ.
        collectorInfo.setGraphStartTime(collectorProperty.getCollectorData().getStartDate());
        
        long startTime = collectorProperty.getCollectorData().getStartDate().getTime();
        
		// GraphConstant.REALTIME_GRAPH_MAX_PLOT ɽץåȿ
		collectorInfo.setGraphEndTime(new Date(startTime + interval * 1000 * (GraphConstant.REALTIME_GRAPH_MAX_PLOT + 1)));
        	collectorInfo.setGraphPlotNum(0);

        List itemList = collectorProperty.getItemList();
        
        collectorItemInfo.createItemInfoForCollector(itemList.size());
        for (int i = 0; i < itemList.size(); i++) {
        	CollectorItemInfo info = (CollectorItemInfo)itemList.get(i);
        	// .
        	collectorItemInfo.setItemInfoForCollector(
        			i,
        			info.getCollectorItemCode(),
        			String.valueOf(info.getDeviceIndex()),
        			String.valueOf(info.getCollectorItemID()),
        			info.getDeviceName(),
        			true);  // true
        }
        // ܺٹܤ̵ͭΥǡȽꤷƥåȤ.
        for (int i = 0; i < itemList.size(); i++) {
        	List factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(
        			collectorItemInfo.getItemCodeForCollector(i));
        	String deviceIndex = collectorItemInfo.getIndexForCollector(i);
        	
        	boolean a = true;
        	
        	if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) { // ҹܤ¸ߤʤܤξ.deviceindex=0
        		a = false;
        	} else {
        		// ʣǥХξؤб 
        		loop1: for (int m = 0; m < factorySubItemCodeList.size() ; m++) {
        			boolean c = false;  // ̵ͭΥե饰.
        			loop2: for (int n = 0; n < collectorItemInfo.getItemNumForCollector(); n++) { // itemCodeʬå.
        				if (collectorItemInfo.getItemCodeForCollector(n).equals(factorySubItemCodeList.get(m).toString())) {
        					if (String.valueOf(deviceIndex).equals(collectorItemInfo.getIndexForCollector(n))) {
        						c = true; // ɬ׹ܤĤä.
        						break loop2;
        					}
        				}
        			}
        			if (! c) {
        				a = false; // ɬ׹ܤĤʤä.
        				break loop1;
        			}
        		}
        	}
        	if (! a) { // ܺɽǽǤʤ.
        		collectorItemInfo.isItemDetailedForCollector(i, false);
        	} else {
        		// ͤtrueˤƤΤǲ⤷ʤ.
        	}
        } // for
        
        if (itemList != null && itemList.size() > 0) {
        	// ѤƬΥ쥳ɤ򥻥åȤ
        	CollectorItemInfo info = (CollectorItemInfo)itemList.get(0);
        	// ͤϿ롣ͤƬ쥳ɤȤ롣
        	// ѼԤϿƤѹɽƤ롣
        	for (int i = 0; i < 4; i++) {
        		collectorItemInfo.setItemInfo(
        				i,
        				info.getCollectorItemCode(),
        				"NonDisplay",	// ֤ɽ.ɽͰʳϾˤɽʤ礬ΤŬ.ɽͤˤʤ.
        				String.valueOf(info.getDeviceIndex()),
        				"0", // ƬΥ쥳ɤʤΤ0.
        				info.getDeviceName(),
        				true);	// for test.
        	} // for
        } // if
    }
    
    public void dispose() {  	
    	// å
    	RecordController.getInstance().unlock();
    	
    	// å
    	RecordController.deleteInstance();
    	super.dispose();
    }
    
    /**
     * @return collectorProperty ᤷޤ
     */
    public CollectorProperty getCollectorProperty() {
    	return this.collectorProperty;
    }
    
    /**
     * @return graphComposite ᤷޤ
     */
    public GraphProperty[] getGraphProperty() {
    	return graphCompositeR.getGraphPropertys();
    }
    
    
    protected Composite createListContents(Composite parent) {
    	//graphCompositenew뤿ݻ롣
    	this.parent = parent;
    	
    	GridLayout layout = new GridLayout(1, true);
    	this.parent.setLayout(layout);
    	layout.marginHeight = 0;
    	layout.marginWidth = 0;			
    	
		if(this.loadCollectorPropertey()) {	// ץե󥹾Ȥǧ	
			this.initialize(this.collectorProperty);	// CollectorInfo,CollectorItemInfoͤ  
			this.getPreference();   // ץե󥹤¸ƤǡCollectorInfo,CollectorItemInfo˳Ǽ롣
		}
		
    	this.update();
    	
    	//ɽդɽ٤
    	//   ɽ򤬤ƤʤȤ
    	//   뤿ᡢΥդɽʤ
    	return this.graphComposite;
    }
    
    
    public void update() {
    	// Ϣ³б
    	try {
    		Thread.sleep(10);
    	} catch (InterruptedException e1) {
    		// TODO ư줿 catch ֥å
    		e1.printStackTrace();
    	}
    	
    	//ɽ
    	//   ɽξϥ򤷤Ƥⲿɽʤ
    	//   (ɽ̤Ǥ뤳Ȥ狼䤹)
    	int interval = collectorInfo.getInterval();
    	int graphPlotNum = collectorInfo.getGraphPlotNum();
    	// ޥ͡ؤΥǡ׵򤹤뤫ݤȽ롣
    	isRequestCollectorToRun = false;
    	
    	// intervalϽ֤ΤߥȤʤ롣
    	if (interval != 0 && (collectorInfo.getFacilityId() != null)) {
    		boolean isXRangeAuto = false;
    		if (collectorInfo.getGraphPlotNum() == 0) {
    			isXRangeAuto = true;
    		}
    		
    		if (graphComposite != null) {
    			graphComposite.dispose();
    		}
    		
    		graphComposite = new RealtimeGraphComposite(this.parent, SWT.NONE);
    		graphComposite.setCollectorInfo(collectorInfo);
    		graphComposite.setCollectorItemInfo(collectorItemInfo);
    		
    		GridData baseGridData = new GridData();
    		baseGridData.horizontalAlignment = GridData.FILL;
    		baseGridData.verticalAlignment = GridData.FILL;
    		baseGridData.grabExcessHorizontalSpace = true;
    		baseGridData.grabExcessVerticalSpace = true;
    		graphComposite.setLayoutData(baseGridData);
    		
    		GridLayout baseLayout = new GridLayout(1, true);
    		graphComposite.setLayout(baseLayout);
    		baseLayout.marginHeight = 0;
    		baseLayout.marginWidth = 0;	
    		
    		/*
    		 * 餬ν
    		 */
    		int graphNum = collectorInfo.getGraphNum();
    		String facilityId = collectorInfo.getFacilityId();
    		
    		for (int i = 0; i < graphNum; i++) {
    			String itemCode =  collectorItemInfo.getItemCode(i);
    			String deviceName = collectorItemInfo.getDeviceNameForCollector(Integer.valueOf(collectorItemInfo.getItemId(i)));
    			String displayType =  collectorItemInfo.getDisplayType(i);
    			String deviceIndex = collectorItemInfo.getDeviceIndex(i);
    			
    			graphComposite.addGraph(
    					i,
    					itemCode,
    					deviceName,
    					collectorInfo.getSubScopeNum(),
    					displayType, interval, isXRangeAuto, graphPlotNum);	// isXRangeAutoϤȤꤢtrueλͤȤ.
    			
    			collectorItemInfo.setIsCollect(i, graphComposite.isCollect());
    			
    			if (graphComposite.isCollect()) {
    				setCollector(itemCode, deviceIndex, displayType, interval, facilityId);
    			}
    		}
    		
    		// ϡʲ2ĤΥåФƤ롣
    		//   (1) ǤΥɽ̵ͭȽꡣ 
    		//   (2) ֥ɽǥΡɤ򤷤Υɽ̵ͭȽꡣ
    		if (! isRequestCollectorToRun) {
    			try {
    			} catch (Exception e) {
    				// ޤ򳫻ϤƤʤϤΤޤ޽˿ʤ롣
    			}
    		}
    		//ScopeListBaseViewΥѥåŬѤ뤳Ȥˤ褻ΥåĤ
    		// ޤ褵ʤΤǡSashѹǱн衣
    		SashForm treeSash =this.getTreeSash();
    		treeSash.setWeights(new int[] { 29, 71 });
    		treeSash.setWeights(new int[] { 30, 70 });
			
			// ץե󥹤RealtimeCollectorItemInfoξǼ롣
			this.setPreference();
    	}
    	
    }
    
    private void setCollector(String itemCode,String deviceIndex, String displayType, int interval, String facilityId) {
    	// collectorIdλ
    	String collectorId = collectorProperty.getCollectorData().getCollectorID();
    	// facilityλ
    	String[] facilityIdList;
    	
    	if (collectorInfo.getSubScopeNum() > 0 && displayType.equals("SubScope")) {     
    		facilityIdList = new String[collectorInfo.getSubScopeNum()];
    		
    		for (int i = 0 ; i < collectorInfo.getSubScopeNum(); i++) {
    			facilityIdList[i] = collectorInfo.getSubScopeFacilityId(i);
    		} 
    	} else {
    		facilityIdList = new String[1];
    		facilityIdList[0] = facilityId;
    	}
    	
    	List itemList = collectorProperty.getItemList();
		
    	Date startDate = collectorInfo.getGraphStartTime();
    	Date endDate = collectorInfo.getGraphEndTime();
	
		// ưɽ̵¼б(ꤵƤս꤬ڤͤ줿)
		Date nowDate = new Date();		
		if (collectorInfo.getGraphStartTime().before(collectorInfo.getCollectStartTime())) { // ɽ  ϻ
			startDate = collectorInfo.getCollectStartTime();
			endDate = new Date(startDate.getTime() + collectorInfo.getInterval() * 1000 * GraphConstant.REALTIME_GRAPH_MAX_PLOT);  
			if (endDate.after(nowDate)) { // ɽλ郎߻򤹤Ƥ
				endDate = nowDate;
			} 
		}
			
    	// itemCodedeviceIndex꤬ˤitemIdΥꥹȤ.
    	List ItemCodeCheckList = null;
    	
    	if (displayType.equals("Detail")) {
    		// factoryˤޤǹ碌롣(ɽ)
    		ItemCodeCheckList = CollectorItemCodeFactory.getSubItemCode(itemCode);
    	} else {
    		ItemCodeCheckList = new ArrayList();
    		ItemCodeCheckList.add(itemCode); // ɽͤȥ֥ɽͤǤϡ̤itemCodeϤʤ.
    	}
    	
    	// itemIdǼѰդ.
    	int[] collectorItemIdList = new int[ItemCodeCheckList.size()];	// Ȥ븽ԻͤľϤȤǸƤ
    	// ID᤿ܿ(itemCodedeviceIndex̣.
    	int collectorItemNum = collectorItemInfo.getItemNumForCollector();
    	
    	// itemCodeȤ˥å.
    	loop1: for (int m = 0; m < ItemCodeCheckList.size() ; m++) {
    		boolean found = false;  // ̵ͭΥե饰.
    		// itemCodedeviceIndex򥭡ˤȤitemId.
    		loop2: for (int n = 0; n < collectorItemNum; n++) { // itemCodeʬå.
    			// ޤitemCode٥ǥå.
    			if (collectorItemInfo.getItemCodeForCollector(n).equals(ItemCodeCheckList.get(m).toString())) {
    				// itemCodeפ鼡deviceIndexå.
    				if (deviceIndex.equals(collectorItemInfo.getIndexForCollector(n))) {
    					collectorItemIdList[m] = n;
    					found = true;
    					break loop2;	// ɬ׹ܤĤä.
    				}
    			}
    		}
    		if (! found) {
    			break loop1;
    		}
    	}
    	
    	// 1ĤΥդΤɬץǡ򥻥åȤƤ.
    	// collectorItemIdList
    	//        ܺɽξϡʣˤʤ롣ʳϤҤȤĤǤ롣deviceIndex
    	//        ɬפΤ.ñitemCodeߤƬǥХɽƤޤ.
    	this.drawGraph1Test(collectorId, collectorItemIdList, facilityIdList, startDate, endDate, displayType);
    	
    	isRequestCollectorToRun = true;
    }
    
    // åɤư򤵤Ƥʤ.
    public synchronized void drawGraph1Test(
    		String collectorId,
    		int[] collectorItemIdList,
    		String[] facilityIdList,
    		Date startDate,
    		Date endDate,
    		String displayType) {
    	
    	// ޥ͡㤫ǡ
    	RecordController controller = RecordController.getInstance();
    	// ޥ͡Ȥ³˼Ԥϥ顼ɽ
    	if (controller == null) {
    		return;
    	}
    	
    	// ն
    	CollectedDataSet dataSet = controller.getRecordCollectedData(
    			collectorId, facilityIdList, collectorItemIdList, startDate, endDate);
    	
    	// ǽǡμ˼Ԥϥ顼ɽ
    	if (dataSet == null) {
    		return;
    	}
    	
    	
    	// ǺǡϤޤ1ĤΥѤΤΡƬ𤵤ƤϤʤ
    	
    	int counter = 0;
    	
    	if (displayType.equals("SelectedScope")) {
    		// facilityϤҤȤġҤȤġ
    		// partialΤ߼֥פˤϻȤʤΤ
    		counter = 1;
    	} else if (displayType.equals("SubScope")) {
    		counter = collectorInfo.getSubScopeNum();
    	} else {
    		counter = collectorItemIdList.length;
    	}
    	
    	
    	int graphDotNum = 0;
    	
    	if (displayType.equals("SelectedScope") || displayType.equals("Detail")) {
    		for(int i=0; i < counter; i++){
    			List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[0], collectorItemIdList[i]);
    		}
    	} else {
    		for(int i=0; i < counter; i++){
    			List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[i], collectorItemIdList[0]);
    		}
    	}
    	
    	List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[0], collectorItemIdList[0]);
    	graphDotNum = dataListForCheck.size();
    	
        // 1ܤĴƤΤǡݻƤޥ͡¦λͤθľɬפȤ롣
    	double[] sumOfDataInfoValueSum = new double[graphDotNum]; // = 0.0D;
    	
    	for(int i=counter-1; 0 <= i ; i--){
    		List dataList= null;
    		
    		// ܺɽǤͤ­ƤΤ
    		if (displayType.equals("Detail")) {
    			dataList = dataSet.getCollectedDataList(facilityIdList[0], collectorItemIdList[i]);
    		} else {
    			dataList = dataSet.getCollectedDataList(facilityIdList[i], collectorItemIdList[0]);
    		}
    		
    		if (dataList.size() != 0) { // ΥɽǤϥޥ͡㤫ͤǤƤʤ⤢뤿
    			double dataInfoValue = 0.0D;
    			for(int j=0; j < dataList.size(); j++){
    				CollectedDataInfo dataInfo = (CollectedDataInfo) dataList.get(j);
    				
    				if (!Double.isNaN(dataInfo.getValue())) {
    					if (dataInfo.getValue() >= 0.0) {
    						
    						if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
    							dataInfoValue = dataInfo.getValue(); 
    						} else if (displayType.equals("Detail")) {
    							// ͤѤߤ롣
    							sumOfDataInfoValueSum[j] = sumOfDataInfoValueSum[j] + dataInfo.getValue();
    							dataInfoValue = sumOfDataInfoValueSum[j]; 
    						}
    						if (!Double.isNaN(dataInfoValue)) {
    							graphComposite.m_timeseries[i].addOrUpdate(new Second(dataInfo.getDate()),dataInfoValue);
    						}
    					}
    				}
    			} // for
    		} else {
    		} // else
    	} // for
    } // if
	
	
	/**
	 * IDץե󥹤collectorProperty᥽å
	 * @return boolean
	 */
	private boolean loadCollectorPropertey() {
		String collectorID = perfPrePage.getCollectorId();
		
		if(!"".equals(collectorID)){ // ץե󥹥ڡcollectorIDξ¸ߤ
			collectorProperty = RecordController.getInstance().getCollectorProperty(collectorID);
			if(collectorProperty != null) // Ӽ˥ǡ¸ߤ
				return true;
		}
		return false;
	}
	
	/**
	 * ץե󥹤ǼƤ᥽å
	 *
	 */
	private void getPreference(){    	
		
		collectorInfo = perfPrePage.getRealtimeCollectorInfo(this.collectorInfo);
		collectorItemInfo = perfPrePage.getRealtimeCollectorItemInfo(this.collectorItemInfo);
		
		Label pathLabel = this.getPathLabel();
		pathLabel.setText(Messages.getString("SCOPE") + " : " + perfPrePage.getPathLabel()+" \n"
				+Messages.getString("COLLECTION_ID") + " : " + perfPrePage.getCollectorId());
	}
	
	/**
	 * ץե󥹤˾򥻥åȤ᥽å
	 *
	 */
	private void setPreference() {
		perfPrePage.setCollectorId(this.collectorProperty.getCollectorData().getCollectorID());
		
		String pathLabelSplit[] = this.getPathLabel().getText().split(" "); // פΥѥ
		perfPrePage.setPathLabel(pathLabelSplit[2]);
		perfPrePage.setRealtimeCollectorInfo(this.collectorInfo);
		perfPrePage.setRealtimeCollectorItemInfo(this.collectorItemInfo);
		
		perfPrePage.savePreference();	// ץե󥹥ڡΥǡ¸
		
	}
	
}