/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.RealtimeCollectThread;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.view.ScopeListBaseView;
import com.sun.corba.se.spi.orb.DataCollector;


/**
 * ꥢ륿॰ɽԤView饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeGraphView extends ScopeListBaseView {
		
    public static final String ID = "com.clustercontrol.performance.view.RealtimeGraphView";

    private Composite parent;

    // ѹʤɤǽȤ뤿publicˤ.()
    public RealtimeGraphComposite graphComposite = null;
    
    //ɽδܾ(ɽֳ֤ʤ)ݻΰݤ롣
    public RealtimeCollectorInfo collectorInfo;
    
    public RealtimeCollectorItemInfo collectorItemInfo;
    
    // staticǤʤСͳߤ뤳ȤǤʤ
    static boolean isRequestCollectorToRun = false;
    
    public static RealtimeCollectThread collector = null;
    
    private boolean check = true;
    
    /**
     *  
     */
    public RealtimeGraphView() {
        super();
        initialize();
    }

    private void initialize() {
        //ɽδܾ(ɽֳ֤ʤ)ݻΰݤ롣
        collectorInfo = new RealtimeCollectorInfo();
        //ɽɽǡܾ(ɽֳ֤ʤ)ݻΰݤ롣
        collectorItemInfo = new RealtimeCollectorItemInfo();
        // ͤȤƸ߻򥻥åȤƤ(μ)
        
        // ͤ0(auto)ǤΤǥꥢ륿॰Ѥͤ򥻥å.
        // 12ʤ5ôֳ֤1ʬʬɽ뤳Ȥ.(ȯλͤ˽स)
        collectorInfo.setGraphPlotNum(12);

        //ͤΥå
            //ɽǥդɽˤʤ顢̤Ǥν֤
            //ɽȤ٤
        
        	// ưŪ˹ܤꤹˤϡбʤ.
        	// ־itemIdNULLΤȤϽ֤ȽꤷͤåȤƤȤ꤬Ƚꤹ.
        	collectorItemInfo.setItemInfo(0,"00000000","NonDisplay","0","0",null,true);	// CPU(CODE_CPU_UTILIZATION)
        	collectorItemInfo.setItemInfo(1,"00000000","NonDisplay","0","0",null,true);	// CPU(CODE_CPU_UTILIZATION)
        	collectorItemInfo.setItemInfo(2,"00000000","NonDisplay","0","0",null,true);	// CPU(CODE_CPU_UTILIZATION)
        	collectorItemInfo.setItemInfo(3,"00000000","NonDisplay","0","0",null,true);	// CPU(CODE_CPU_UTILIZATION)
        	
        	String itemCodeList[] = CollectorItemCodeFactory.getCodeAll();
        	int itemCodeNum = 0;
        	
        	for(int i=0; i < itemCodeList.length; i++){
        		// ǽ餫ǥХ̤ǤʤitemCodeοʬд򤷤Τ.
        		if (! CollectorItemCodeFactory.isDeviceSupport(itemCodeList[i])) {
        			itemCodeNum = itemCodeNum + 1;
        		}
        	}

        	int j = 0;
        	collectorItemInfo.createItemInfoForCollector(itemCodeNum);
        	for(int i=0; i < itemCodeList.length; i++){
        		// ǽ餫ǥХ̤ǤʤitemCodeοʬд򤷤Τ.
        		if (! CollectorItemCodeFactory.isDeviceSupport(itemCodeList[i])) {
        			boolean isDetailed = true;
        			List factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(itemCodeList[i]);
        			if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) { // ҹܤ¸ߤʤܤξ.deviceindex=0
        				isDetailed = false;
		        	}
        			// ͤϥߡ : index=0, itemId=0, deviceName=dummy.
        			collectorItemInfo.setItemInfoForCollector(j, itemCodeList[i], "0", "0", null, isDetailed);
        			j = j + 1;
        		}
        	} // for
    }

    /**
   * extendScopeListBaseViewؤѹˤɲ(ư)
   * ĥ꡼ڥǥפ򤹤ȸƤӽФ롣
   *
   * @param parent
    *            ץĥ꡼ƥ
    */
	// ӥ塼ưˤ⤳¹Ԥ롣ץĥ꡼ɽƤ뤿ᡣ    
	protected Composite createListContents(Composite parent) {
		//graphCompositenew뤿ݻ롣
		this.parent = parent;

	    GridLayout layout = new GridLayout(1, true);
	    this.parent.setLayout(layout);
	    layout.marginHeight = 0;
	    layout.marginWidth = 0;			

	    this.update();
	    
	    //ɽդɽ٤
        //   ɽ򤬤ƤʤȤ
        //   뤿ᡢΥդɽʤ
        	return this.graphComposite;
	}

      /**
       * 򤵤줿(Ρ)ξɽޤ
       * 
       * @param item
       *            ץĥ꡼ƥ
       */
      protected void doSelectTreeItem(FacilityTreeItem item) {
    	  
    	  if (item.getData().getFacilityId() == null ||
    			  "".equals(item.getData().getFacilityId())){
    		  // ⤷ʤ(å)
    	  } else if (collectorInfo.getFacilityId() != null &&  
    			  collectorInfo.getFacilityId().equals(item.getData().getFacilityId())) {
    		  // ⤷ʤ(ϢǤؤн)
    	  } else {
	    	  //򤵤줿׾򥰥մܾ˽񤭹ࡣ
	    	  collectorInfo.setFacilityId(item.getData().getFacilityId());
			  collectorInfo.setSubScopeNum(item.getChildren().length);
	    	  
			  List itemList = CollectorItemCodeFactory.getAvailableCollectorItemList(item.getData().getFacilityId());
			  
			  if (itemList != null) {

				  // ɽΥꥹȤκ.
				  // פڤؤȺƺ.ĤޤꡢdeviceIndexɽݻʤ.
				  collectorItemInfo.createItemInfoForCollector(itemList.size());

				  for (int i = 0; i < itemList.size(); i++) {
					  CollectorItemInfo itemInfo = (CollectorItemInfo) itemList.get(i);

					  // ׾ܺɽǽǤ뤫ݤå.
	        			boolean isDetailed = true;
	        			List factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(itemInfo.getCollectorItemCode());
	        			if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) { // ҹܤ¸ߤʤܤξ.
	        				isDetailed = false;
			        	}
					  
					  collectorItemInfo.setItemInfoForCollector(
							  i,
							  itemInfo.getCollectorItemCode(),
							  Integer.toString(itemInfo.getDeviceIndex()),
							  Integer.toString(itemInfo.getCollectorItemID()),
							  itemInfo.getDeviceName(),
							  isDetailed);
				  }
			  }
			  
			  // ɽܤλѹ(˻ꤵ줿deviceIndex(itemId)¸ߤʤؤн)
			  loop1:for (int i = 0; i < collectorInfo.getGraphNum(); i++) {
				  if (collectorItemInfo.getDeviceName(i) != null) {
					  boolean found = false;
					  loop2:for (int j = 0; j < collectorItemInfo.getItemNumForCollector(); j++) {
						  if (collectorItemInfo.getItemCode(i).equals(collectorItemInfo.getItemCodeForCollector(j)) &&
								  collectorItemInfo.getDeviceName(i).equals(collectorItemInfo.getDeviceNameForCollector(j))) {
							  collectorItemInfo.setItemId(i, Integer.toString(j));
							  found = true;
							  if (! collectorItemInfo.hasDevice(i)) {
								  collectorItemInfo.setHasDevice(i, true);
								  collectorItemInfo.setItemId(i,Integer.toString(j)); // оΤitemId򥻥åȤ.
							  }
							  break loop2;
						  }
					  } // loop2
					  if (! found) {
						  collectorItemInfo.setHasDevice(i, false);
					  }
					  
				  }
			  } // loop1
			  
	    	  //򤵤줿פΥ֥׾򥰥մܾ˽񤭹ࡣ
			  //ǡľܥǤꥹȤǤǤʤΤǰöݻ롣
	    	  FacilityTreeItem[] childrenList = item.getChildren();
	    	  
		  	  // եƥID¤ؤ
	    	  Arrays.sort(childrenList, new Comparator(){
	    		  public int compare(Object o1, Object o2) {
	    			  if (o1 instanceof FacilityTreeItem && o2 instanceof FacilityTreeItem) {
	    				  String object1 = ((FacilityTreeItem) o1).getData().getFacilityId();
	    				  String object2 = ((FacilityTreeItem) o2).getData().getFacilityId();
	    				  
	    				  return object1.compareTo(object2);
	    			  }
	    			  return 0;
	    		  }
	    	  });
	   		  
	    	  if (item.getChildren().length > 0) {
	    		  ArrayList subScopeFacilityId = new ArrayList();
	    		  ArrayList subScopeFacilityName = new ArrayList();
	
	    		  for (int i = 0; i < childrenList.length; i++) {
	    			  subScopeFacilityId.add(childrenList[i].getData().getFacilityId());
	    			  subScopeFacilityName.add(childrenList[i].getData().getFacilityName());
	    		  }
	    		  collectorInfo.setSubScopeFacilityId(subScopeFacilityId);
	    		  collectorInfo.setSubScopeFacilityName(subScopeFacilityName);
	    	  }
	    	  this.update();
    	  }
      }
           
      // ľ󲽤뤳ȤˤꡢϢкȤ.ϢкʤɤθƤǹԤʤ.
      // ThreadǸƤФʤsyncronizedΰ̣ʤ.
      public synchronized void update() {
        	  Date timestamp = new Date(System.currentTimeMillis());
        	  // timestampͤ򥻥åȤ顢(-1=NG,0=initial,0<=Ϣ)ֵѤ롣
        	  int timestampId = collectorInfo.setCurrentCollect(timestamp);
        	  prepareToUpdate(timestamp, timestampId);
      }


      
      private void prepareToUpdate(Date timestamp,int timestampId) {
    	  // ǰΤå.
    	  if (collectorInfo.isCurrentCollect(timestamp, timestampId)) {
        	  graphUpdate(timestamp,timestampId);
    	  }
      }
      
      private void graphUpdate(Date timestamp, int timestampId) {
      	  //ɽ
      	  //   ɽξϥ򤷤Ƥⲿɽʤ
      	  //   (ɽ̤Ǥ뤳Ȥ狼䤹)
      	  int interval = collectorInfo.getInterval();
			// ޥ͡ؤΥǡ׵򤹤뤫ݤȽ롣
			isRequestCollectorToRun = false;
      	  
      	  // intervalϽ֤ΤߥȤʤ롣
      	  if (interval != 0 && (collectorInfo.getFacilityId() != null)) {

      		  boolean isXRangeAuto = false;
      		  if (collectorInfo.getGraphPlotNum() == 0) {
      			isXRangeAuto = true;
      		  }
      		  
              // դ줾copmositeä(nullpointer顼Ȥʤ)ΤǤϤʤbaseCompositeä
      		  // ξ硢baseGridDataʤͤФʤʤparentlayoutϺƥåס
      		  // λͲǤϡbaseComposite򤽤Τޤޤǳƥդƺ褦ʻͤѹ.
      	    if (graphComposite != null) {
      		  graphComposite.dispose();
      	    }
        	    	
    	        graphComposite = new RealtimeGraphComposite(this.parent, SWT.NONE);
    	        graphComposite.setCollectorInfo(collectorInfo);
    	        graphComposite.setCollectorItemInfo(collectorItemInfo);
    	        
    	        GridData baseGridData = new GridData();
    	        baseGridData.horizontalAlignment = GridData.FILL;
    	        baseGridData.verticalAlignment = GridData.FILL;
    	        baseGridData.grabExcessHorizontalSpace = true;
    	        baseGridData.grabExcessVerticalSpace = true;
    	        graphComposite.setLayoutData(baseGridData);
    	        
  			    GridLayout baseLayout = new GridLayout(1, true);
  			    graphComposite.setLayout(baseLayout);
  			    baseLayout.marginHeight = 0;
  			    baseLayout.marginWidth = 0;	

  			    /*
  			     * 餬ν
  			     */
  			    int graphNum = collectorInfo.getGraphNum();
  			    String facilityId = collectorInfo.getFacilityId();
  			    
  			    for (int i = 0; i < graphNum; i++) {
  	            	String itemCode =  collectorItemInfo.getItemCode(i);
  	            	String itemId = collectorItemInfo.getItemId(i);
  	            	String deviceName = collectorItemInfo.getDeviceName(i); //  .getDeviceNameForCollector(Integer.valueOf(collectorItemInfo.getItemId(i)));
  	             	String displayType =  collectorItemInfo.getDisplayType(i);
  	             	int graphPlotNum = collectorInfo.getGraphPlotNum();
  	             	int deviceIndex = Integer.valueOf(collectorItemInfo.getDeviceIndex(i));
  	             	
  	            	graphComposite.addGraph(
  	            			i, //graphId,
  	            			itemCode,
  	            			deviceName,
  	            			collectorInfo.getSubScopeNum(),
  	            			displayType, interval, isXRangeAuto, graphPlotNum); // isXRangeAutoϤȤꤢfalseλͤȤ.

	            		collectorItemInfo.setIsCollect(i, graphComposite.isCollect());

	            		if (graphComposite.isCollect()) {
  	  	              	setCollector(timestamp, timestampId, itemCode, itemId, deviceIndex, displayType, interval, facilityId);
  	            	}
  			    }
  			    
				// ϡʲ2ĤΥåФƤ롣
				//   (1) ǤΥɽ̵ͭȽꡣ 
				//   (2) ֥ɽǥΡɤ򤷤Υɽ̵ͭȽꡣ
				if (! isRequestCollectorToRun) {
					try {
						// å
					} catch (Exception e) {
						// ޤ򳫻ϤƤʤϤΤޤ޽˿ʤ롣
					}
				}
  			    
              	//ScopeListBaseViewΥѥåŬѤ뤳Ȥˤ褻ΥåĤ
              	// ޤ褵ʤΤǡSashѹǱн衣
              	SashForm treeSash =this.getTreeSash();
              	treeSash.setWeights(new int[] { 29, 71 });
              	treeSash.setWeights(new int[] { 30, 70 });
      	  }
	}
              	

      
      private void setCollector(Date timestamp, int collectTimestampId, String itemCode, String itemId, int deviceIndex, String displayType, int interval, String facilityId) {
			int requestInterval = collectorInfo.getRequestInterval();
			
			if (graphComposite.m_timeseries == null) {
			}
			// Thread󥹥󥹤(Threadμ¹ԤϤޤ)
		    collector = new RealtimeCollectThread(
		    		timestamp,
		    		collectTimestampId,
		    		graphComposite.m_timeseries,
		    		itemCode,
		    		itemId,
		    		deviceIndex,
		    		displayType,
		    		interval,
		    		requestInterval,
		    		facilityId,
		    		check,
		    		graphComposite); // ѹоݤ뤿.
		    
	        collector.setCollectorInfo(collectorInfo);
	        // ThreadưΥ᥽å.ºݤˤϥХ饤ɤ줿run()¹Ԥ.
	        collector.start();
	        
	        // Thread򤷤Ƥʤ顢ߤľܴǤ(notify,etc).
	        // ξwait set˰öɬפΤǤޤطʤ??
	        // ॹ׾collectorInfoǴstaticˤʤƤThread黲ȤǤ.
      }
      
      
    public void dispose() {
        // å
    	// ⥰ɽΤޤ޲̤Ĥ䡢ɽǤʤäΥϥɥ󥰤ɬס
		try {
			// å
			//			clientRealTimeController.setRunning(false);
			// ˼νߤ褦˥ॹפ򹹿롣
			//			RealtimeController.setCollectTimestamp();
		} catch (Exception e) {
			// ޤ򳫻ϤƤʤϤΤޤ޽˿ʤ롣
		}

        super.dispose();
    }
}