/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;

/**
 * ܥɤξեȥꥯ饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCodeFactory {
    private static HashMap<String, CollectorItemTreeItem> m_codeTable = null; // ܥɤ


    private CollectorItemCodeFactory() {
    }

    public static void init() {
    	m_codeTable = RecordController.getInstance().getItemCodeTreeMap();
    }

    /**
     * ܥɤι֤̾ޤ
     * 
     * @param itemCode
     * @return ܥɤι̾
     */
    public static String getItemName(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        return m_codeTable.get(itemCode).getItemName();
    }
    
    /**
     * ܥɤι̾ǥХ̾ޤ֤ޤ
     * 
     * @param itemCode ܥ
     * @param deviceName ǥХ
     * @return ܥɤι̾
     */
    public static String getFullItemName(String itemCode, String deviceName) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        String name;
        if (deviceName == null || deviceName.equals(Messages.getString("NONE"))) {
            name = m_codeTable.get(itemCode).getItemName();
        } else {
            name = m_codeTable.get(itemCode).getItemName()
                    + "(" + deviceName + ")";
        }

        return name;
    }
    
    /**
     * ܥɤι̾ǥХ̾ޤ֤ޤ
     * 
     * @param collectorItemInfo ܾ
     * @return ܥɤι̾
     */
    public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
    	if(m_codeTable == null){
    		init();
    	}
    	
    	String itemCode = collectorItemInfo.getCollectorItemCode();
    	
    	// ǥХ̤μԤܤݤǽϤѹ
    	if(CollectorItemCodeFactory.isDeviceSupport(itemCode)){
    		// ǥХ̾ޤ᤿֤̾
    		return getFullItemName(
    				collectorItemInfo.getCollectorItemCode(), 
    				collectorItemInfo.getDeviceName()
    		);
    	} else {   	
    		return getItemName(itemCode);
    	}
    }

    /**
     * ܥɤǽͤñ̤֤ޤ
     * 
     * @return ǽͤñ
     */
    public static String getMeasure(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        return m_codeTable.get(itemCode).getMeasure();
    }

    /**
     * ǽͤͤɴʬΨݤ֤ޤ
     * 
     * @return true ɴʬΨ false ɴʬΨǤϤʤ
     */
    public static boolean isRangeFixed(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        return m_codeTable.get(itemCode).isRangeFixed();
    }

    /**
     * ǥХ̤ǽͤݤ֤ޤ
     * 
     * @return true ǥХ̤ǽ͡false ǥХ̤ǽͤǤϤʤ
     */
    public static boolean isDeviceSupport(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        return m_codeTable.get(itemCode).isDeviceFlag();
    }

    /**
     * ܥɤΥƥ֤̾ޤ
     * 
     * @return ƥ̾
     */
    public static String getCategoryName(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        return m_codeTable.get(itemCode).getCategory().getCategoryName();
    }

    /**
     * ܥɤΥƥꥳɤ֤ޤ
     * 
     * @return ƥꥳ
     */
    public static String getCategoryCode(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
    	
        return m_codeTable.get(itemCode).getCategory().getCategoryCode();
    }

	/**
	 * ƤΥɤ֤ޤ
	 * 
	 * @return ƤΥ
	 */
	public static String[] getCodeAll() {
    	if(m_codeTable == null){
    		init();
    	}
		
		TreeSet<String> set = new TreeSet<String>(m_codeTable.keySet());
		return (String[])set.toArray(new String[set.size()]);
	}
	
	/**
	 * ꥳɤդɽΤɬפʹܤΥɤꥹȤ֤
	 * 
	 * @param itemCode
	 * @return ܥɤΥꥹ
	 */
	public static List getSubItemCode(String itemCode) {
    	if(m_codeTable == null){
    		init();
    	}
		
		ArrayList<String> itemCodeList = new ArrayList<String>();
		
		// μɤбܥĥ꡼Ǥ
		CollectorItemTreeItem treeItem = m_codeTable.get(itemCode);
		
		// ҹܤ
		Iterator itr = treeItem.getChildrens().iterator();
		
		while (itr.hasNext()) {
			String subItemCode = ((CollectorItemTreeItem) itr.next()).getItemCode();
			itemCodeList.add(subItemCode);
		}
		
		return itemCodeList;
	}

	/**
	 * μ椫ɽԤΤɬפʼܤƴޤޤƤ뤫ɤåޤ
	 */
	public static boolean checkItemList(CollectorItemInfo target, List itemList) {
    	if(m_codeTable == null){
    		init();
    	}
		
		// ɽɬפʼܥɤ
		List itemCodeList = getSubItemCode(target.getCollectorItemCode());
		
		if (itemCodeList == null || itemCodeList.size() == 0) { // ҹܤ¸ߤʤܤξ
			return false;
		} else if (selectItemInfo(target, itemList) != null) { // ҹƤꥹ¸ߤ뤫ݤĴ٤
			return true;
		} else {
			return false;
		}
	}

    /**
     * μ椫ɽԤΤɬפʼܤӤޤ 
     * ɬפʼܤʤϡnull֤ޤ
     * 
     * @param itemList
     */
	private static List selectItemInfo(CollectorItemInfo target, List itemList) {
		ArrayList<CollectorItemInfo> returnList = new ArrayList<CollectorItemInfo>();
		
		// ɽɬפʼܥɤ
		List itemCodeList = getSubItemCode(target.getCollectorItemCode());
		
		// ǥХǥå
		int deviceIndex = target.getDeviceIndex();
		
		// ɽɬפʼܥɤο롼
		Iterator itrItemCodeList = itemCodeList.iterator();
		while (itrItemCodeList.hasNext()) {
			String itemCode = (String) itrItemCodeList.next();
			
			CollectorItemInfo buffer = null;
			
			Iterator itrItemList = itemList.iterator();
			while (itrItemList.hasNext()) {
				CollectorItemInfo itemInfo = (CollectorItemInfo)itrItemList.next();
				
				// itemList˼ܥɤȥǥХǥåƱǤ
				// ʣ¸ߤʤȤ
				if (itemInfo.getCollectorItemCode().equals(itemCode)
						&& itemInfo.getDeviceIndex() == deviceIndex) {
					buffer = itemInfo;
				}
			}
			
			if (buffer == null) {
				return null;
			} else {
				returnList.add(buffer);
			}
		}
		return returnList;
	}

    /**
     * ΥեƥΥǥХ򸵤ˡܥĥ꡼֤ޤ
     *  
     */
	public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId){
		return RecordController.getInstance().getCollectorTree(facilityId, collectorId);
	}
	
	/**
     * ΥեƥΥǥХ򸵤ˡܥĥ꡼֤ޤ
     * (IDˤnullꤵޤ)
     * 
	 * @param facilityID եƥID
	 * @param dataSet ǥХ
	 * @return Υեƥǽʼܤΰ(IDnull)
	 */
	public static List getAvailableCollectorItemList(String facilityId){
		return RecordController.getInstance().getAvailableCollectorItemList(facilityId);
	}
}