/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.preference;

import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performance.PerformancePlugin;

/**
 * ǽǽڡ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 *   
 */
public class PerformancePreferencePage extends FieldEditorPreferencePage
        implements IWorkbenchPreferencePage {

	//	 ----- static ե ----- //
	
    /** EJB setting URL */
    public static final String EJB_URL = "ejbUrl";

    /** ӥդɽΤɬפ **/
    
    public static final String COLLECTOR_ID = "collectorID";
    
    public static final String PATH_LABEL = "pathLabel";
    
    /** ʲͤRealtimeCollectorInfo **/    

    public static final String PERF_FACILITY_ID = "facilityId";
    
    public static final String PERF_SUB_SCOPE_NUM = "subScopeNum";
    
    public static final String PERF_GRAPH_NUM = "graphNum";
    
    public static final String PERF_SUB_SCOPE_FACILITY_ID[] = 
    		{"subScopeFacilityId01","subScopeFacilityId02","subScopeFacilityId03",
	    	"subScopeFacilityId04","subScopeFacilityId05","subScopeFacilityId06",
	    	"subScopeFacilityId07","subScopeFacilityId08","subScopeFacilityId09",
	    	"subScopeFacilityId10"};
	    
    public static final String PERF_SUB_SCOPE_FACILITY_NAME[] =
			{"subScopeFacilityName01","subScopeFacilityName02","subScopeFacilityName03",
	    	"subScopeFacilityName04","subScopeFacilityName05","subScopeFacilityName06",
	    	"subScopeFacilityName07","subScopeFacilityName08","subScopeFacilityName09",
	    	"subScopeFacilityName10"};   
  
    public static final String PERF_GRAPH_START_TIME = "graphStartTime";
    
    public static final String PERF_GRAPH_END_TIME = "graphEndTime";
    
    public static final String PERF_GRAPH_PLOT_NUM = "graphPlotNum";  
    
    /** ʲͤRealtimeCollectorItemInfo **/
    
    public static final String PERF_ITEM_INFO[][] = 
    		{{"itemInfo11","itemInfo12","itemInfo13","itemInfo14","itemInfo15"},
    		{"itemInfo21","itemInfo22","itemInfo23","itemInfo24","itemInfo25"},
    		{"itemInfo31","itemInfo32","itemInfo33","itemInfo34","itemInfo35"},
    		{"itemInfo41","itemInfo42","itemInfo43","itemInfo44","itemInfo45"}};
    
    public static final String PERF_ITEM_FOR_BOOLEAN[][] =
    		{{"itemInfoForBoolean11"},
			{"itemInfoForBoolean12"},
			{"itemInfoForBoolean13"},
			{"itemInfoForBoolean14"}};	
    
    /** ޤ **/
    
    
    /**
     * @param style
     */
    protected PerformancePreferencePage(int style) {
        super(style);
    }

    public PerformancePreferencePage() {
        super(GRID);
        this.setPreferenceStore(PerformancePlugin.getDefault()
                .getPreferenceStore());

//        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();

    	store.setDefault(COLLECTOR_ID, "");
    	store.setDefault(PATH_LABEL, "");
    	
    	/** ʲRealtimeCollectorInfoͤν **/    	
    	store.setDefault(PERF_FACILITY_ID, "");
    	store.setDefault(PERF_GRAPH_NUM, 4);
    	store.setDefault(PERF_SUB_SCOPE_NUM, "");
    	
    	for (int i = 0; i < 10; i++) {
    		store.setDefault(PERF_SUB_SCOPE_FACILITY_ID[i], "");
    		store.setDefault(PERF_SUB_SCOPE_FACILITY_NAME[i], "");
    	}
    	
    	store.setDefault(PERF_GRAPH_START_TIME, "");
    	store.setDefault(PERF_GRAPH_END_TIME, "");
    	store.setDefault(PERF_GRAPH_PLOT_NUM, "");
    	
       	/** ʲRealtimeCollectorItemInfoͤν **/
    	
    	for(int i = 0; i < store.getDefaultInt(PERF_GRAPH_NUM); i++){
    		store.setDefault(PERF_ITEM_INFO[i][0], "");
    		store.setDefault(PERF_ITEM_INFO[i][1], "");
    		store.setDefault(PERF_ITEM_INFO[i][2], "");
    		store.setDefault(PERF_ITEM_INFO[i][3], "");
    		store.setDefault(PERF_ITEM_INFO[i][4], "");
    		store.setDefault(PERF_ITEM_FOR_BOOLEAN[i][0], "");
    	}
    }

    public void createFieldEditors() {
    }

    /**
     * ǡ򤵤ƤcollectorIDץե󥹤˳Ǽ롣
     * @param collectorID
     */
    public void setCollectorId(String collectorId){
    	IPreferenceStore store = this.getPreferenceStore();
    	store.setValue(COLLECTOR_ID, collectorId);
    }
    
    /**
     * collectorIDץե󥹤ɤߤࡣ
     * @return String
     */
    public String getCollectorId() {
    	IPreferenceStore store = this.getPreferenceStore();
    	return store.getString(COLLECTOR_ID);
    }
    
    /**
     * դɽƤ륹ץѥץե󥹤˳Ǽ롣
     * @param pathLabel
     */
    public void setPathLabel(String pathLabel) {
    	IPreferenceStore store = this.getPreferenceStore();
    	store.setValue(PATH_LABEL, pathLabel);
    }
    
    /**
     * ץѥץե󥹤ɤߤ
     * @return
     */
    public String getPathLabel() {
    	IPreferenceStore store = this.getPreferenceStore();
    	return store.getString(PATH_LABEL);
    }
    
    /**
     * RealtimeCollectorInfo饹ˤץե󥹤˳Ǽ롣
     * @param RealtimeCollectorInfo
     */
    public void setRealtimeCollectorInfo(RealtimeCollectorInfo info) {
    	IPreferenceStore store = this.getPreferenceStore();
    	ArrayList list = info.getSubScopeFacilityName();
    	
    	store.setValue(PERF_FACILITY_ID, info.getFacilityId());
    	store.setValue(PERF_GRAPH_NUM, info.getGraphNum());

    	// ֥פ
    	store.setValue(PERF_SUB_SCOPE_NUM, info.getSubScopeNum());    	
    	for (int i = 0; i < info.getSubScopeNum(); i++) {
    		store.setValue(PERF_SUB_SCOPE_FACILITY_ID[i], info.getSubScopeFacilityId(i));
    		store.setValue(PERF_SUB_SCOPE_FACILITY_NAME[i], (String)list.get(i));
    	}
    	
    	// ɽ(ɽϻɽλʤ)
    	store.setValue(PERF_GRAPH_START_TIME, info.getGraphStartTime().getTime());
    	store.setValue(PERF_GRAPH_END_TIME, info.getGraphEndTime().getTime());
    	store.setValue(PERF_GRAPH_PLOT_NUM, info.getGraphPlotNum());
    	
    }
    
    /**
     * ץե󥹤ξRealtimeCollectorInfo饹˳Ǽֿ롣
     * @return RealtimeCollectorInfo
     */
    public RealtimeCollectorInfo getRealtimeCollectorInfo(RealtimeCollectorInfo info) {
    	IPreferenceStore store = this.getPreferenceStore();
    	ArrayList subScopeFacilityId = new ArrayList();
    	ArrayList subScopeFacilityName = new ArrayList();
    	Date date_start;
    	Date date_end;
    	
    	info.setFacilityId(store.getString(PERF_FACILITY_ID));
    	info.setGraphNum(store.getInt(PERF_GRAPH_NUM));
    	
    	// ֥פ
    	for (int i = 0; i < store.getInt(PERF_SUB_SCOPE_NUM); i++) {
    		subScopeFacilityId.add(store.getString(PERF_SUB_SCOPE_FACILITY_ID[i]));
    		subScopeFacilityName.add(store.getString(PERF_SUB_SCOPE_FACILITY_NAME[i]));
    	}
    	info.setSubScopeFacilityId(subScopeFacilityId);
    	info.setSubScopeFacilityName(subScopeFacilityName);
    	info.setSubScopeNum(store.getInt(PERF_SUB_SCOPE_NUM));
    	
    	// ɽ(ɽϻɽλʤ)
    	date_start = new Date(store.getLong(PERF_GRAPH_START_TIME));
    	date_end = new Date(store.getLong(PERF_GRAPH_END_TIME));
    	info.setGraphStartTime(date_start);
    	info.setGraphEndTime(date_end);
    	info.setGraphPlotNum(store.getInt(PERF_GRAPH_PLOT_NUM));
    	
    	return info;
    }
    
    /**
     * RealtimeCollectorItemInfo饹ˤץե󥹤˳Ǽ롣
     * @param RealtimeCollectorItemInfo
     * @param int
     */
    public void setRealtimeCollectorItemInfo(RealtimeCollectorItemInfo itemInfo){
    	IPreferenceStore store = this.getPreferenceStore();
    	
    	for(int i = 0; i < store.getInt(PERF_GRAPH_NUM); i++){
    		store.setValue(PERF_ITEM_INFO[i][0], itemInfo.getItemCode(i));
    		store.setValue(PERF_ITEM_INFO[i][1], itemInfo.getDisplayType(i));
    		store.setValue(PERF_ITEM_INFO[i][2], itemInfo.getDeviceIndex(i));
    		store.setValue(PERF_ITEM_INFO[i][3], itemInfo.getItemId(i));
    		if (itemInfo.getDeviceName(i) != null) {
    			store.setValue(PERF_ITEM_INFO[i][4], itemInfo.getDeviceName(i));
    		}
    		
    		store.setValue(PERF_ITEM_FOR_BOOLEAN[i][0], itemInfo.getItemDetailed(i));
    		
    	}
    }
    
    /**
     * ץե󥹤ξRealtimeCollectorItemInfo饹˳Ǽֿ롣
     * @return RealtimeCollectorItemInfo
     */
    public RealtimeCollectorItemInfo getRealtimeCollectorItemInfo(RealtimeCollectorItemInfo itemInfo) {
    	IPreferenceStore store = this.getPreferenceStore();
    	 
    	for (int i = 0; i < 4; i++) {
        	itemInfo.setItemInfo(
        			i,
        			store.getString(PERF_ITEM_INFO[i][0]),
        			store.getString(PERF_ITEM_INFO[i][1]),
        			store.getString(PERF_ITEM_INFO[i][2]),
        			store.getString(PERF_ITEM_INFO[i][3]),
        			store.getString(PERF_ITEM_INFO[i][4]),
        			store.getBoolean(PERF_ITEM_FOR_BOOLEAN[i][0])
			);	
    	}
    	
    	return itemInfo;
    }
    
    public boolean savePreference() {
    	IPreferenceStore store = this.getPreferenceStore();
    	if (store != null && store.needsSaving()
						&& store instanceof IPersistentPreferenceStore) {
    		try {
				((IPersistentPreferenceStore) store).save();
			} catch (IOException e) {
				return false;
			}
    	}
    	return true;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    public void init(IWorkbench workbench) {

    }
}