/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.composite;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.util.Messages;

/**
 * ܥɤ򤹤륳ݥåȥ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CollectorItemComboComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 8;
	
    /**  */
    private Combo m_comboCollectorItem = null;
	
	public CollectorItemComboComposite(Composite parent, int style) {
		super(parent, style);
        this.initialize();
    }
    
    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
    	
    	// ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;	
        this.setLayout(layout);
        
        /*
         * 
         */
        // ٥
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.item") + " : ");
        // ܥܥå
        this.m_comboCollectorItem = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboCollectorItem.setLayoutData(gridData);
    }
    
    /**
     * ܤ򤹤륳ܥܥåޤ
     * 
     * @param facilityId եƥID
     */
    public void setCollectorItemCombo(String facilityId){
		// ܤΰ
		List itemInfoList =
			CollectorItemCodeFactory.getAvailableCollectorItemList(facilityId);
		
		// ꤵƤܤƾõ
		m_comboCollectorItem.removeAll();
		
		Iterator itr = itemInfoList.iterator();
		while(itr.hasNext()){
			CollectorItemInfo itemInfo = (CollectorItemInfo)itr.next();
			
			String itemName = CollectorItemCodeFactory.getFullItemName(itemInfo);
			m_comboCollectorItem.add(itemName);
			m_comboCollectorItem.setData(itemName, itemInfo);
		}
    }
    
    public CollectorItemInfo getCollectorItem(){
        String itemName = m_comboCollectorItem.getText();
        CollectorItemInfo itemInfo = (CollectorItemInfo)m_comboCollectorItem.getData(itemName);
        return itemInfo;
    }
    
    public void select(MonitorInfo monitor){
        // ǽƻ
        MonitorPerfCheckInfo perfCheckInfo = (MonitorPerfCheckInfo)monitor.getCheckInfo();

        // ƻоݤξꤵƤʤϤʤˤ⤷ʤ
        if(perfCheckInfo == null){
        	return;
        }
        
    	String facilityId = monitor.getFacilityId();

    	setCollectorItemCombo(facilityId);
    	
    	int index = 0;
    	
    	List itemInfoList = 
    		CollectorItemCodeFactory.getAvailableCollectorItemList(facilityId);
    	
    	Iterator itr = itemInfoList.iterator();
    	int i=0;
    	while(itr.hasNext()){
    		CollectorItemInfo itemInfo = (CollectorItemInfo)itr.next();
    		
    		if(itemInfo.getCollectorItemCode().equals(perfCheckInfo.getItemCode()) &&
    				itemInfo.getDeviceName().equals(perfCheckInfo.getDeviceName())){
    			index = i;
    		}
    		i++;
    	}
    	
        this.m_comboCollectorItem.select(index);
    }
    
	/**
     * ͤѤƴƻޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		if(info != null){
	        // ꥽ƻ
	        MonitorPerfCheckInfo perfCheckInfo = (MonitorPerfCheckInfo)info.getCheckInfo();
			
	        if (this.m_comboCollectorItem.getText() != null
	                && !"".equals((this.m_comboCollectorItem.getText()).trim())) {
	        	String itemName = this.m_comboCollectorItem.getText();
	        	CollectorItemInfo itemInfo = (CollectorItemInfo)m_comboCollectorItem.getData(itemName);
	        	
	            perfCheckInfo.setMonitorTypeId("PERF");
	            perfCheckInfo.setMonitorId(info.getMonitorId());
	            
	            perfCheckInfo.setItemCode(itemInfo.getCollectorItemCode());
	            perfCheckInfo.setDeviceIndex(itemInfo.getDeviceIndex());
	            perfCheckInfo.setDeviceName(itemInfo.getDeviceName());
	            
	            info.setCheckInfo(perfCheckInfo);
	        } else {
	        	return setValidateResult(Messages.getString("message.hinemos.1"),
	        			Messages.getString("message.monitor.1"));
	        }
		}
		return null;
    }
	
	/**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
}
