/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */
package com.clustercontrol.performance.composite.tree;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;

/**
 * ܥĥ꡼ѤΥ٥ץХ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
class CollectorTreeLabelProvider extends LabelProvider {

	public String getText(Object element) {
		String itemCode = ((CollectorItemTreeItem) element).getData().getCode();
		
		// ǥХݻƤ뤫ݤȽ
		if(((CollectorItemTreeItem) element).getDeviceData() == null){
			// ݻƤʤ ̾
			return ((CollectorItemTreeItem) element).getData().getName();
		} else {
			// ݻƤ ̾˲äǥХ̾
			String deviceName = 
				((CollectorItemTreeItem) element).getDeviceData().getDeviceName();

			return CollectorItemCodeFactory.getFullItemName(itemCode, deviceName);
		}
	}

    public Image getImage(Object element) {
    	return null;
    }
}
