/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */
package com.clustercontrol.performance.composite.tree;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;

/**
 * ܥĥ꡼ѤΥƥĥץХ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CollectorTreeContentProvider implements ITreeContentProvider {
	
	// ----- instance ᥽å ----- //
	
	private static final Comparator COMPARATOR = 
		new Comparator() {
		public int compare(Object o1, Object o2) {
			String id1 = ((CollectorItemTreeItem)o1).getData().getCode();
			String id2 = ((CollectorItemTreeItem)o2).getData().getCode();
			
			int comp = id1.compareTo(id2);
			
			if(comp == 0){ // ɤƱϥǥХΥǥå˥Ȥ
				DeviceData dv1 = ((CollectorItemTreeItem)o1).getDeviceData();
				DeviceData dv2 = ((CollectorItemTreeItem)o2).getDeviceData();
				if(dv1 != null & dv2 != null){
					return dv1.getDeviceIndex() - dv2.getDeviceIndex();
				} else {
					return 0; // ɤ餫ǥХݻƤʤ
				}
			} else {				
				return id1.compareTo(id2);
			}
		}
	};
	
	public Object getParent(Object element) {
		return ((CollectorItemTreeItem) element).getParent();
	}
	
	
	public Object[] getElements(Object inputElement) {
		return (CollectorItemTreeItem[])inputElement;
	}
	
	
	public Object[] getChildren(Object parentElement) {
		List list = ((CollectorItemTreeItem) parentElement).getChildrens();
		
		CollectorItemTreeItem[] items =
			(CollectorItemTreeItem[])list.toArray(new CollectorItemTreeItem[list.size()]);
		
		if (items != null) {
			Arrays.sort(items, COMPARATOR);
		}
		
		return items;
	}
	
	
	public boolean hasChildren(Object element) {
		return ((CollectorItemTreeItem)element).size() > 0;
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
	
	public void dispose() {
	}
}
