/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;

/**
 * ӥդɽ뤿μܤꤹ륳ݥåȥ饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RecordGraphSetItemComposite extends Composite {

    private GridLayout gridLayoutButton = null;

    private Group group = null;

    private Combo combo = null;

    private Button radioButton1;

    private Button radioButton2;

    private Button radioButton3;

    private Button radioButton4;

    // ܤξݻ
    private String categoryCode;

    private List itemList;

    private ArrayList availableItems; //Υƥ˴ޤޤǽʡ˼ܤΥꥹ

    private int selectItemID;

    private int graphType;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     */
    public RecordGraphSetItemComposite(Composite parent, int style) {
        super(parent, style);

        availableItems = new ArrayList();

        initialize();
    }

    /**
     * ȥꤷޤ
     * 
     * @param title
     */
    public void setTitle(String title) {
        group.setText(title);
    }

    /**
     * ꤷޤ
     */
    public void setData(String categoryCode, List itemList, int selectItemID,
            int graphType) {
        this.categoryCode = categoryCode;
        this.itemList = itemList;
        this.selectItemID = selectItemID;
        this.graphType = graphType;

        // ܥܥå˥ǡ
        setComboData();

        // 饸ܥ
        setButtonSelection();
    }

    /**
     * This method initializes group
     *  
     */
    private void createGroup() {
        group = new Group(this, SWT.NONE);

        //GridData
        gridLayoutButton = new GridLayout();
        gridLayoutButton.numColumns = 3; //3
        group.setLayout(gridLayoutButton);

        createCombo();

        GridData gridDataButton;

        //		ɽܥ
        radioButton1 = new Button(group, SWT.RADIO);
        radioButton1.setText(Messages.getString("HIDDEN"));
        gridDataButton = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridDataButton.horizontalSpan = 3; //ʬ
        radioButton1.setLayoutData(gridDataButton);

        //		ɽͥܥ
        radioButton2 = new Button(group, SWT.RADIO);
        radioButton2.setText(Messages.getString("SCOPE_REPRESENTING_VALUE"));
        gridDataButton = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        radioButton2.setLayoutData(gridDataButton);

        //		ɽ;ܺ٥ܥ
        radioButton3 = new Button(group, SWT.RADIO);
        radioButton3.setText(Messages
                .getString("DETAIL_SCOPE_REPRESENTING_VALUE"));
        gridDataButton = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        radioButton3.setLayoutData(gridDataButton);

        //		֥ɽͥܥ
        radioButton4 = new Button(group, SWT.RADIO);
        radioButton4.setText(Messages.getString("SUB_SCOPE_REP_VAL"));
        gridDataButton = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        radioButton4.setLayoutData(gridDataButton);

    }

    /**
     * This method initializes combo
     *  
     */
    private void createCombo() {
        combo = new Combo(group, SWT.NONE | SWT.READ_ONLY);

        //GridData
        GridData gridDataCombo = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridDataCombo.horizontalSpan = 3; //3ʬ
        combo.setLayoutData(gridDataCombo);

        combo.addSelectionListener(new SelectionListener() {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                // ܺɽǽݤå
                checkItemList(getSelectItem());
            }
        }

        );

        combo.setBounds(new org.eclipse.swt.graphics.Rectangle(5, 15, 200, 20));
    }

    /**
     * ܺɽǽݤĴ١򤵤ƤܤܺɽǤʤܤξϡ 饸ܥΡɾܺ٥աɤԲĤȤ롣
     */
    private void checkItemList(CollectorItemInfo itemInfo) {
        // ܺɽǽݤå
        if (CollectorItemCodeFactory.checkItemList(itemInfo, availableItems)) {
            setDetailButtonEnabled(true);
        } else {
            // ܺɽ򤵤Ƥϥɽͤѹ
            if (getGraphType() == GraphProperty.TYPE2) {
                graphType = GraphProperty.TYPE1;
                setButtonSelection();
            }
            setDetailButtonEnabled(false);
        }
    }

    public void setDetailButtonEnabled(boolean enabled) {
        radioButton3.setEnabled(enabled);
    }

    public void setSubScopeButtonEnabled(boolean enabled) {
        radioButton4.setEnabled(enabled);
    }

    /**
     * ܥܥå˥ǡꤷޤ
     */
    private void setComboData() {
        // 
        Iterator itr = itemList.iterator();

        int i = 0;
        int selectIndex = 0;
        while (itr.hasNext()) {
            CollectorItemInfo itemInfo = (CollectorItemInfo) itr.next();

            // ΥƥǤ뤫å
            if (CollectorItemCodeFactory.getCategoryCode(
                    itemInfo.getCollectorItemCode()).equals(this.categoryCode)) {
                // ܥܥå˼̾ɲ
                combo.add(CollectorItemCodeFactory.getFullItemName(itemInfo
                        .getCollectorItemCode(), itemInfo.getDeviceName()));
                // ǽʼܥꥹȤ˼ܾɲ
                availableItems.add(itemInfo);

                // ߥɽƤΤ򤵤줿֤ˤ
                if (itemInfo.getCollectorItemID() == this.selectItemID) {
                    selectIndex = i;
                }
                i++; // 󥯥
            }
        }

        combo.select(selectIndex);

        // ܺɽǽݤå
        checkItemList((CollectorItemInfo) this.availableItems.get(selectIndex));
    }

    /**
     * 饸ܥꤷޤ
     */
    private void setButtonSelection() {
        // 򤵤Ƥ륰ռ̤бܥ򤵤줿֤ˤ
        switch (graphType) {
        case GraphProperty.INVISIBLE:
            radioButton1.setSelection(true);
            radioButton2.setSelection(false);
            radioButton3.setSelection(false);
            radioButton4.setSelection(false);
            break;
        case GraphProperty.TYPE1:
            radioButton1.setSelection(false);
            radioButton2.setSelection(true);
            radioButton3.setSelection(false);
            radioButton4.setSelection(false);
            break;
        case GraphProperty.TYPE2:
            radioButton1.setSelection(false);
            radioButton2.setSelection(false);
            radioButton3.setSelection(true);
            radioButton4.setSelection(false);
            break;
        case GraphProperty.TYPE3:
            radioButton1.setSelection(false);
            radioButton2.setSelection(false);
            radioButton3.setSelection(false);
            radioButton4.setSelection(true);
            break;
        default:
            radioButton1.setSelection(true);
            radioButton2.setSelection(false);
            radioButton3.setSelection(false);
            radioButton4.setSelection(false);
        }
    }

    private void initialize() {
        createGroup();
        this.setLayout(new FillLayout());
    }

    /**
     * @return graphType ᤷޤ
     */
    public int getGraphType() {
        if (radioButton1.getSelection()) {
            this.graphType = GraphProperty.INVISIBLE;
        } else if (radioButton2.getSelection()) {
            this.graphType = GraphProperty.TYPE1;
        } else if (radioButton3.getSelection()) {
            this.graphType = GraphProperty.TYPE2;
        } else if (radioButton4.getSelection()) {
            this.graphType = GraphProperty.TYPE3;
        }

        return this.graphType;
    }

    /**
     * @return 򤵤Ƥܤᤷޤ
     */
    public CollectorItemInfo getSelectItem() {
        return (CollectorItemInfo) this.availableItems.get(this.combo
                .getSelectionIndex());
    }

    /**
     * @param graphType
     *            graphType ꡣ
     */
    public void setGraphType(int graphType) {
        this.graphType = graphType;
        setButtonSelection();
    }
}