/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;

/**
 * ʣμӥդΥݥåȤޤȤɽ륳ݥåȥ饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RecordGraphHolderComposite extends Composite {

    private Label idLabel;

    private Label scopeLabel;

    private Composite baseCcomposite = null;

    private RecordGraphComposite[] composite = null;

    private String collectorID; // ɽоݤμID

    private String currentPath; // ɽƤ륹ץѥ

    // դ
    private GraphProperty[] graphPropertys;

    // ɽѥǡ
    private RecordCollectorData collectorData;

    private List itemInfoList;

    private FacilityTreeItem facilityTree;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     */
    public RecordGraphHolderComposite(Composite parent, int style,
            int maxGraphSize) {
        super(parent, style);

        composite = new RecordGraphComposite[maxGraphSize]; // ɽΰ

        initialize();
    }

    /**
     * GUI
     *  
     */
    private void initialize() {
        GridData gridData1 = new GridData();
        idLabel = new Label(this, SWT.NONE);
        idLabel.setLayoutData(gridData1);

        GridData gridData2 = new GridData();
        scopeLabel = new Label(this, SWT.NONE);
        scopeLabel.setLayoutData(gridData2);

        baseCcomposite = new Composite(this, SWT.NONE);
        baseCcomposite.setLayout(new FillLayout(SWT.VERTICAL));

        GridData gridData3 = new GridData();
        gridData3.grabExcessVerticalSpace = true;
        gridData3.horizontalAlignment = GridData.FILL;
        gridData3.verticalAlignment = GridData.FILL;
        baseCcomposite.setLayoutData(gridData3);

        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;	
        
        this.setLayout(gridLayout);
    }

    /**
     * ѤΥǡꤷޤ
     */
    public void setMasterData(RecordCollectorData collectorData,
            List itemInfoList, FacilityTreeItem facilityTree) {
        this.collectorData = collectorData;
        this.itemInfoList = itemInfoList;
        this.facilityTree = facilityTree;
        this.collectorID = collectorData.getCollectorID();
        // ɽΰõ
        if (graphPropertys != null) {
        	for (int i = 0; i < this.graphPropertys.length; i++) {
                disposeGraph(i);
            }
        }
    }

    /**
     * ǥդɽޤ
     */
    public void redrawGraph(GraphProperty[] graphProperty) {
        this.graphPropertys = graphProperty;

        // ٥
        FacilityPath fp = new FacilityPath(Messages.getString("SEPARATOR"));
        currentPath = fp.getPath(graphProperty[0].getTargetFacility());
        setLabel();
        
        for (int i = 0; i < this.graphPropertys.length; i++) {
            // 
            // ռ̤ɽξ⤷ϡ
            // ռ̤֥ɽͤǤ뤬Υפ˻ҥפʤ
            if (graphProperty[i].getGraphType() == GraphProperty.INVISIBLE
                    || graphProperty[i].getGraphType() == GraphProperty.TYPE3
                    && graphProperty[i].getTargetFacility().getChildren().length == 0) {
            	// ɡǤϲ⤷ʤ
            } else {
                // λŻ򤹤ᥤ롼ȡ
                // compositeФǤ뤳Ȥա
                getGraph(i).drawGraph(graphProperty[i]);
            }          
        }
    }

    /**
     * Υΰΰ褬¸ߤʤϺ֤
     * 
     * @param index
     */
    private RecordGraphComposite getGraph(int graphIndex) {
        if (composite[graphIndex] == null) {
        	// դɽơΤcomposite.
            composite[graphIndex] = new RecordGraphComposite(baseCcomposite);
            // ɽΤΥǡ
            if (collectorData != null) {
                composite[graphIndex].setMasterData(collectorData, itemInfoList,
                        facilityTree);
            }
        }
        return composite[graphIndex];
    }

    /**
     * Υΰ
     * 
     * @param index
     */
    private void disposeGraph(int graphIndex) {
        if (composite[graphIndex] != null) {
            composite[graphIndex].dispose();
            composite[graphIndex] = null;
        }
    }

    /**
     * ٥ꤷޤ
     */
    private void setLabel() {
        idLabel.setText(Messages.getString("COLLECTION_ID") + " : " + collectorID);
        scopeLabel.setText(Messages.getString("SCOPE") +  " : "  + currentPath);
    }

    /**
     * դɽ֤ޤ
     * 
     * @return GraphProperty
     */
    public GraphProperty[] getGraphPropertys() {
        return this.graphPropertys;
    }

    /**
     * IDޤ
     * 
     * @return collectorID
     */
    public String getCollectorID() {
        return collectorID;
    }
}