/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.OutputFormat;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;

/**
 * ӥǡݡȥ󥯥饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RecordDataWriter implements Runnable {

    private CollectorProperty property;

    private String facilityID;

    private boolean headerFlag;

    private File file;

    private FileOutputStream fos;

    private OutputStreamWriter osw;

    private BufferedWriter bw;

    private Date lastDate = null;

    private int getSize = 100; // ޥ͡㤫٤˼ǡʻּ

    private long collectStartTime;

    private long collectStopTime;

    private int progress;

    private boolean canceled;

    /**
     * 󥹥ȥ饯
     */
    public RecordDataWriter(String filename, CollectorProperty property,
            String facilityID, boolean headerFlag) {
        this.file = new File(filename);
        this.property = property;
        this.facilityID = facilityID;
        this.headerFlag = headerFlag;
    }

    /**
     * ˥եޤ
     * 
     * @return ꤵ줿ե뤬¸ߤե true줿ե뤬Ǥ¸ߤ false
     */
    public boolean createNewFile() throws IOException {
        return this.file.createNewFile();
    }

    /**
     * եؤΥݡȤ¹Ԥޤ
     */
    public void run() {
        try {
            write(property, facilityID, headerFlag);
        } catch (IOException e) {
        }
    }

    /**
     * ߤޤǤǽͥǡβΥݡȤλΤޤ
     * 
     * @return Ľ
     */
    public int getProgress() {
        return progress;
    }

    /**
     * 񤭥⡼ɤǥե򳫤ޤ
     * 
     * @throws FileNotFoundException
     * @throws UnsupportedEncodingException
     */
    private void openFile() throws FileNotFoundException {
        try {
            fos = new FileOutputStream(this.file); // 񤭥⡼ɤǳ
            osw = new OutputStreamWriter(fos);
            bw = new BufferedWriter(osw);
        } catch (FileNotFoundException e) {
            throw e;
        } finally {
        }
    }

    /**
     * եĤޤ
     * 
     * @throws IOException
     */
    private void closeFile() throws IOException {
        try {
            bw.close();
            osw.close();
            fos.close();
        } catch (IOException e) {
            throw e;
        } finally {
        }
    }

    /**
     * μǡΥꥹȤե˽Ϥޤ
     */
    public void write(CollectorProperty property, String facilityID,
            boolean headerFlag) throws IOException {
        try {
            // ե򳫤
            openFile();

            if (headerFlag) {
                // إå
                writeHeader(property.getCollectorData(), facilityID);
            }

            // Υץѥƥ
            RecordCollectorData collectorData = property.getCollectorData();

            // ܤΥꥹȤ
            List itemList = property.getItemList();
            int[] itemIDs = new int[itemList.size()];

            for (int i = 0; i < itemIDs.length; i++) {
                itemIDs[i] = ((CollectorItemInfo) itemList.get(i))
                        .getCollectorItemID();
            }

            // ¤夨ޤ
            Arrays.sort(itemIDs);

            String[] facilityIDs = new String[1];
            facilityIDs[0] = facilityID;

            collectStartTime = collectorData.getStartDate().getTime();
            collectStopTime = collectorData.getStopDate().getTime();
            int interval = collectorData.getInterval();
            int timeBlock = interval * 1000 * getSize; // 1٤˼֤δֳ(ߥñ)

            // ʣʬ
            long overlap = interval * 3 * 1000; // ߥ

            long stratTime = collectStartTime;
            long endTime = 0;

            // 롼פ󤹲׻(Ľ׻Τ)
            int loopMax = ((int) (collectStopTime - collectStartTime)
                    / timeBlock + 1);
            // 롼פβݻ(Ľ׻Τ)
            int loopCount = 0;

            while (this.canceled == false && stratTime < collectStopTime) {
                endTime = stratTime + timeBlock; // ޥ͡㤫ǡκλ

                // ֤μ1ľʤǤǤʤᾯʣƼ
                Date startDate = new Date(stratTime - overlap); // ޥ͡㤫ǡκǾ
                Date endDate = new Date(endTime); // ޥ͡㤫ǡκ

                RecordController controller = RecordController.getInstance();
                // ޥ͡Ȥ³˼Ԥϥ顼
                if (controller == null) {
                    throw new RemoteException("Can't connect to manager.");
                }

                // ǽǡŪ¸뤿ΥХåե
                CollectedDataSet dataSetBuffer = new CollectedDataSet();

                // ܤʬ䤷ƿʬƥޥ͡㤫ǽͤ
                for (int i = 0; i < itemIDs.length; i++) {
                    int[] itemIDBuffer = new int[1];
                    itemIDBuffer[0] = itemIDs[i];

                    CollectedDataSet dataSet = controller
                            .getRecordCollectedData(collectorData
                                    .getCollectorID(), facilityIDs,
                                    itemIDBuffer, startDate, endDate);

                    // ǽǡμ˼Ԥϥ顼
                    if (dataSet == null) {
                        throw new RemoteException(
                                "Get performance data failed.");
                    }

                    dataSetBuffer.addCollectedDataList(dataSet);

                    // Ľ׻
                    progress = (int) (((loopCount + ((double) i / itemIDs.length)) / loopMax) * 100);
                }

                // ǽͤ
                white(facilityID, property.getItemList(), itemIDs,
                        dataSetBuffer);

                stratTime = endTime;
                loopCount++;
            }
            // λΤǿĽ100%Ȥ
            progress = 100;
        } catch (IOException e) {
            throw e;
        } finally {
            // եĤ
            closeFile();
        }
    }

    /**
     * إåϤޤ
     * 
     * @param profile
     */
    private void writeHeader(RecordCollectorData profile, String facilityID)
            throws IOException {
        try {
            // 

            // ID
            bw.write(Messages.getString("EXPORT_HEADER_COLLECTORID") + ", "
                    + profile.getCollectorID());
            bw.newLine(); // 

            // ٥
            bw.write(Messages.getString("EXPORT_HEADER_LABEL") + ", "
                    + profile.getLabel());
            bw.newLine(); // 

            // оݥ
            bw.write(Messages.getString("EXPORT_HEADER_FACILITY") + ", "
                    + facilityID);
            bw.newLine(); // 

            // ϻ
            bw.write(Messages.getString("EXPORT_HEADER_STARTDATE") + ", "
                    + OutputFormat.dateToString(profile.getStartDate()));
            bw.newLine(); // 
            bw.newLine(); // 
        } catch (IOException e) {
            throw e;
        } finally {
        }
    }

    /**
     * ǽͤե˽Ϥޤ
     * 
     * @param facilityID
     * @param itemInfoList
     * @param targetItemIDs
     * @param dataSet
     * @throws IOException
     */
    private void white(String facilityID, List itemInfoList,
            int[] targetItemIDs, CollectedDataSet dataSet) throws IOException {
        try {
            // Ƥν񤭹ߤξϹܤ
            if (lastDate == null) {
                // ̾
                String msg = Messages.getString("EXPORT_COLUMN_TIME");
                for (int j = 0; j < targetItemIDs.length; j++) {
                    // ܥꥹȤID˰פΤõμ̾
                    for (int i = 0; i < itemInfoList.size(); i++) {
                        CollectorItemInfo itemInfo = (CollectorItemInfo) itemInfoList
                                .get(i);
                        if (itemInfo.getCollectorItemID() == targetItemIDs[j]) {
                            String itemName = CollectorItemCodeFactory
                                    .getFullItemName(itemInfo
                                            .getCollectorItemCode(), itemInfo
                                            .getDeviceName());

                            msg = msg + ", " + itemName;
                            i = itemInfoList.size(); // IDϽʣ뤳ȤϤʤ롼פȴ
                        }
                    }
                }
                bw.write(msg);
                bw.newLine(); // 
            }

            List[] collectedDataListArray = new List[dataSet
                    .getDataListNum(facilityID)];

            if (collectedDataListArray.length != targetItemIDs.length) {
                // 顼
                bw.write(Messages.getString("INVALID_DATA_IN_DB"));
                bw.newLine(); // 
            	
            	return;
            }

            for (int i = 0; i < targetItemIDs.length; i++) {
                // IDν֤˼ѤߥǡꥹȤ֤
                collectedDataListArray[i] = dataSet.getCollectedDataList(
                        facilityID, targetItemIDs[i]);
            }

            // ƤǻּǤοƱǤ뤿ᡤ
            // ŬʤΤǡꥹȤλּΥ
            int timeSize = collectedDataListArray[0].size();

            // ƤǻּǤοƱǤ뤫å롣
            for (int i = 1; i < targetItemIDs.length; i++) {
                if(timeSize != collectedDataListArray[i].size()){
                    // 顼
                    bw.write(Messages.getString("INVALID_DATA_IN_DB"));
                    bw.newLine(); // 
                    
                	return;
                }
            }
            
            CollectedDataInfo data = null;
            for (int t = 0; t < timeSize; t++) {
                // ǽιܤ
                CollectedDataInfo firstData = (CollectedDataInfo) collectedDataListArray[0]
                        .get(t);

                // ʣʬϽϤʤ
                if (lastDate == null
                        || firstData.getDate().getTime() > lastDate.getTime()) {

                    String msg = null;
                    for (int i = 0; i < targetItemIDs.length; i++) {
                        data = (CollectedDataInfo) collectedDataListArray[i]
                                .get(t);

                        if (i == 0) { // ǽιܤ
                            // ʸ
                            msg = OutputFormat.dateToString(data.getDate())
                                    + ", "
                                    + OutputFormat.doubleToString(data
                                            .getValue());
                        } else {
                            // ʸ
                            msg = msg
                                    + ", "
                                    + OutputFormat.doubleToString(data
                                            .getValue());
                        }
                    }
                    bw.write(msg);
                    bw.newLine(); // 
                }
            }

            // Ϥ줿ǸϿ
            if (data != null) {
                lastDate = data.getDate();
            }
        } catch (IOException e) {
            throw e;
        } finally {
        }
    }

    /**
     * ݡ˽ߤޤ
     * 
     * @param b
     *            ߤˤtrueꤷޤ
     */
    public void setCanceled(boolean b) {
        this.canceled = b;
    }
}