/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.action;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorLockKey;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.bean.DeviceDataSet;
import com.clustercontrol.performanceMGR.ejb.session.CollectorController;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerHome;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import com.clustercontrol.util.LoginManager;

/**
 * ޥ͡ȤΤԤȥ饯饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RecordController {
    private static RecordController m_instance = null;

    private CollectorController bean;

    CollectorLockKey m_lockKey;  // ǡκå򤫤뤿θȤʤ륯饹
    
    private int errorCount = 1;

    public static final String KEY_EJB_URL = "ejbUrl";

    public static final String VALUE_EJB_URL = "jnp://localhost:1099";

    private RecordController() {
    	Properties pro = System.getProperties();
    	
    	String userName = pro.getProperty("user.name");
    	if(userName == null){
    		userName = "nobody";
    	}
    	
    	String ipAddress = null;
    	try{
    		ipAddress =	InetAddress.getLocalHost().getHostAddress(); 
    	} catch(UnknownHostException e){
    		String time = pro.getProperty("eclipse.startTime");
    		
        	if(time == null){
        		time = Long.toString(System.currentTimeMillis());
        	}
        	
    		int hash = Thread.currentThread().hashCode();
    		
    		// IPɥ쥹Ǥʤäᡢʤ٤դȤʤ褦ID
    		ipAddress = "unknown host (" + time + "-" + hash + ")";
    	}
    	
    	m_lockKey = new CollectorLockKey(ipAddress, userName);
    }

    /**
     * 󥹥󥹤֤ޤ(åӡ˼Ԥϡnull֤ޤ)
     *  
     */
    public static synchronized RecordController getInstance() {
        if (m_instance == null) {
            m_instance = new RecordController();
        }

        // åӡݻƤʤ
        if (m_instance.bean == null) {
            m_instance.createBean();

            // åӡǤʤϡ顼ͤȤnull֤ޤ
            if (m_instance.bean == null) {
                m_instance = null;
                return null;
            }
        }

        return m_instance;
    }

    /**
     * 󥹥󥹤˴ޤ
     *  
     */
    public static synchronized void deleteInstance() {
        if (m_instance != null) {
            m_instance.removeBean();
            m_instance.bean = null;
            m_instance = null;
        }
    }

    /**
     * ޥ͡SessionBeanޤ
     *  
     */
    private void createBean() {
        try {
            // EJB֥Ȥ롣
            this.bean = getCollectorControllerHome().create();
        } catch (RemoteException e) {
            this.bean = null;
        } catch (CreateException e) {
            this.bean = null;
        } catch (NamingException e) {
            this.bean = null;
        }
    }

    /**
     * ޥ͡SesseionBeanλޤ
     *  
     */
    private void removeBean() {
        try {
            // EJB֥Ȥ˴롣
            if (this.bean != null) {
                this.bean.remove();
            }
        } catch (RemoteException e) {
        } catch (RemoveException e) {
        }
        this.bean = null;
    }
    
    /**
     * 
     * ꥹȤޤ
     * 
     * @return ѤߤμΥ쥯
     */
    public ArrayList getCollectionListTableDefine() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // ѤߤΤΤμꥹȤ롣              	
                    return this.bean.getCollectionListTableDefine(Locale.getDefault());
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }

        return null;
    }

    /**
     * 
     * ꥹȤޤ
     * 
     * @return ѤߤμΥ쥯
     */
    public ArrayList getCollectionList() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // ѤߤΤΤμꥹȤ롣
                    return this.bean.getCollectionList();
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }

        return null;
    }

    /**
     * μǼ򳫻Ϥޤ
     * 
     * @param def
     *            
     * @return γϤ true Ԥϡfalse ֤ޤ
     * @throws DuplicateKeyException
     */
    public boolean registRecordCollector(CollectorProperty def)
            throws DuplicateKeyException {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // 򳫻Ϥ롣
                    this.bean.createRecordColletor(def);
                    return true;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }

        return false;
    }

    /**
     * νλؼޤ
     * 
     * @param collectorID
     *            ID
     * @return νλ true Ԥϡfalse ֤ޤ
     */
    public boolean stopRecordCollector(String collectorID) {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // λ롣
                    this.bean.stopRecordCollector(collectorID);
                    return true;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }
        return false;
    }

    /**
     * μξDBޤ
     * 
     * @param collectorID
     *            ID
     * @return μκ true Ԥϡfalse ֤ޤ
     * @throws RemoveException
     *             åäƤ뤳ȤǺǤʤˤΤߥޤ
     *             (¾θǺǤʤϡExceptionϥޤ)
     */
    public boolean deleteRecordCollector(String collectorID)
            throws RemoveException {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // 
                    this.bean.deleteRecordCollector(collectorID);
                    return true;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }
        return false;
    }

    /**
     * μμޤ
     * 
     * @param collectorID
     */
    public CollectorProperty getCollectorProperty(String collectorID) {
        CollectorProperty property = null;

        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    property = this.bean.getCollectorProperty(collectorID);

                    return property;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }

        return null;
    }

    /**
     * ǽͤޤ
     * 
     * @return CollectedDataSet
     */
    public CollectedDataSet getRecordCollectedData(final String collectorID,
            final String[] facilityIDs, final int[] itemIDs,
            final Date startDate, final Date endDate) {
        CollectedDataSet dataSet = null;

        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    dataSet = this.bean.getRecordCollectedData(collectorID,
                            facilityIDs, itemIDs, startDate, endDate);
                    return dataSet;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }

        return null;
    }

    /**
     * ߤΥǥХޤ
     * 
     * @param եƥID
     * @return ǥХ󥻥å
     */
    public DeviceDataSet getCurrentDeviceSet(String facilityID) {
        DeviceDataSet deviceSet = null;

        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // ߤΥǥХåȤ롣
                    deviceSet = this.bean.getCurrentDeviceSet(facilityID);
                    return deviceSet;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }

        return null;
    }

    /**
     * ܥɾޤ
     * 
     * @param եƥID
     * @return ǥХ󥻥å
     */
    public HashMap<String, CollectorItemTreeItem> getItemCodeTreeMap() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {               	
                    return bean.getItemCodeMap();
                } catch (RemoteException e) {
                	e.printStackTrace();
                    removeBean();
                } catch (Exception e){
                	e.printStackTrace();
                }
            }
        }

        return null;
    }
    
    /**
     * ܥɾޤ
     * 
     * @param եƥID
     * @return ǥХ󥻥å
     */
    public CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {               	
                    return bean.getCollectorTree(facilityId, collectorId);
                } catch (RemoteException e) {
                	e.printStackTrace();
                    removeBean();
                } catch (Exception e){
                	e.printStackTrace();
                }
            }
        }

        return null;
    }
    
    /**
     * ܥɾޤ
     * 
     * @param եƥID
     * @return ǥХ󥻥å
     */
    public List getAvailableCollectorItemList(String facilityId) {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {               	
                    return bean.getAvailableCollectorItemList(facilityId);
                } catch (RemoteException e) {
                	e.printStackTrace();
                    removeBean();
                } catch (Exception e){
                	e.printStackTrace();
                }
            }
        }

        return null;
    }

    /**
     * ɤ߹߸¤뤫ɤåޤ
     * 
     * @return ¤true֤
     */
    public boolean checkPermissionRead() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {               	
                    return bean.checkPermissionRead();
                } catch (AccessException e) {
                	bean = null;
                	return false;
                } catch (RemoteException e) {
                	e.printStackTrace();
                    removeBean();
                } catch (Exception e){
                	e.printStackTrace();
                }
            }
        }

        return false;
    }

    /**
     * 񤭹߸¤뤫ɤåޤ
     * 
     * @return ¤true֤
     */
    public boolean checkPermissionWrite() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {               	
                    return bean.checkPerformanceWrite();
                } catch (AccessException e) {
                	bean = null;
                	return false;
                } catch (RemoteException e) {
                	e.printStackTrace();
                    removeBean();
                } catch (Exception e){
                	e.printStackTrace();
                }
            }
        }

        return false;
    }

    /**
     * ¹Ը¤뤫ɤåޤ
     * 
     * @return ¤true֤
     */
    public boolean checkPermissionExecute() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {               	
                    return bean.checkPermissionExecute();
                } catch (AccessException e) {
                	bean = null;
                	return false;
                } catch (RemoteException e) {
                	e.printStackTrace();
                    removeBean();
                } catch (Exception e){
                	e.printStackTrace();
                }
            }
        }

        return false;
    }
    
    /**
     * å򤫤ޤ 
     */
    public void lock(String collectorID) {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // ޥ͡¦ǴƤå򤫤ޤ
                    this.bean.lock(collectorID, m_lockKey);
                    return;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }
    }

    /**
     * åޤ
     */
    public void unlock() {
        for (int i = 0; i <= this.errorCount; i++) {
            if (bean == null) {
                createBean();
            }

            // 嵭createbean()η̡ϤǤʤǽ뤿ᡢ٥å
            if (bean != null) {
                try {
                    // ޥ͡¦ǴƤåޤ
                    this.bean.unlock(m_lockKey);
                    return;
                } catch (RemoteException e) {
                    removeBean();
                }
            }
        }
    }
    
    private CollectorControllerHome getCollectorControllerHome()
            throws NamingException {
        return (CollectorControllerHome) getContext().lookup(
                CollectorControllerHome.JNDI_NAME);
    }

    private NamingContext getContext() throws NamingException {
    	NamingContext namingContext = LoginManager.getContextManager().getNamingContext();
        
        return namingContext;
    }
}