/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.bean.GraphDisplayRange;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.composite.RecordGraphComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performanceMGR.bean.CollectorRunStatus;

/**
 * ӥդ褹뤿Υ󥯥饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class DrawRecordGraphAction extends SelectionAdapter {
    RecordGraphComposite m_composite;

    // ˥ޥ͡㤫ѤߤΥǡݻ

    private int m_graphType;

    private RecordCollectorData m_collectorData;

    private List m_itemInfoList;

    private CollectorItemInfo m_currentItem;

    private FacilityTreeItem m_facilityTree;

    // 褵ƤϰϤꥹȤݻ
    private ArrayList m_gotTimeArea;

    public DrawRecordGraphAction() {
        this.m_gotTimeArea = new ArrayList();
    }

    public DrawRecordGraphAction(RecordCollectorData collectorData,
            List itemInfoList) {
        this.m_collectorData = collectorData;
        this.m_itemInfoList = itemInfoList;
    }

    /**
     * ƤӽФȤʤ륰եݥåȤꤷޤ
     * 
     * @param composite
     */
    public void setComposite(RecordGraphComposite composite) {
        this.m_composite = composite;
    }

    /**
     * 
     * ǡꤷޤɽѹ
     * 
     * @param collectorData
     * @param itemInfoList
     * @param facilityTree
     */
    public void setData(RecordCollectorData collectorData, List itemInfoList,
            FacilityTreeItem facilityTree) {
        this.m_collectorData = collectorData;
        this.m_itemInfoList = itemInfoList;
        this.m_facilityTree = facilityTree;
    }

    /**
     * դ褷ޤ
     * 
     * @param facilityTree
     * @param itemID
     * @param graphType
     */
    public void drawGraph(FacilityTreeItem facilityTree, int itemID,
            int graphType) {
        setTargetFacility(facilityTree);
        setTargetItemID(itemID);
        this.m_graphType = graphType;

        // դޤ
        createGraph();

        double lowerBound = (this.m_composite.getHorizontalBar().getSelection()) * 1000D;
        double upperBound = (this.m_composite.getHorizontalBar().getThumb() + this.m_composite
                .getHorizontalBar().getSelection()) * 1000D;

        drawGraph((long) lowerBound, (long) upperBound);
    }

    /**
     * դ褷ޤ
     * 
     * @param lowerBound
     * @param upperBound
     */
    private void drawGraph(long lowerBound, long upperBound) {
        if (m_collectorData == null || m_itemInfoList == null
                || m_currentItem == null || m_facilityTree == null) {
            return;
        }
        
        long startTime = m_collectorData.getStartDate().getTime() + lowerBound;
        long endTime = m_collectorData.getStartDate().getTime() + upperBound;

        GraphDisplayRange dr = getDisplayRange(new GraphDisplayRange(startTime,
                endTime));

        if (dr == null) {
            // 褹ϰϤϤʤ
        	return;
        } else {
            startTime = dr.getStartTime();
            endTime = dr.getEndTime();
        }

        // դɽ2ץåʬ;ʬ˼롣
        Date startDate = new Date(startTime
                - this.m_collectorData.getInterval() * 2 * 1000); // ñ
        Date endDate = new Date(endTime + this.m_collectorData.getInterval()
                * 2 * 1000); // ñ

        switch (m_graphType) {
        case GraphProperty.TYPE1:
            drawGraph1(m_currentItem, m_facilityTree, startDate, endDate);
            break;
        case GraphProperty.TYPE2:
            drawGraph2(m_currentItem, m_facilityTree, startDate, endDate);
            break;
        case GraphProperty.TYPE3:
            drawGraph3(m_currentItem, m_facilityTree, startDate, endDate);
            break;
        default:
            break;
        }

        // 褷ϰϤѤϰϥꥹȤɲä
        addGotTimeArea(dr);
    }

    /**
     * ռ̤ꤷޤ
     * 
     * @param graphType
     */
    public void setGraphType(int graphType) {
        this.m_graphType = graphType;
    }

    public int getGraphType() {
        return this.m_graphType;
    }

    /**
     * оݤμIDꤷޤ
     * 
     * @param itemID
     */
    public void setTargetItemID(int itemID) {
        Iterator itr = this.m_itemInfoList.iterator();

        while (itr.hasNext()) {
            CollectorItemInfo itemInfo = (CollectorItemInfo) itr.next();
            if (itemInfo.getCollectorItemID() == itemID) {
                this.m_currentItem = itemInfo;
            }
        }
    }

    public CollectorItemInfo getTargetItem() {
        return this.m_currentItem;
    }

    /**
     * оݤΥեƥꤷޤ
     * 
     * @param facilityTree
     */
    public void setTargetFacility(FacilityTreeItem facilityTree) {
        this.m_facilityTree = facilityTree;

        // դޤ
        createGraph();
    }

    public FacilityTreeItem getTargetFacility() {
        return this.m_facilityTree;
    }

    /**
     * դޤ
     */
    public void createGraph() {
        if (m_collectorData == null || m_itemInfoList == null
                || m_currentItem == null) {
            return;
        }

        String itemCode = m_currentItem.getCollectorItemCode(); // ܥ
        String deviceName = m_currentItem.getDeviceName();

        String title = CollectorItemCodeFactory.getCategoryName(itemCode);

        if (CollectorItemCodeFactory.isDeviceSupport(itemCode)) {
            title = title + "(" + m_currentItem.getDeviceName() + ")";
        }

        if (this.m_graphType == GraphProperty.TYPE1) {
            title = title + " "
                    + Messages.getString("SCOPE_REPRESENTING_VALUE"); // "ɽ"
        } else if (this.m_graphType == GraphProperty.TYPE2) {
            title = title + " "
                    + Messages
                            .getString("DETAIL_SCOPE_REPRESENTING_VALUE"); // "ɽ;ܺ"
        } else if (this.m_graphType == GraphProperty.TYPE3) {
            title = title + " "
                    + Messages
                            .getString("SUB_SCOPE_REP_VAL"); // "֥ɽ"
        }

        Date stopDate; // λ
        if (m_collectorData.getStatus() == CollectorRunStatus.RUNNING) { // ξ
            long stopTime = m_collectorData.getStartDate().getTime()
                    + m_collectorData.getRealCollectPeriod();
            stopDate = new Date(stopTime);
        } else {
            stopDate = m_collectorData.getStopDate();
        }

        this.m_composite.createGraph(title, // ȥ
                Messages.getString("TIME"), // ٥
                CollectorItemCodeFactory.getFullItemName(itemCode, deviceName)
                        + "("
                        + CollectorItemCodeFactory.getMeasure(itemCode) + ")", // ļ٥
                m_graphType, // ե
                CollectorItemCodeFactory.isRangeFixed(itemCode), // ե饰
                m_collectorData.getInterval(), // 󥿡Х
                m_collectorData.getStartDate(), // ϻ
                stopDate // λ
                );
    }

    /**
     * Widget򤵤줿ȤΥԤޤ
     */
    public synchronized void widgetSelected(
            org.eclipse.swt.events.SelectionEvent e) {
        double lowerBound = (this.m_composite.getHorizontalBar().getSelection()) * 1000D;
        double upperBound = (this.m_composite.getHorizontalBar().getThumb() + this.m_composite
                .getHorizontalBar().getSelection()) * 1000D;

        this.drawGraph((long) lowerBound, (long) upperBound);

        this.m_composite.setRange(lowerBound, upperBound);
    }

    /**
     * 
     * μܤɽͥդɽޤ
     * 
     * @param itemInfo
     * @param treeItem
     * @param startDate
     * @param endDate
     */
    public synchronized void drawGraph1(CollectorItemInfo itemInfo,
            FacilityTreeItem treeItem, Date startDate, Date endDate) {

        // ޥ͡㤫ǡ
        String[] facilityIDs = new String[1];
        facilityIDs[0] = treeItem.getData().getFacilityId();

        int[] itemIDs = new int[1];
        itemIDs[0] = itemInfo.getCollectorItemID();

        RecordController controller = RecordController.getInstance();
        // ޥ͡Ȥ³˼Ԥϥ顼ɽ
        if (controller == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"),  // "ǧ"
            		Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }

        CollectedDataSet dataSet = controller.getRecordCollectedData(itemInfo
                .getCollectorID(), facilityIDs, itemIDs, startDate, endDate);
        // ǽǡμ˼Ԥϥ顼ɽ
        if (dataSet == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"),  // "ǧ"
            		Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }

        List dataList = dataSet
                .getCollectedDataList(facilityIDs[0], itemIDs[0]);

        if (dataList.size() != 0) { // ΥɽǤϥޥ͡㤫ͤǤƤʤ⤢뤿
            // դͤ
            setItemData(itemInfo.getCollectorItemCode(), itemInfo
                    .getDeviceName(), dataList);
        }
    }


    
    public synchronized void drawGraph1Test1(
    		String collectorID,
    		String itemCode,
			CollectorItemInfo itemInfo,
			String facilityId,
			Date startDate,
			Date endDate) {

        // ޥ͡㤫ǡ
        String[] facilityIDs = new String[1];
        facilityIDs[0] = facilityId;

        int[] itemIDs = new int[1];
        itemIDs[0] = itemInfo.getCollectorItemID();

        RecordController controller = RecordController.getInstance();
        // ޥ͡Ȥ³˼Ԥϥ顼ɽ
        if (controller == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }

        CollectedDataSet dataSet = controller.getRecordCollectedData(
        		collectorID, facilityIDs, itemIDs, startDate, endDate);
        // ǽǡμ˼Ԥϥ顼ɽ
        if (dataSet == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }

        List dataList = dataSet
                .getCollectedDataList(facilityIDs[0], itemIDs[0]);

        if (dataList.size() != 0) { // ΥɽǤϥޥ͡㤫ͤǤƤʤ⤢뤿
            // դͤ
            setItemData(itemCode, "itemInfo.getDeviceName()", dataList);
        }
    }
  
    
    /**
     * μܤξܺپդȤɽޤʻμܤΥդ褹櫓ǤϤʤ
     * 
     * @param itemInfo
     * @param treeItem
     * @param startDate
     * @param endDate
     */
    public synchronized void drawGraph2(CollectorItemInfo itemInfo,
            FacilityTreeItem treeItem, Date startDate, Date endDate) {
        // ɬפʼܤΥꥹȤ
        List itemInfoList = selectItemInfo(itemInfo, this.m_itemInfoList);

        // դɽɬפʹܤƤʤϥ顼
        if (itemInfoList == null) {
            // 顼
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("DRAW_RECORD_GRAPH_ERROR_MESSAGE02"));
            return;
        }

        // ޥ͡㤫ǡ
        String[] facilityID = new String[1];
        facilityID[0] = treeItem.getData().getFacilityId();

        int[] itemIDs = new int[itemInfoList.size()];
        for (int i = 0; i < itemIDs.length; i++) {
            itemIDs[i] = ((CollectorItemInfo) (itemInfoList.get(i)))
                    .getCollectorItemID();
        }

        RecordController controller = RecordController.getInstance();
        // ޥ͡Ȥ³˼Ԥϥ顼ɽ
        if (controller == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }

        CollectedDataSet dataSet = controller.getRecordCollectedData(itemInfo
                .getCollectorID(), facilityID, itemIDs, startDate, endDate);
        // ǽǡμ˼Ԥϥ顼ɽ
        if (dataSet == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }

        ArrayList addedDataList = new ArrayList();
        // ̥դˤ뤿ͤù
        Iterator itr = itemInfoList.iterator();
        while (itr.hasNext()) {
            CollectorItemInfo buffer = (CollectorItemInfo) itr.next();
            List collectedDataList = dataSet.getCollectedDataList(treeItem
                    .getData().getFacilityId(), buffer.getCollectorItemID());

            int size = addedDataList.size();
            // ޤǼǡΥꥹȤ˸߼ͤ­
            for (int i = 0; i < size; i++) {
                List dataBuffer = (List) addedDataList.get(i);
                addedDataList.set(i, getSumData(dataBuffer, collectedDataList));
            }
            addedDataList.add(collectedDataList);
        }

        // κͤȺǾͤ
        List bufferList = (List) addedDataList.get(0); // ɤƱǤ뤿ǽǤǵ

        if (bufferList.size() != 0) { // ΥɽǤϥޥ͡㤫ͤǤƤʤ⤢뤿

            // դͤ
            int itemSize = itemInfoList.size();
            for (int i = 0; i < itemSize; i++) {
                CollectorItemInfo buffer = (CollectorItemInfo) itemInfoList
                        .get(i);
                List collectedDataList = (List) addedDataList.get(i);
                setItemData(buffer.getCollectorItemCode(), buffer
                        .getDeviceName(), collectedDataList);
            }
        }
    }

    /**
     * μܤΥ֥ɽͥդɽޤ
     * 
     * @param itemInfo
     * @param treeItem
     * @param startDate
     * @param endDate
     */
    public synchronized void drawGraph3(CollectorItemInfo itemInfo,
            FacilityTreeItem treeItem, Date startDate, Date endDate) {
        // ҥפꤹ
        FacilityTreeItem[] children = treeItem.getChildren();
        ArrayList targetFacilitys = new ArrayList();
        for (int i = 0; i < children.length; i++) {
            targetFacilitys.add(children[i].getData());
        }

        // ޥ͡㤫ǡ
        String[] facilityIDs = new String[targetFacilitys.size()];
        for (int i = 0; i < facilityIDs.length; i++) {
            facilityIDs[i] = ((FacilityInfo) (targetFacilitys.get(i)))
                    .getFacilityId();
        }

        int[] itemID = new int[1];
        itemID[0] = itemInfo.getCollectorItemID();

        RecordController controller = RecordController.getInstance();
        // ޥ͡Ȥ³˼Ԥϥ顼ɽ
        if (controller == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }

        CollectedDataSet dataSet = controller.getRecordCollectedData(itemInfo
                .getCollectorID(), facilityIDs, itemID, startDate, endDate);
        // ǽǡμ˼Ԥϥ顼ɽ
        if (dataSet == null) {
            MessageDialog.openError(this.m_composite.getShell(), 
            		Messages.getString("MESSAGE_0020"), 
            		Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }

        // κͤȺǾͤ
        String facilityID = ((FacilityInfo) targetFacilitys.get(0))
                .getFacilityId(); // ɤƱǤ뤿ǽǤǵ
        List bufferList = (List) dataSet.getCollectedDataList(facilityID,
                itemInfo.getCollectorItemID());

        if (bufferList.size() != 0) { // ΥɽǤϥޥ͡㤫ͤǤƤʤ⤢뤿

            // դͤ
            Iterator itr = targetFacilitys.iterator();
            int i = 0;
            while (itr.hasNext()) {
                FacilityInfo facilityInfo = (FacilityInfo) itr.next();
                List collectedDataList = dataSet.getCollectedDataList(
                        facilityInfo.getFacilityId(), itemInfo
                                .getCollectorItemID());
                setFacilityData(i, collectedDataList);
                i++;
            }
        }
    }

    /**
     * ̾Ȥơդͤꤷޤʥɽͥադξ
     * 
     * @param composite
     * @param itemCode
     * @param data
     */
    private void setItemData(String itemCode, String deviceName, List data) {
        this.m_composite.setGraphData(CollectorItemCodeFactory.getFullItemName(
                itemCode, deviceName), data);
    }

    /**
     * եƥ̾Ȥơդͤꤷޤʥ֥ɽͥդξ
     * 
     * @param composite
     * @param itemCode
     * @param data
     */
    private void setFacilityData(int index, List data) {
        this.m_composite.setSubscopeGraphData(index, data);
    }

    /**
     * μ椫ɽԤΤɬפʼܤӤޤ ɬפʼܤʤϡnull֤ޤ
     * 
     * @param itemList
     */
    private List selectItemInfo(CollectorItemInfo target, List itemList) {
        ArrayList returnList = new ArrayList();

        // ɽɬפʼܥɤ
        List itemCodeList = CollectorItemCodeFactory.getSubItemCode(target
                .getCollectorItemCode());

        // ǥХǥå
        int deviceIndex = target.getDeviceIndex();

        // ɽɬפʼܥɤο롼
        Iterator itrItemCodeList = itemCodeList.iterator();
        while (itrItemCodeList.hasNext()) {
            String itemCode = (String) itrItemCodeList.next();

            CollectorItemInfo buffer = null;

            Iterator itrItemList = itemList.iterator();
            while (itrItemList.hasNext()) {
                CollectorItemInfo itemInfo = (CollectorItemInfo) itrItemList
                        .next();
                // itemList˼ܥɤȥǥХǥåƱǤʣ¸ߤʤȤ
                if (itemInfo.getCollectorItemCode().equals(itemCode)
                        && itemInfo.getDeviceIndex() == deviceIndex) {
                    buffer = itemInfo;
                }
            }

            if (buffer == null) {
                // ˻ꤵ줿ܤǤϡɽԤˤԽʬǤ롣
                return null;
            } else {
                returnList.add(buffer);
            }
        }
        return returnList;
    }

    /**
     * 2ĤμѤǽͥꥹȤ¤Ȥޤ
     * 
     * @param dataSet1
     * @param dataSet2
     * @return
     */
    private List getSumData(List dataSet1, List dataSet2) {
        ArrayList dataList = new ArrayList();

        if (dataSet1.size() != dataSet2.size()) {
            // 顼
        }

        Iterator itr1 = dataSet1.iterator();
        Iterator itr2 = dataSet2.iterator();

        while (itr1.hasNext()) {
            CollectedDataInfo data1 = (CollectedDataInfo) itr1.next();
            CollectedDataInfo data2 = (CollectedDataInfo) itr2.next();
            CollectedDataInfo returnData = new CollectedDataInfo(data1
                    .getFacilityID(), data1.getCollectorItemID(), data1
                    .getDate(), data1.getValue() + data2.getValue());
            dataList.add(returnData);
        }

        return dataList;
    }

    /**
     * ѤϰϤΥꥹȤϰϤɲä롣
     * 
     * @param dr
     *            ѤߥꥹȤɲäϰ
     */
    private void addGotTimeArea(GraphDisplayRange dr) {
        // Ƥξ
        if (m_gotTimeArea.size() == 0) {
            m_gotTimeArea.add(dr);

            return;
        }

        Iterator itr = m_gotTimeArea.iterator();

        while (itr.hasNext()) {
            GraphDisplayRange drBuffer = (GraphDisplayRange) itr.next();

            if (dr.getEndTime() < drBuffer.getStartTime()) {
                // 褵ƤϰϤȽŤʤϰϤʤᡢꥹȤɲä
                int index = m_gotTimeArea.indexOf(drBuffer);
                m_gotTimeArea.add(index, dr);
                return;
            } else if (drBuffer.getStartTime() <= dr.getEndTime()
                    && dr.getEndTime() <= drBuffer.getEndTime()) {
                // ɲоݤϰϤνλ郎ꥹȤˤѤϰϤΤҤȤĤ˼ޤ
                // ѤϰϤ(ϰϤ򹭤)

                // ɲäɽϰϤʬɽѤϰϤ򹭤
                drBuffer.setStartTime(dr.getStartTime());

                return;
            } else if (drBuffer.getStartTime() <= dr.getStartTime()
                    && dr.getStartTime() <= drBuffer.getEndTime()) {
                // ɲоݤϰϤγϻ郎ꥹȤˤѤϰϤΤҤȤĤ˼ޤ
                // ѤϰϤ(ϰϤ򹭤)

                // ɲäɽϰϤʬɽѤϰϤ򹭤
                drBuffer.setEndTime(dr.getEndTime());

                // ǤϰϤĴٽλȳϤλ郎褦ʤ礹롣
                if (itr.hasNext()) {
                    GraphDisplayRange nextDrBuffer = (GraphDisplayRange) itr
                            .next();
                    if (nextDrBuffer.getStartTime() <= drBuffer.getEndTime()) {
                        // λ礭ۤ򿷤ʽλȤ
                        drBuffer.setEndTime(Math.max(nextDrBuffer.getEndTime(),
                                nextDrBuffer.getEndTime()));

                        // 礵줿¦Ϻ
                        m_gotTimeArea.remove(nextDrBuffer);
                    }
                }
                return;
            }
        }
        m_gotTimeArea.add(dr);
    }

    /**
     * ˾ϰϤ򤢤ȡѤߥꥹȤȾȹ礷ޤ褵ƤʤϰϤ֤ ƤϰϤѤߤξnull֤
     * 
     * @param dr
     *            ˾ϰ
     * @return ޤ褵Ƥʤϰ
     */
    private GraphDisplayRange getDisplayRange(GraphDisplayRange dr) {
        // ꥹȤˤޤʤˤϿƤʤ
        if (m_gotTimeArea.size() == 0) {
            return dr;
        }

        GraphDisplayRange returnDr = new GraphDisplayRange();
        returnDr.setStartTime(dr.getStartTime());
        returnDr.setEndTime(dr.getEndTime());

        Iterator itr = m_gotTimeArea.iterator();

        while (itr.hasNext()) {
            GraphDisplayRange drBuffer = (GraphDisplayRange) itr.next();

            // ϻȽ
            if (drBuffer.getStartTime() <= dr.getStartTime()
                    && dr.getStartTime() <= drBuffer.getEndTime()) {
                returnDr.setStartTime(drBuffer.getEndTime());
            }

            // λȽ
            if (drBuffer.getStartTime() <= dr.getEndTime()
                    && dr.getEndTime() <= drBuffer.getEndTime()) {
                returnDr.setEndTime(drBuffer.getStartTime());
            }
        }

        if (returnDr.getStartTime() >= returnDr.getEndTime()) {
            returnDr = null;
        }

        return returnDr;
    }
}