/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyTabelDefine;
import com.clustercontrol.notify.factory.AddNotify;
import com.clustercontrol.notify.factory.AddSystemNotify;
import com.clustercontrol.notify.factory.DeleteNotify;
import com.clustercontrol.notify.factory.DeleteSystemNotify;
import com.clustercontrol.notify.factory.ModifyNotify;
import com.clustercontrol.notify.factory.ModifySystemNotify;
import com.clustercontrol.notify.factory.SelectNotify;
import com.clustercontrol.notify.factory.SelectSystemNotify;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="NotifyController"	
 *           jndi-name="NotifyController"
 *           type="Stateless"
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *            
 * <!-- end-xdoclet-definition --> 
 * @generated
*/
public abstract class NotifyControllerBean implements javax.ejb.SessionBean {

	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * ξϿޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ξ
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean addNotify(NotifyInfo info) throws CreateException, NamingException, JMSException {

		// ξϿ
		AddNotify notify = new AddNotify();
		return  notify.add(info);
	}
	
	/**
	 * ξ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ξ
	 * @return ѹ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean modifyNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {

		// ξ򹹿
		ModifyNotify notify = new ModifyNotify();
		return  notify.modify(info);
	}
	
	/**
	 * ξޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param notifyId ID
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean deleteNotify(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {

		// ξ
		DeleteNotify notify = new DeleteNotify();
		return  notify.delete(notifyId);
	}
	
	/**
	 * ξ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param notifyId ID
	 * @return ξ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public NotifyInfo getNotify(String notifyId) throws FinderException, NamingException {

		// ξ
		SelectNotify notify = new SelectNotify();
		NotifyInfo info = notify.getNotify(notifyId);

		return info;
	}
	
	/**
	 * ID֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return ID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNotifyIdList() throws CreateException, FinderException, NamingException {

		// ID
		SelectNotify notify = new SelectNotify();
		ArrayList list = notify.getNotifyIdList();

		return list;
	}
	
	/**
	 * ΰꥹȤ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNotifyList() throws CreateException, FinderException, NamingException {

		// ΰ
		SelectNotify notify = new SelectNotify();
		ArrayList list = notify.getNotifyList();

		return list;
	}
	
	/**
	 * ΰޥåפ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return ξޥåסʥID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public HashMap<String, NotifyInfo> getNotifyMap() throws FinderException, NamingException {

		// ΰ
		SelectNotify notify = new SelectNotify();
		HashMap<String, NotifyInfo> map = notify.getNotifyMap();

		return map;
	}
	
	/**
	 * ΰΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNotifyListTableDefine(Locale local) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NotifyTabelDefine.NOTIFY_ID, 
				new TableColumnInfo(Messages.getString("notify.id", local), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 300, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.STATUS, 
				new TableColumnInfo(Messages.getString("status.katakana", local), TableColumnInfo.CHECKBOX, 60, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.EVENT, 
				new TableColumnInfo(Messages.getString("event.katakana", local), TableColumnInfo.CHECKBOX, 60, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ƥξϿޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ξ
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean addSystemNotify(NotifyInfo info) throws CreateException, NamingException, JMSException {

		// ƥξϿ
		AddSystemNotify notify = new AddSystemNotify();
		return  notify.add(info);
	}
	
	/**
	 * ƥξ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ξ
	 * @return ѹ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean modifySystemNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {

		// ƥξ򹹿
		ModifySystemNotify notify = new ModifySystemNotify();
		return  notify.modify(info);
	}
	
	/**
	 * ƥξޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param notifyId ID
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean deleteSystemNotify(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {

		// ƥξ
		DeleteSystemNotify notify = new DeleteSystemNotify();
		return  notify.delete(notifyId);
	}
	
	/**
	 * ƥξ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param notifyId ID
	 * @return ξ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public NotifyInfo getSystemNotify(String notifyId) throws FinderException, NamingException {

		// ƥξ
		SelectSystemNotify notify = new SelectSystemNotify();
		NotifyInfo info = notify.getNotify(notifyId);

		return info;
	}
}
