/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.dialog.StatusFilterDialog;
import com.clustercontrol.monitor.view.StatusView;

/**
 * ơˤ븡Ԥ󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusFilterAction implements IViewActionDelegate {

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        StatusView view = (StatusView) this.viewPart
                .getAdapter(StatusView.class);

        if (action.isChecked()) {
            // 
            StatusFilterDialog dialog = new StatusFilterDialog(this.viewPart
                    .getSite().getShell());

            // ˤƸ򤵤줿硢̤ӥ塼ɽ
            if (dialog.open() == IDialogConstants.OK_ID) {
                Property condition = dialog.getInputData();

                view.setCondition(condition);
                view.update();
            } else {
                action.setChecked(false);
            }
        } else {
            // 說ꥢ
            view.setCondition(null);

            // ץĥ꡼Υƥ(ץѥʸκɽΤ)
            TreeViewer tree = view.getScopeTreeComposite().getTreeViewer();

            // ץĥ꡼Υƥब򤵤Ƥ
            if (((StructuredSelection) tree.getSelection()).getFirstElement() != null) {
                tree.setSelection(tree.getSelection()); // ӥ塼ιԤ
            }
            // ץĥ꡼Υƥब򤵤Ƥʤ
            else {
                view.update();
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}