/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.monitor.MonitorPlugin;
import com.clustercontrol.monitor.bean.ScopeTabelDefine;
import com.clustercontrol.monitor.view.ScopeView;

/**
 * ֥륯å˥װ򹹿륢󥯥饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ScopeSpecifiedShowAction implements IDoubleClickListener {

	/* 
	 * @see org.eclipse.jface.viewers.IDoubleClickListener#doubleClick(org.eclipse.jface.viewers.DoubleClickEvent)
	 */
	public void doubleClick(DoubleClickEvent event) {
		
		// ֥륯åפΥեƥID
		ArrayList list = (ArrayList) ((StructuredSelection)event.getSelection()).getFirstElement();
		String facilityId = (String)list.get(ScopeTabelDefine.FACILITY_ID);
		
		if(facilityId != null && !"".equals(facilityId)){
			
			IWorkbench workbench = MonitorPlugin.getDefault().getWorkbench();
	        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
	        
	        ScopeView scopeView = (ScopeView) page.findView(ScopeView.ID);
	        
	        if (scopeView != null) {
	        	
	        	FacilityTreeItem[] children = null;
	        	
	        	// 򤵤Ƥĥ꡼ƥ
	        	FacilityTreeComposite facilityTree = scopeView.getScopeTreeComposite();
	        	FacilityTreeItem selectItem = facilityTree.getSelectItem();
	        	
	        	// ĥ꡼ƥब򤵤Ƥʤ
	        	if(selectItem == null){
	        		
	        		// Ǿ̤Υĥ꡼ƥ
	        		FacilityTreeItem[] root = ((FacilityTreeItem)facilityTree.getTreeViewer().getInput()).getChildren();
	        		if(root != null && root.length>0){
	        			children = root[0].getChildren();
	        		}
	        	}
	        	// ĥ꡼ƥब򤵤Ƥ
	        	else{
	        		
	        		// ֥륯åפ򤵤Ƥĥ꡼ƥǤϤʤ硢
	        		// 򤵤Ƥĥ꡼ƥľΥĥ꡼ƥ
	        		String selectFacilityId = selectItem.getData().getFacilityId();
	        		if(!facilityId.equals(selectFacilityId)){
	                	children = selectItem.getChildren();
	        		}
	        	}
	            
	        	if(children != null){
	        		
	        		FacilityInfo tmpInfo = null;
	        		FacilityTreeItem[] grandchild = null;
	        		String tmpFacilityId = null;
	        		
	        		// ֥륯åפΥեƥIDȰפĥ꡼ƥ
	        		for(int index=0; index<children.length; index++){
	        			
	        			tmpInfo = children[index].getData();
	        			if(tmpInfo != null){
	            			tmpFacilityId = tmpInfo.getFacilityId();
	            			if(facilityId.equals(tmpFacilityId)){
	            				
	            				// ֥륯åפΡɤǤϤʤ硢
	        					// FacilityIDбĥ꡼ƥ֤ˤ
	            				grandchild = children[index].getChildren();
	            				if(grandchild != null && grandchild.length>0){
	            					
	                				facilityTree.getTreeViewer().setSelection(
	                                        new StructuredSelection(children[index]), true);
	            				}
	            				break;
	            			}
	        			}
	        		}
	        	}
	        }
		}
	}
}
