/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.view.action;

import java.util.ArrayList;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.ReportEvent;
import com.clustercontrol.monitor.dialog.EventReportDialog;
import com.clustercontrol.monitor.util.EventReportGenerator;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.util.Messages;

/**
 * ɥˤĢɼϤԤ󥯥饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventReportAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.monitor.view.action.DownloadAction";
	
	
	//	 ----- instance ե ----- //
	
	private IViewPart viewPart; // ӥ塼
	
	// ----- instance ᥽å ----- //
	
	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}
	
	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		EventView view = (EventView) this.viewPart.getAdapter(EventView.class);
		
		// 
		EventReportDialog dialog = new EventReportDialog(this.viewPart.getSite().getShell());
		
		// ˤƽϤ򤵤줿硢Ģɼ
		if (dialog.open() == IDialogConstants.OK_ID) {
			
			FacilityTreeItem item = view.getScopeTreeComposite().getSelectItem();
			String facilityId = null;
			if (item != null) {
				facilityId = item.getData().getFacilityId();
			}
			Property condition = dialog.getInputData();
			int outputForm = dialog.getOutputForm();
			String redirect = dialog.getRedirect();
			
			// ٥Ȱ
			ArrayList list = new ReportEvent().getEventInfo(facilityId, condition);
			
			// Ģɼ
			EventReportGenerator report = new EventReportGenerator();
			if(report.run(facilityId, condition, list, outputForm, redirect)){
				String[] args = { redirect };
				
				MessageBox box = new MessageBox(this.viewPart.getSite().getShell(), SWT.OK | SWT.ICON_INFORMATION);
				box.setText(Messages.getString("successful"));
				box.setMessage(Messages.getString("message.monitor.45",args));
				box.open();
			}
			else{
				MessageBox box = new MessageBox(this.viewPart.getSite().getShell(), SWT.OK | SWT.ICON_ERROR);
				box.setText(Messages.getString("failed"));
				box.setMessage(Messages.getString("message.monitor.46"));
				box.open();
			}
		}
	}
	
	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}
}