/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.composite.EventListComposite;
import com.clustercontrol.monitor.dialog.EventInfoDialog;
import com.clustercontrol.monitor.view.EventView;

/**
 * ٥Ⱦܺ٥ɽ륢󥯥饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventDetailAction implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.monitor.view.action.EventDetailAction";

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /* (non Javadoc)
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

	/* (non Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
        // 򥢥ƥޤ
        EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

        EventListComposite composite = 
        	(EventListComposite)view.getListComposite();
        
        StructuredSelection selection = 
        	(StructuredSelection)composite.getTableViewer().getSelection();

        List list = (List)selection.getFirstElement();
    	
        if(list != null){
        	EventInfoDialog dialog = 
        		new EventInfoDialog(
        				this.viewPart.getSite().getShell(), 
        				list);
        	dialog.open();
        }
	}

	/* (non Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

	}
}
