/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.composite.StatusListComposite;
import com.clustercontrol.monitor.preference.MonitorPreferencePage;
import com.clustercontrol.monitor.ui.MonitorUIPlugin;
import com.clustercontrol.monitor.view.action.StatusDeleteAction;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.ScopeListBaseView;

/**
 * ִƻ뵡ǽݥơƻӥ塼饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusView extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.monitor.view.StatusView";

    //	 ----- instance ե ----- //

    /** ơƻݥå */
    private StatusListComposite tableComposite = null;

    /**  */
    private Property condition = null;

    //	 ----- 󥹥ȥ饯 ----- //

    //	 ----- instance ᥽å ----- //

    /**
     * ơơ֥ɲäޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @return ơơ֥륳ݥå
     */
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.tableComposite = new StatusListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        
        //ݥåץåץ˥塼
        createContextMenu();

        this.update();

        // ȿ
        IPreferenceStore store = MonitorUIPlugin.getDefault()
                .getPreferenceStore();

        this.setInterval(store
                .getInt(MonitorPreferencePage.P_STATUS_UPDATE_CYCLE));

        if (store.getBoolean(MonitorPreferencePage.P_STATUS_UPDATE_FLG)) {
            this.startAutoReload();
        }

        return this.tableComposite;
    }

    /**
     * 򤵤줿(Ρ)ξɽޤ
     * 
     * @param item
     *            ץĥ꡼ƥ
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {
        // ȥܥ򸵤᤹
//        if (this.condition != null) {
//            IToolBarManager toolbar = this.getViewSite().getActionBars()
//                    .getToolBarManager();
//            String id = "com.clustercontrol.monitor.view.action.StatusFilterAction";
//            ActionContributionItem actionItem = (ActionContributionItem) toolbar
//                    .find(id);
//
//            actionItem.getAction().setChecked(false);
//            this.condition = null;
//        }

        this.update();
    }
    
    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(tableComposite.getTable());
        tableComposite.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem deleteAction = (ActionContributionItem) toolbar
        		.find(StatusDeleteAction.ID);

        //ݥåץåץ˥塼˥ɲ
        manager.add(deleteAction.getAction());
    }

    /**
     * ӥ塼򹹿ޤ
     * <p>
     */
    public void update() {

        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        String facilityId = null;
        if (item != null) {
            facilityId = item.getData().getFacilityId();
        }

        if (this.condition == null) {
            // ץĥ꡼ǥƥब򤵤Ƥʤ
            if (facilityId == null) {
                this.getPathLabel()
                        .setText(Messages.getString("scope") + " : ");
                this.getPathLabel().pack();
            }
            this.tableComposite.update(facilityId);
        } else {
            this.getPathLabel().setText(Messages.getString("filtered.list"));
            this.getPathLabel().pack();
            this.tableComposite.update(facilityId, this.condition);
        }
    }

    /**
     * ꤷޤ
     * <p>
     * 
     * updateϡθη̤ɽޤ
     * 
     * @param condition
     *            
     */
    public void setCondition(Property condition) {
        this.condition = condition;
    }

    /**
     * ȥӥ塼ޤ
     */
    public void dispose() {
        super.dispose();

        this.setCondition(null);
    }
}