/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.util;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManagerHome;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManagerUtil;

/**
 * QuartzManager饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class QuartzUtil {
    protected static Log m_log = LogFactory.getLog( QuartzUtil.class );
    
	/**
	 * QuartzManager
	 * 
     * @return
	 * @throws NamingException 
     */
	public static QuartzManager getQuartzManager() throws NamingException {
        m_log.debug("getQuartzManager()");

        //QuartzScheduleråå
		InitialContext context = null;
		QuartzManager manager = null;
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			Properties properties = new Properties(); 
			properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
			properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
			properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
			
			context = new InitialContext(properties);
			
			QuartzManagerHome home = (QuartzManagerHome)context.lookup(QuartzManagerHome.JNDI_NAME);
			try {
				manager = home.create();
			} catch (RemoteException e) {
			} catch (CreateException e) {
			}
		}
		else{
			context = new InitialContext();
			try {
				manager = QuartzManagerUtil.getHome().create();
			} catch (RemoteException e) {
			} catch (CreateException e) {
			}
		}
		
		return manager;
    }
}
